/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.tessellation;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.util.Pair;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.utils.TimeStampedPVCoordinates;

class HalfTrackSampler
implements OrekitFixedStepHandler {
    private final OneAxisEllipsoid ellipsoid;
    private final List<Pair<GeodeticPoint, TimeStampedPVCoordinates>> halfTrack;

    HalfTrackSampler(OneAxisEllipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
        this.halfTrack = new ArrayList<Pair<GeodeticPoint, TimeStampedPVCoordinates>>();
    }

    public List<Pair<GeodeticPoint, TimeStampedPVCoordinates>> getHalfTrack() {
        return this.halfTrack;
    }

    @Override
    public void handleStep(SpacecraftState currentState, boolean isLast) throws OrekitException {
        TimeStampedPVCoordinates pv = currentState.getPVCoordinates(this.ellipsoid.getBodyFrame());
        TimeStampedPVCoordinates groundPV = this.ellipsoid.projectToGround(pv, this.ellipsoid.getBodyFrame());
        GeodeticPoint gp = this.ellipsoid.transform(groundPV.getPosition(), this.ellipsoid.getBodyFrame(), currentState.getDate());
        this.halfTrack.add((Pair<GeodeticPoint, TimeStampedPVCoordinates>)new Pair((Object)gp, (Object)groundPV));
    }
}

