/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.SecularTrendSphericalHarmonics;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.DateComponents;

public class SHMFormatReader
extends PotentialCoefficientsReader {
    private static final String GRCOEF = "GRCOEF";
    private static final String GRCOF2 = "GRCOF2";
    private static final String GRDOTA = "GRDOTA";
    private DateComponents referenceDate = null;
    private final List<List<Double>> cDot = new ArrayList<List<Double>>();
    private final List<List<Double>> sDot = new ArrayList<List<Double>>();

    public SHMFormatReader(String supportedNames, boolean missingCoefficientsAllowed) {
        super(supportedNames, missingCoefficientsAllowed);
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.setReadComplete(false);
        this.referenceDate = null;
        this.cDot.clear();
        this.sDot.clear();
        boolean normalized = false;
        TideSystem tideSystem = TideSystem.UNKNOWN;
        BufferedReader r = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        boolean okEarth = false;
        boolean okSHM = false;
        boolean okCoeffs = false;
        double[][] c = null;
        double[][] s = null;
        String line = r.readLine();
        if (line != null && "FIRST ".equals(line.substring(0, 6)) && "SHM    ".equals(line.substring(49, 56))) {
            line = r.readLine();
            while (line != null) {
                if (line.length() >= 6) {
                    String[] tab = line.split("\\s+");
                    if ("EARTH".equals(tab[0])) {
                        this.setMu(SHMFormatReader.parseDouble(tab[1]));
                        this.setAe(SHMFormatReader.parseDouble(tab[2]));
                        okEarth = true;
                    }
                    if ("SHM".equals(tab[0])) {
                        int degree = FastMath.min((int)this.getMaxParseDegree(), (int)Integer.parseInt(tab[1]));
                        int order = FastMath.min((int)this.getMaxParseOrder(), (int)degree);
                        c = SHMFormatReader.buildTriangularArray(degree, order, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                        s = SHMFormatReader.buildTriangularArray(degree, order, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                        String lowerCaseLine = line.toLowerCase(Locale.US);
                        normalized = lowerCaseLine.contains("fully normalized");
                        tideSystem = lowerCaseLine.contains("exclusive permanent tide") ? TideSystem.TIDE_FREE : TideSystem.UNKNOWN;
                        okSHM = true;
                    }
                    if (GRCOEF.equals(line.substring(0, 6)) || GRCOF2.equals(tab[0]) || GRDOTA.equals(tab[0])) {
                        int i = Integer.parseInt(tab[1]);
                        int j = Integer.parseInt(tab[2]);
                        if (i < c.length && j < c[i].length) {
                            if (GRDOTA.equals(tab[0])) {
                                this.extendListOfLists(this.cDot, i, j, 0.0);
                                this.extendListOfLists(this.sDot, i, j, 0.0);
                                this.parseCoefficient(tab[3], this.cDot, i, j, "Cdot", name);
                                this.parseCoefficient(tab[4], this.sDot, i, j, "Sdot", name);
                                DateComponents localRef = new DateComponents(Integer.parseInt(tab[7].substring(0, 4)), Integer.parseInt(tab[7].substring(4, 6)), Integer.parseInt(tab[7].substring(6, 8)));
                                if (this.referenceDate == null) {
                                    this.referenceDate = localRef;
                                } else if (!this.referenceDate.equals(localRef)) {
                                    throw new OrekitException((Localizable)OrekitMessages.SEVERAL_REFERENCE_DATES_IN_GRAVITY_FIELD, this.referenceDate, localRef, name);
                                }
                            } else {
                                this.parseCoefficient(tab[3], c, i, j, "C", name);
                                this.parseCoefficient(tab[4], s, i, j, "S", name);
                                okCoeffs = true;
                            }
                        }
                    }
                }
                line = r.readLine();
            }
        }
        if (this.missingCoefficientsAllowed() && c.length > 0 && c[0].length > 0 && Precision.equals((double)c[0][0], (double)0.0, (int)0)) {
            c[0][0] = 1.0;
        }
        if (!(okEarth && okSHM && okCoeffs)) {
            String loaderName = this.getClass().getName();
            loaderName = loaderName.substring(loaderName.lastIndexOf(46) + 1);
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_FILE_FORMAT_ERROR_FOR_LOADER, name, loaderName);
        }
        this.setRawCoefficients(normalized, c, s, name);
        this.setTideSystem(tideSystem);
        this.setReadComplete(true);
    }

    @Override
    public RawSphericalHarmonicsProvider getProvider(boolean wantNormalized, int degree, int order) throws OrekitException {
        RawSphericalHarmonicsProvider provider = this.getConstantProvider(wantNormalized, degree, order);
        if (!this.cDot.isEmpty()) {
            double[][] cArray = this.toArray(this.cDot);
            double[][] sArray = this.toArray(this.sDot);
            SHMFormatReader.rescale(3.168808781402895E-8, true, cArray, sArray, wantNormalized, cArray, sArray);
            provider = new SecularTrendSphericalHarmonics(provider, this.referenceDate, cArray, sArray);
        }
        return provider;
    }
}

