/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.SphericalCoordinates;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.forces.AbstractForceModel;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.TideSystemProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class HolmesFeatherstoneAttractionModel
extends AbstractForceModel
implements TideSystemProvider {
    private static final int SCALING = 930;
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final ParameterDriver gmParameterDriver;
    private final NormalizedSphericalHarmonicsProvider provider;
    private final Frame bodyFrame;
    private final double[] gnmOj;
    private final double[] hnmOj;
    private final double[] enm;
    private final double[] sectorial;

    public HolmesFeatherstoneAttractionModel(Frame centralBodyFrame, NormalizedSphericalHarmonicsProvider provider) {
        int m;
        try {
            this.gmParameterDriver = new ParameterDriver("central attraction coefficient", provider.getMu(), MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
        this.provider = provider;
        this.bodyFrame = centralBodyFrame;
        int degree = provider.getMaxDegree();
        int size = FastMath.max((int)0, (int)(degree * (degree + 1) / 2 - 1));
        this.gnmOj = new double[size];
        this.hnmOj = new double[size];
        this.enm = new double[size];
        int index = 0;
        for (m = degree; m >= 0; --m) {
            int j = m == 0 ? 2 : 1;
            for (int n = FastMath.max((int)2, (int)(m + 1)); n <= degree; ++n) {
                double f = (n - m) * (n + m + 1);
                this.gnmOj[index] = (double)(2 * (m + 1)) / FastMath.sqrt((double)((double)j * f));
                this.hnmOj[index] = FastMath.sqrt((double)((double)((n + m + 2) * (n - m - 1)) / ((double)j * f)));
                this.enm[index] = FastMath.sqrt((double)(f / (double)j));
                ++index;
            }
        }
        this.sectorial = new double[degree + 1];
        this.sectorial[0] = FastMath.scalb((double)1.0, (int)-930);
        this.sectorial[1] = FastMath.sqrt((double)3.0) * this.sectorial[0];
        for (m = 2; m < this.sectorial.length; ++m) {
            this.sectorial[m] = FastMath.sqrt((double)((double)(2 * m + 1) / (2.0 * (double)m))) * this.sectorial[m - 1];
        }
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return true;
    }

    @Override
    public TideSystem getTideSystem() {
        return this.provider.getTideSystem();
    }

    public double getMu() {
        return this.gmParameterDriver.getValue();
    }

    public double value(AbsoluteDate date, Vector3D position, double mu) throws OrekitException {
        return mu / position.getNorm() + this.nonCentralPart(date, position, mu);
    }

    public double nonCentralPart(AbsoluteDate date, Vector3D position, double mu) throws OrekitException {
        int degree = this.provider.getMaxDegree();
        int order = this.provider.getMaxOrder();
        NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        double[] pnm0Plus2 = new double[degree + 1];
        double[] pnm0Plus1 = new double[degree + 1];
        double[] pnm0 = new double[degree + 1];
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        double x2 = x * x;
        double y2 = y * y;
        double z2 = z * z;
        double r2 = x2 + y2 + z2;
        double r = FastMath.sqrt((double)r2);
        double rho = FastMath.sqrt((double)(x2 + y2));
        double t = z / r;
        double u = rho / r;
        double tOu = z / rho;
        double[] aOrN = this.createDistancePowersArray(this.provider.getAe() / r);
        double[][] cosSinLambda = this.createCosSinArrays(position.getX() / rho, position.getY() / rho);
        int index = 0;
        double value = 0.0;
        for (int m = degree; m >= 0; --m) {
            index = this.computeTesseral(m, degree, index, t, u, tOu, pnm0Plus2, pnm0Plus1, null, pnm0, null, null);
            if (m <= order) {
                double sumDegreeS = 0.0;
                double sumDegreeC = 0.0;
                for (int n = FastMath.max((int)2, (int)m); n <= degree; ++n) {
                    sumDegreeS += pnm0[n] * aOrN[n] * harmonics.getNormalizedSnm(n, m);
                    sumDegreeC += pnm0[n] * aOrN[n] * harmonics.getNormalizedCnm(n, m);
                }
                value = value * u + cosSinLambda[1][m] * sumDegreeS + cosSinLambda[0][m] * sumDegreeC;
            }
            double[] tmp = pnm0Plus2;
            pnm0Plus2 = pnm0Plus1;
            pnm0Plus1 = pnm0;
            pnm0 = tmp;
        }
        value = FastMath.scalb((double)value, (int)930);
        return mu * value / r;
    }

    public double[] gradient(AbsoluteDate date, Vector3D position, double mu) throws OrekitException {
        int degree = this.provider.getMaxDegree();
        int order = this.provider.getMaxOrder();
        NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        double[] pnm0Plus2 = new double[degree + 1];
        double[] pnm0Plus1 = new double[degree + 1];
        double[] pnm0 = new double[degree + 1];
        double[] pnm1 = new double[degree + 1];
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        double x2 = x * x;
        double y2 = y * y;
        double z2 = z * z;
        double r2 = x2 + y2 + z2;
        double r = FastMath.sqrt((double)r2);
        double rho2 = x2 + y2;
        double rho = FastMath.sqrt((double)rho2);
        double t = z / r;
        double u = rho / r;
        double tOu = z / rho;
        double[] aOrN = this.createDistancePowersArray(this.provider.getAe() / r);
        double[][] cosSinLambda = this.createCosSinArrays(position.getX() / rho, position.getY() / rho);
        int index = 0;
        double value = 0.0;
        double[] gradient = new double[3];
        for (int m = degree; m >= 0; --m) {
            index = this.computeTesseral(m, degree, index, t, u, tOu, pnm0Plus2, pnm0Plus1, null, pnm0, pnm1, null);
            if (m <= order) {
                double sumDegreeS = 0.0;
                double sumDegreeC = 0.0;
                double dSumDegreeSdR = 0.0;
                double dSumDegreeCdR = 0.0;
                double dSumDegreeSdTheta = 0.0;
                double dSumDegreeCdTheta = 0.0;
                for (int n = FastMath.max((int)2, (int)m); n <= degree; ++n) {
                    double qSnm = aOrN[n] * harmonics.getNormalizedSnm(n, m);
                    double qCnm = aOrN[n] * harmonics.getNormalizedCnm(n, m);
                    double nOr = (double)n / r;
                    double s0 = pnm0[n] * qSnm;
                    double c0 = pnm0[n] * qCnm;
                    double s1 = pnm1[n] * qSnm;
                    double c1 = pnm1[n] * qCnm;
                    sumDegreeS += s0;
                    sumDegreeC += c0;
                    dSumDegreeSdR -= nOr * s0;
                    dSumDegreeCdR -= nOr * c0;
                    dSumDegreeSdTheta += s1;
                    dSumDegreeCdTheta += c1;
                }
                double sML = cosSinLambda[1][m];
                double cML = cosSinLambda[0][m];
                value = value * u + sML * sumDegreeS + cML * sumDegreeC;
                gradient[0] = gradient[0] * u + sML * dSumDegreeSdR + cML * dSumDegreeCdR;
                gradient[1] = gradient[1] * u + (double)m * (cML * sumDegreeS - sML * sumDegreeC);
                gradient[2] = gradient[2] * u + sML * dSumDegreeSdTheta + cML * dSumDegreeCdTheta;
            }
            double[] tmp = pnm0Plus2;
            pnm0Plus2 = pnm0Plus1;
            pnm0Plus1 = pnm0;
            pnm0 = tmp;
        }
        value = FastMath.scalb((double)value, (int)930);
        gradient[0] = FastMath.scalb((double)gradient[0], (int)930);
        gradient[1] = FastMath.scalb((double)gradient[1], (int)930);
        gradient[2] = FastMath.scalb((double)gradient[2], (int)930);
        double muOr = mu / r;
        gradient[0] = muOr * gradient[0] - (value *= muOr) / r;
        gradient[1] = gradient[1] * muOr;
        gradient[2] = gradient[2] * muOr;
        return new SphericalCoordinates(position).toCartesianGradient(gradient);
    }

    public <T extends RealFieldElement<T>> T[] gradient(FieldAbsoluteDate<T> date, FieldVector3D<T> position, T mu) throws OrekitException {
        int degree = this.provider.getMaxDegree();
        int order = this.provider.getMaxOrder();
        NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics harmonics = this.provider.onDate(date.toAbsoluteDate());
        RealFieldElement zero = (RealFieldElement)date.getField().getZero();
        RealFieldElement[] pnm0Plus2 = (RealFieldElement[])MathArrays.buildArray(date.getField(), (int)(degree + 1));
        RealFieldElement[] pnm0Plus1 = (RealFieldElement[])MathArrays.buildArray(date.getField(), (int)(degree + 1));
        RealFieldElement[] pnm0 = (RealFieldElement[])MathArrays.buildArray(date.getField(), (int)(degree + 1));
        RealFieldElement[] pnm1 = (RealFieldElement[])MathArrays.buildArray(date.getField(), (int)(degree + 1));
        RealFieldElement x = position.getX();
        RealFieldElement y = position.getY();
        RealFieldElement z = position.getZ();
        RealFieldElement x2 = (RealFieldElement)x.multiply((Object)x);
        RealFieldElement y2 = (RealFieldElement)y.multiply((Object)y);
        RealFieldElement z2 = (RealFieldElement)z.multiply((Object)z);
        RealFieldElement r2 = (RealFieldElement)((RealFieldElement)x2.add((Object)y2)).add((Object)z2);
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement rho2 = (RealFieldElement)x2.add((Object)y2);
        RealFieldElement rho = (RealFieldElement)rho2.sqrt();
        RealFieldElement t = (RealFieldElement)z.divide((Object)r);
        RealFieldElement u = (RealFieldElement)rho.divide((Object)r);
        RealFieldElement tOu = (RealFieldElement)z.divide((Object)rho);
        RealFieldElement[] aOrN = this.createDistancePowersArray((RealFieldElement)((RealFieldElement)r.reciprocal()).multiply(this.provider.getAe()));
        RealFieldElement[][] cosSinLambda = this.createCosSinArrays((RealFieldElement)((RealFieldElement)rho.reciprocal()).multiply((Object)position.getX()), (RealFieldElement)((RealFieldElement)rho.reciprocal()).multiply((Object)position.getY()));
        int index = 0;
        RealFieldElement value = zero;
        RealFieldElement[] gradient = (RealFieldElement[])MathArrays.buildArray((Field)zero.getField(), (int)3);
        for (int m = degree; m >= 0; --m) {
            index = this.computeTesseral(m, degree, index, t, u, tOu, pnm0Plus2, pnm0Plus1, null, pnm0, pnm1, null);
            if (m <= order) {
                RealFieldElement sumDegreeS = zero;
                RealFieldElement sumDegreeC = zero;
                RealFieldElement dSumDegreeSdR = zero;
                RealFieldElement dSumDegreeCdR = zero;
                RealFieldElement dSumDegreeSdTheta = zero;
                RealFieldElement dSumDegreeCdTheta = zero;
                for (int n = FastMath.max((int)2, (int)m); n <= degree; ++n) {
                    RealFieldElement qSnm = (RealFieldElement)aOrN[n].multiply(harmonics.getNormalizedSnm(n, m));
                    RealFieldElement qCnm = (RealFieldElement)aOrN[n].multiply(harmonics.getNormalizedCnm(n, m));
                    RealFieldElement nOr = (RealFieldElement)((RealFieldElement)r.reciprocal()).multiply(n);
                    RealFieldElement s0 = (RealFieldElement)pnm0[n].multiply((Object)qSnm);
                    RealFieldElement c0 = (RealFieldElement)pnm0[n].multiply((Object)qCnm);
                    RealFieldElement s1 = (RealFieldElement)pnm1[n].multiply((Object)qSnm);
                    RealFieldElement c1 = (RealFieldElement)pnm1[n].multiply((Object)qCnm);
                    sumDegreeS = (RealFieldElement)sumDegreeS.add((Object)s0);
                    sumDegreeC = (RealFieldElement)sumDegreeC.add((Object)c0);
                    dSumDegreeSdR = (RealFieldElement)dSumDegreeSdR.subtract(nOr.multiply((Object)s0));
                    dSumDegreeCdR = (RealFieldElement)dSumDegreeCdR.subtract(nOr.multiply((Object)c0));
                    dSumDegreeSdTheta = (RealFieldElement)dSumDegreeSdTheta.add((Object)s1);
                    dSumDegreeCdTheta = (RealFieldElement)dSumDegreeCdTheta.add((Object)c1);
                }
                RealFieldElement sML = cosSinLambda[1][m];
                RealFieldElement cML = cosSinLambda[0][m];
                value = (RealFieldElement)((RealFieldElement)((RealFieldElement)value.multiply((Object)u)).add(sML.multiply((Object)sumDegreeS))).add(cML.multiply((Object)sumDegreeC));
                gradient[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)gradient[0].multiply((Object)u)).add(sML.multiply((Object)dSumDegreeSdR))).add(cML.multiply((Object)dSumDegreeCdR));
                gradient[1] = (RealFieldElement)((RealFieldElement)gradient[1].multiply((Object)u)).add(((RealFieldElement)((RealFieldElement)cML.multiply((Object)sumDegreeS)).subtract(sML.multiply((Object)sumDegreeC))).multiply(m));
                gradient[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)gradient[2].multiply((Object)u)).add(sML.multiply((Object)dSumDegreeSdTheta))).add(cML.multiply((Object)dSumDegreeCdTheta));
            }
            RealFieldElement[] tmp = pnm0Plus2;
            pnm0Plus2 = pnm0Plus1;
            pnm0Plus1 = pnm0;
            pnm0 = tmp;
        }
        value = (RealFieldElement)value.scalb(930);
        gradient[0] = (RealFieldElement)gradient[0].scalb(930);
        gradient[1] = (RealFieldElement)gradient[1].scalb(930);
        gradient[2] = (RealFieldElement)gradient[2].scalb(930);
        RealFieldElement muOr = (RealFieldElement)((RealFieldElement)r.reciprocal()).multiply(mu);
        value = (RealFieldElement)value.multiply((Object)muOr);
        gradient[0] = (RealFieldElement)((RealFieldElement)muOr.multiply((Object)gradient[0])).subtract(value.divide((Object)r));
        gradient[1] = (RealFieldElement)gradient[1].multiply((Object)muOr);
        gradient[2] = (RealFieldElement)gradient[2].multiply((Object)muOr);
        RealFieldElement rPos = position.getNorm();
        RealFieldElement xPos = position.getX();
        RealFieldElement yPos = position.getY();
        RealFieldElement zPos = position.getZ();
        RealFieldElement rho2Pos = (RealFieldElement)((RealFieldElement)x.multiply((Object)x)).add(y.multiply((Object)y));
        RealFieldElement rhoPos = (RealFieldElement)rho2.sqrt();
        RealFieldElement r2Pos = (RealFieldElement)rho2.add(z.multiply((Object)z));
        RealFieldElement[][] jacobianPos = (RealFieldElement[][])MathArrays.buildArray((Field)zero.getField(), (int)3, (int)3);
        jacobianPos[0][0] = (RealFieldElement)xPos.divide((Object)rPos);
        jacobianPos[0][1] = (RealFieldElement)yPos.divide((Object)rPos);
        jacobianPos[0][2] = (RealFieldElement)zPos.divide((Object)rPos);
        jacobianPos[1][0] = (RealFieldElement)((RealFieldElement)yPos.negate()).divide((Object)rho2Pos);
        jacobianPos[1][1] = (RealFieldElement)xPos.divide((Object)rho2Pos);
        jacobianPos[2][0] = (RealFieldElement)((RealFieldElement)xPos.multiply((Object)zPos)).divide(rhoPos.multiply((Object)r2Pos));
        jacobianPos[2][1] = (RealFieldElement)((RealFieldElement)yPos.multiply((Object)zPos)).divide(rhoPos.multiply((Object)r2Pos));
        jacobianPos[2][2] = (RealFieldElement)((RealFieldElement)rhoPos.negate()).divide((Object)r2Pos);
        RealFieldElement[] cartGradPos = (RealFieldElement[])MathArrays.buildArray((Field)zero.getField(), (int)3);
        cartGradPos[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)gradient[0].multiply((Object)jacobianPos[0][0])).add(gradient[1].multiply((Object)jacobianPos[1][0]))).add(gradient[2].multiply((Object)jacobianPos[2][0]));
        cartGradPos[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)gradient[0].multiply((Object)jacobianPos[0][1])).add(gradient[1].multiply((Object)jacobianPos[1][1]))).add(gradient[2].multiply((Object)jacobianPos[2][1]));
        cartGradPos[2] = (RealFieldElement)((RealFieldElement)gradient[0].multiply((Object)jacobianPos[0][2])).add(gradient[2].multiply((Object)jacobianPos[2][2]));
        return cartGradPos;
    }

    private GradientHessian gradientHessian(AbsoluteDate date, Vector3D position, double mu) throws OrekitException {
        int degree = this.provider.getMaxDegree();
        int order = this.provider.getMaxOrder();
        NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        double[] pnm0Plus2 = new double[degree + 1];
        double[] pnm0Plus1 = new double[degree + 1];
        double[] pnm0 = new double[degree + 1];
        double[] pnm1Plus1 = new double[degree + 1];
        double[] pnm1 = new double[degree + 1];
        double[] pnm2 = new double[degree + 1];
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        double x2 = x * x;
        double y2 = y * y;
        double z2 = z * z;
        double r2 = x2 + y2 + z2;
        double r = FastMath.sqrt((double)r2);
        double rho2 = x2 + y2;
        double rho = FastMath.sqrt((double)rho2);
        double t = z / r;
        double u = rho / r;
        double tOu = z / rho;
        double[] aOrN = this.createDistancePowersArray(this.provider.getAe() / r);
        double[][] cosSinLambda = this.createCosSinArrays(position.getX() / rho, position.getY() / rho);
        int index = 0;
        double value = 0.0;
        double[] gradient = new double[3];
        double[][] hessian = new double[3][3];
        for (int m = degree; m >= 0; --m) {
            index = this.computeTesseral(m, degree, index, t, u, tOu, pnm0Plus2, pnm0Plus1, pnm1Plus1, pnm0, pnm1, pnm2);
            if (m <= order) {
                double sumDegreeS = 0.0;
                double sumDegreeC = 0.0;
                double dSumDegreeSdR = 0.0;
                double dSumDegreeCdR = 0.0;
                double dSumDegreeSdTheta = 0.0;
                double dSumDegreeCdTheta = 0.0;
                double d2SumDegreeSdRdR = 0.0;
                double d2SumDegreeSdRdTheta = 0.0;
                double d2SumDegreeSdThetadTheta = 0.0;
                double d2SumDegreeCdRdR = 0.0;
                double d2SumDegreeCdRdTheta = 0.0;
                double d2SumDegreeCdThetadTheta = 0.0;
                for (int n = FastMath.max((int)2, (int)m); n <= degree; ++n) {
                    double qSnm = aOrN[n] * harmonics.getNormalizedSnm(n, m);
                    double qCnm = aOrN[n] * harmonics.getNormalizedCnm(n, m);
                    double nOr = (double)n / r;
                    double nnP1Or2 = nOr * (double)(n + 1) / r;
                    double s0 = pnm0[n] * qSnm;
                    double c0 = pnm0[n] * qCnm;
                    double s1 = pnm1[n] * qSnm;
                    double c1 = pnm1[n] * qCnm;
                    double s2 = pnm2[n] * qSnm;
                    double c2 = pnm2[n] * qCnm;
                    sumDegreeS += s0;
                    sumDegreeC += c0;
                    dSumDegreeSdR -= nOr * s0;
                    dSumDegreeCdR -= nOr * c0;
                    dSumDegreeSdTheta += s1;
                    dSumDegreeCdTheta += c1;
                    d2SumDegreeSdRdR += nnP1Or2 * s0;
                    d2SumDegreeSdRdTheta -= nOr * s1;
                    d2SumDegreeSdThetadTheta += s2;
                    d2SumDegreeCdRdR += nnP1Or2 * c0;
                    d2SumDegreeCdRdTheta -= nOr * c1;
                    d2SumDegreeCdThetadTheta += c2;
                }
                double sML = cosSinLambda[1][m];
                double cML = cosSinLambda[0][m];
                value = value * u + sML * sumDegreeS + cML * sumDegreeC;
                gradient[0] = gradient[0] * u + sML * dSumDegreeSdR + cML * dSumDegreeCdR;
                gradient[1] = gradient[1] * u + (double)m * (cML * sumDegreeS - sML * sumDegreeC);
                gradient[2] = gradient[2] * u + sML * dSumDegreeSdTheta + cML * dSumDegreeCdTheta;
                hessian[0][0] = hessian[0][0] * u + sML * d2SumDegreeSdRdR + cML * d2SumDegreeCdRdR;
                hessian[1][0] = hessian[1][0] * u + (double)m * (cML * dSumDegreeSdR - sML * dSumDegreeCdR);
                hessian[2][0] = hessian[2][0] * u + sML * d2SumDegreeSdRdTheta + cML * d2SumDegreeCdRdTheta;
                hessian[1][1] = hessian[1][1] * u - (double)(m * m) * (sML * sumDegreeS + cML * sumDegreeC);
                hessian[2][1] = hessian[2][1] * u + (double)m * (cML * dSumDegreeSdTheta - sML * dSumDegreeCdTheta);
                hessian[2][2] = hessian[2][2] * u + sML * d2SumDegreeSdThetadTheta + cML * d2SumDegreeCdThetadTheta;
            }
            double[] tmp0 = pnm0Plus2;
            pnm0Plus2 = pnm0Plus1;
            pnm0Plus1 = pnm0;
            pnm0 = tmp0;
            double[] tmp1 = pnm1Plus1;
            pnm1Plus1 = pnm1;
            pnm1 = tmp1;
        }
        value = FastMath.scalb((double)value, (int)930);
        for (int i = 0; i < 3; ++i) {
            gradient[i] = FastMath.scalb((double)gradient[i], (int)930);
            for (int j = 0; j <= i; ++j) {
                hessian[i][j] = FastMath.scalb((double)hessian[i][j], (int)930);
            }
        }
        double muOr = mu / r;
        gradient[0] = muOr * gradient[0] - (value *= muOr) / r;
        gradient[1] = gradient[1] * muOr;
        gradient[2] = gradient[2] * muOr;
        hessian[0][0] = muOr * hessian[0][0] - 2.0 * gradient[0] / r;
        hessian[1][0] = muOr * hessian[1][0] - gradient[1] / r;
        hessian[2][0] = muOr * hessian[2][0] - gradient[2] / r;
        double[] dArray = hessian[1];
        dArray[1] = dArray[1] * muOr;
        double[] dArray2 = hessian[2];
        dArray2[1] = dArray2[1] * muOr;
        double[] dArray3 = hessian[2];
        dArray3[2] = dArray3[2] * muOr;
        SphericalCoordinates sc = new SphericalCoordinates(position);
        return new GradientHessian(sc.toCartesianGradient(gradient), sc.toCartesianHessian(hessian, gradient));
    }

    private double[] createDistancePowersArray(double aOr) {
        double[] aOrN = new double[this.provider.getMaxDegree() + 1];
        aOrN[0] = 1.0;
        aOrN[1] = aOr;
        for (int n = 2; n < aOrN.length; ++n) {
            int p = n / 2;
            int q = n - p;
            aOrN[n] = aOrN[p] * aOrN[q];
        }
        return aOrN;
    }

    private <T extends RealFieldElement<T>> T[] createDistancePowersArray(T aOr) {
        RealFieldElement[] aOrN = (RealFieldElement[])MathArrays.buildArray((Field)aOr.getField(), (int)(this.provider.getMaxDegree() + 1));
        aOrN[0] = (RealFieldElement)aOr.getField().getOne();
        aOrN[1] = aOr;
        for (int n = 2; n < aOrN.length; ++n) {
            int p = n / 2;
            int q = n - p;
            aOrN[n] = (RealFieldElement)aOrN[p].multiply((Object)aOrN[q]);
        }
        return aOrN;
    }

    private double[][] createCosSinArrays(double cosLambda, double sinLambda) {
        double[][] cosSin = new double[2][this.provider.getMaxOrder() + 1];
        cosSin[0][0] = 1.0;
        cosSin[1][0] = 0.0;
        if (this.provider.getMaxOrder() > 0) {
            cosSin[0][1] = cosLambda;
            cosSin[1][1] = sinLambda;
            for (int m = 2; m < cosSin[0].length; ++m) {
                int p = m / 2;
                int q = m - p;
                cosSin[0][m] = cosSin[0][p] * cosSin[0][q] - cosSin[1][p] * cosSin[1][q];
                cosSin[1][m] = cosSin[1][p] * cosSin[0][q] + cosSin[0][p] * cosSin[1][q];
            }
        }
        return cosSin;
    }

    private <T extends RealFieldElement<T>> T[][] createCosSinArrays(T cosLambda, T sinLambda) {
        RealFieldElement one = (RealFieldElement)cosLambda.getField().getOne();
        RealFieldElement zero = (RealFieldElement)cosLambda.getField().getZero();
        RealFieldElement[][] cosSin = (RealFieldElement[][])MathArrays.buildArray((Field)one.getField(), (int)2, (int)(this.provider.getMaxOrder() + 1));
        cosSin[0][0] = one;
        cosSin[1][0] = zero;
        if (this.provider.getMaxOrder() > 0) {
            cosSin[0][1] = cosLambda;
            cosSin[1][1] = sinLambda;
            for (int m = 2; m < cosSin[0].length; ++m) {
                int p = m / 2;
                int q = m - p;
                cosSin[0][m] = (RealFieldElement)((RealFieldElement)cosSin[0][p].multiply((Object)cosSin[0][q])).subtract(cosSin[1][p].multiply((Object)cosSin[1][q]));
                cosSin[1][m] = (RealFieldElement)((RealFieldElement)cosSin[1][p].multiply((Object)cosSin[0][q])).add(cosSin[0][p].multiply((Object)cosSin[1][q]));
            }
        }
        return cosSin;
    }

    private int computeTesseral(int m, int degree, int index, double t, double u, double tOu, double[] pnm0Plus2, double[] pnm0Plus1, double[] pnm1Plus1, double[] pnm0, double[] pnm1, double[] pnm2) {
        double u2 = u * u;
        int n = FastMath.max((int)2, (int)m);
        if (n == m) {
            pnm0[n] = this.sectorial[n];
            ++n;
        }
        int localIndex = index;
        while (n <= degree) {
            pnm0[n] = this.gnmOj[localIndex] * t * pnm0Plus1[n] - this.hnmOj[localIndex] * u2 * pnm0Plus2[n];
            ++localIndex;
            ++n;
        }
        if (pnm1 != null) {
            n = FastMath.max((int)2, (int)m);
            if (n == m) {
                pnm1[n] = (double)m * tOu * pnm0[n];
                ++n;
            }
            localIndex = index;
            while (n <= degree) {
                pnm1[n] = (double)m * tOu * pnm0[n] - this.enm[localIndex] * u * pnm0Plus1[n];
                ++localIndex;
                ++n;
            }
            if (pnm2 != null) {
                n = FastMath.max((int)2, (int)m);
                if (n == m) {
                    pnm2[n] = (double)m * (tOu * pnm1[n] - pnm0[n] / u2);
                    ++n;
                }
                localIndex = index;
                while (n <= degree) {
                    pnm2[n] = (double)m * (tOu * pnm1[n] - pnm0[n] / u2) - this.enm[localIndex] * u * pnm1Plus1[n];
                    ++localIndex;
                    ++n;
                }
            }
        }
        return localIndex;
    }

    private <T extends RealFieldElement<T>> int computeTesseral(int m, int degree, int index, T t, T u, T tOu, T[] pnm0Plus2, T[] pnm0Plus1, T[] pnm1Plus1, T[] pnm0, T[] pnm1, T[] pnm2) {
        RealFieldElement u2 = (RealFieldElement)u.multiply(u);
        RealFieldElement zero = (RealFieldElement)u.getField().getZero();
        int n = FastMath.max((int)2, (int)m);
        if (n == m) {
            pnm0[n] = (RealFieldElement)zero.add(this.sectorial[n]);
            ++n;
        }
        int localIndex = index;
        while (n <= degree) {
            pnm0[n] = (RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(this.gnmOj[localIndex])).multiply(pnm0Plus1[n])).subtract(((RealFieldElement)u2.multiply(pnm0Plus2[n])).multiply(this.hnmOj[localIndex]));
            ++localIndex;
            ++n;
        }
        if (pnm1 != null) {
            n = FastMath.max((int)2, (int)m);
            if (n == m) {
                pnm1[n] = (RealFieldElement)((RealFieldElement)tOu.multiply(m)).multiply(pnm0[n]);
                ++n;
            }
            localIndex = index;
            while (n <= degree) {
                pnm1[n] = (RealFieldElement)((RealFieldElement)((RealFieldElement)tOu.multiply(m)).multiply(pnm0[n])).subtract(((RealFieldElement)u.multiply(this.enm[localIndex])).multiply(pnm0Plus1[n]));
                ++localIndex;
                ++n;
            }
            if (pnm2 != null) {
                n = FastMath.max((int)2, (int)m);
                if (n == m) {
                    pnm2[n] = (RealFieldElement)((RealFieldElement)((RealFieldElement)tOu.multiply(pnm1[n])).subtract(pnm0[n].divide((Object)u2))).multiply(m);
                    ++n;
                }
                localIndex = index;
                while (n <= degree) {
                    pnm2[n] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)tOu.multiply(pnm1[n])).subtract(pnm0[n].divide((Object)u2))).multiply(m)).subtract(((RealFieldElement)u.multiply(pnm1Plus1[n])).multiply(this.enm[localIndex]));
                    ++localIndex;
                    ++n;
                }
            }
        }
        return localIndex;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) throws OrekitException {
        double mu = parameters[0];
        AbsoluteDate date = s.getDate();
        Transform fromBodyFrame = this.bodyFrame.getTransformTo(s.getFrame(), date);
        Transform toBodyFrame = fromBodyFrame.getInverse();
        Vector3D position = toBodyFrame.transformPosition(s.getPVCoordinates().getPosition());
        return fromBodyFrame.transformVector(new Vector3D(this.gradient(date, position, mu)));
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) throws OrekitException {
        T mu = parameters[0];
        if (this.isStateDerivative(s)) {
            FieldVector3D p = s.getPVCoordinates().getPosition();
            FieldVector3D<DerivativeStructure> a = this.accelerationWrtState(s.getDate().toAbsoluteDate(), s.getFrame(), p, (DerivativeStructure)mu);
            return a;
        }
        FieldAbsoluteDate<T> date = s.getDate();
        Transform fromBodyFrame = this.bodyFrame.getTransformTo(s.getFrame(), date.toAbsoluteDate());
        Transform toBodyFrame = fromBodyFrame.getInverse();
        FieldVector3D position = toBodyFrame.transformPosition(s.getPVCoordinates().getPosition());
        return fromBodyFrame.transformVector(new FieldVector3D(this.gradient(date, position, (RealFieldElement)mu)));
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    private <T extends RealFieldElement<T>> boolean isStateDerivative(FieldSpacecraftState<T> state) {
        try {
            DerivativeStructure dsMass = (DerivativeStructure)state.getMass();
            int o = dsMass.getOrder();
            int p = dsMass.getFreeParameters();
            if (o != 1 || p < 3) {
                return false;
            }
            TimeStampedFieldPVCoordinates<T> pv = state.getPVCoordinates();
            return this.isVariable((DerivativeStructure)pv.getPosition().getX(), 0) && this.isVariable((DerivativeStructure)pv.getPosition().getY(), 1) && this.isVariable((DerivativeStructure)pv.getPosition().getZ(), 2);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    private boolean isVariable(DerivativeStructure ds, int index) {
        double[] derivatives = ds.getAllDerivatives();
        boolean check = true;
        for (int i = 1; i < derivatives.length; ++i) {
            check &= derivatives[i] == (index + 1 == i ? 1.0 : 0.0);
        }
        return check;
    }

    private FieldVector3D<DerivativeStructure> accelerationWrtState(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, DerivativeStructure mu) throws OrekitException {
        Transform fromBodyFrame = this.bodyFrame.getTransformTo(frame, date);
        Transform toBodyFrame = fromBodyFrame.getInverse();
        Vector3D positionBody = toBodyFrame.transformPosition(position.toVector3D());
        GradientHessian gh = this.gradientHessian(date, positionBody, mu.getReal());
        double[] gInertial = fromBodyFrame.transformVector(new Vector3D(gh.getGradient())).toArray();
        Array2DRowRealMatrix hBody = new Array2DRowRealMatrix(gh.getHessian(), false);
        Array2DRowRealMatrix rot = new Array2DRowRealMatrix(toBodyFrame.getRotation().getMatrix());
        RealMatrix hInertial = rot.transpose().multiply((RealMatrix)hBody).multiply((RealMatrix)rot);
        double[] derivatives = new double[1 + ((DerivativeStructure)position.getX()).getFreeParameters()];
        DerivativeStructure[] accDer = new DerivativeStructure[3];
        for (int i = 0; i < 3; ++i) {
            derivatives[0] = gInertial[i];
            derivatives[1] = hInertial.getEntry(i, 0);
            derivatives[2] = hInertial.getEntry(i, 1);
            derivatives[3] = hInertial.getEntry(i, 2);
            if (derivatives.length > 4 && this.isVariable(mu, 3)) {
                derivatives[4] = gInertial[i] / mu.getReal();
            }
            accDer[i] = ((DerivativeStructure)position.getX()).getFactory().build(derivatives);
        }
        return new FieldVector3D((RealFieldElement[])accDer);
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[]{this.gmParameterDriver};
    }

    private static class GradientHessian {
        private final double[] gradient;
        private final double[][] hessian;

        GradientHessian(double[] gradient, double[][] hessian) {
            this.gradient = gradient;
            this.hessian = hessian;
        }

        public double[] getGradient() {
            return this.gradient;
        }

        public double[][] getHessian() {
            return this.hessian;
        }
    }
}

