/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Map;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class GroundStation {
    public static final String OFFSET_SUFFIX = "-offset";
    public static final String INTERMEDIATE_SUFFIX = "-intermediate";
    private static final double OFFSET_SCALE = FastMath.scalb((double)1.0, (int)0);
    private static final double ANGULAR_SCALE = FastMath.scalb((double)1.0, (int)-22);
    private final TopocentricFrame baseFrame;
    private final ParameterDriver eastOffsetDriver;
    private final ParameterDriver northOffsetDriver;
    private final ParameterDriver zenithOffsetDriver;
    private final ParameterDriver primeMeridianOffsetDriver;
    private final ParameterDriver primeMeridianDriftDriver;
    private final ParameterDriver polarOffsetXDriver;
    private final ParameterDriver polarDriftXDriver;
    private final ParameterDriver polarOffsetYDriver;
    private final ParameterDriver polarDriftYDriver;

    public GroundStation(TopocentricFrame baseFrame) throws OrekitException {
        this.baseFrame = baseFrame;
        this.eastOffsetDriver = new ParameterDriver(baseFrame.getName() + OFFSET_SUFFIX + "-East", 0.0, OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.northOffsetDriver = new ParameterDriver(baseFrame.getName() + OFFSET_SUFFIX + "-North", 0.0, OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.zenithOffsetDriver = new ParameterDriver(baseFrame.getName() + OFFSET_SUFFIX + "-Zenith", 0.0, OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.primeMeridianOffsetDriver = new ParameterDriver("prime-meridian-offset", 0.0, ANGULAR_SCALE, -Math.PI, Math.PI);
        this.primeMeridianDriftDriver = new ParameterDriver("prime-meridian-drift", 0.0, ANGULAR_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.polarOffsetXDriver = new ParameterDriver("polar-offset-X", 0.0, ANGULAR_SCALE, -Math.PI, Math.PI);
        this.polarDriftXDriver = new ParameterDriver("polar-drift-X", 0.0, ANGULAR_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.polarOffsetYDriver = new ParameterDriver("polar-offset-Y", 0.0, ANGULAR_SCALE, -Math.PI, Math.PI);
        this.polarDriftYDriver = new ParameterDriver("polar-drift-Y", 0.0, ANGULAR_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public ParameterDriver getEastOffsetDriver() {
        return this.eastOffsetDriver;
    }

    public ParameterDriver getNorthOffsetDriver() {
        return this.northOffsetDriver;
    }

    public ParameterDriver getZenithOffsetDriver() {
        return this.zenithOffsetDriver;
    }

    public ParameterDriver getPrimeMeridianOffsetDriver() {
        return this.primeMeridianOffsetDriver;
    }

    public ParameterDriver getPrimeMeridianDriftDriver() {
        return this.primeMeridianDriftDriver;
    }

    public ParameterDriver getPolarOffsetXDriver() {
        return this.polarOffsetXDriver;
    }

    public ParameterDriver getPolarDriftXDriver() {
        return this.polarDriftXDriver;
    }

    public ParameterDriver getPolarOffsetYDriver() {
        return this.polarOffsetYDriver;
    }

    public ParameterDriver getPolarDriftYDriver() {
        return this.polarDriftYDriver;
    }

    public TopocentricFrame getBaseFrame() {
        return this.baseFrame;
    }

    public GeodeticPoint getOffsetGeodeticPoint() throws OrekitException {
        double x = this.parametricModel(this.eastOffsetDriver);
        double y = this.parametricModel(this.northOffsetDriver);
        double z = this.parametricModel(this.zenithOffsetDriver);
        BodyShape baseShape = this.baseFrame.getParentShape();
        Transform baseToBody = this.baseFrame.getTransformTo(baseShape.getBodyFrame(), (AbsoluteDate)null);
        Vector3D origin = baseToBody.transformPosition(new Vector3D(x, y, z));
        return baseShape.transform(origin, baseShape.getBodyFrame(), null);
    }

    public Transform getOffsetToInertial(Frame inertial, AbsoluteDate date) throws OrekitException {
        double theta = this.linearModel(date, this.primeMeridianOffsetDriver, this.primeMeridianDriftDriver);
        double thetaDot = this.parametricModel(this.primeMeridianDriftDriver);
        Transform meridianShift = new Transform(date, new Rotation(Vector3D.PLUS_K, -theta, RotationConvention.FRAME_TRANSFORM), new Vector3D(-thetaDot, Vector3D.PLUS_K));
        double xp = this.linearModel(date, this.polarOffsetXDriver, this.polarDriftXDriver);
        double yp = this.linearModel(date, this.polarOffsetYDriver, this.polarDriftYDriver);
        double xpDot = this.parametricModel(this.polarDriftXDriver);
        double ypDot = this.parametricModel(this.polarDriftYDriver);
        Transform poleShift = new Transform(date, new Transform(date, new Rotation(Vector3D.PLUS_I, yp, RotationConvention.FRAME_TRANSFORM), new Vector3D(ypDot, 0.0, 0.0)), new Transform(date, new Rotation(Vector3D.PLUS_J, xp, RotationConvention.FRAME_TRANSFORM), new Vector3D(0.0, xpDot, 0.0)));
        double x = this.parametricModel(this.eastOffsetDriver);
        double y = this.parametricModel(this.northOffsetDriver);
        double z = this.parametricModel(this.zenithOffsetDriver);
        BodyShape baseShape = this.baseFrame.getParentShape();
        Transform baseToBody = this.baseFrame.getTransformTo(baseShape.getBodyFrame(), (AbsoluteDate)null);
        Vector3D origin = baseToBody.transformPosition(new Vector3D(x, y, z));
        GeodeticPoint originGP = baseShape.transform(origin, baseShape.getBodyFrame(), date);
        Transform offsetToIntermediate = new Transform(date, new Transform(date, new Rotation(Vector3D.PLUS_I, Vector3D.PLUS_K, originGP.getEast(), originGP.getZenith()), Vector3D.ZERO), new Transform(date, origin));
        Transform intermediateToBody = new Transform(date, poleShift, meridianShift);
        Transform bodyToInert = this.baseFrame.getParent().getTransformTo(inertial, date);
        return new Transform(date, offsetToIntermediate, new Transform(date, intermediateToBody, bodyToInert));
    }

    public FieldTransform<DerivativeStructure> getOffsetToInertial(Frame inertial, FieldAbsoluteDate<DerivativeStructure> date, DSFactory factory, Map<String, Integer> indices) throws OrekitException {
        Field<DerivativeStructure> field = date.getField();
        FieldVector3D zero = FieldVector3D.getZero(field);
        FieldVector3D plusI = FieldVector3D.getPlusI(field);
        FieldVector3D plusJ = FieldVector3D.getPlusJ(field);
        FieldVector3D plusK = FieldVector3D.getPlusK(field);
        DerivativeStructure theta = this.linearModel(factory, date, this.primeMeridianOffsetDriver, this.primeMeridianDriftDriver, indices);
        DerivativeStructure thetaDot = this.parametricModel(factory, this.primeMeridianDriftDriver, indices);
        FieldTransform<DerivativeStructure> meridianShift = new FieldTransform<DerivativeStructure>(date, new FieldRotation(plusK, (RealFieldElement)theta.negate(), RotationConvention.FRAME_TRANSFORM), new FieldVector3D((RealFieldElement)thetaDot.negate(), plusK));
        DerivativeStructure xp = this.linearModel(factory, date, this.polarOffsetXDriver, this.polarDriftXDriver, indices);
        DerivativeStructure yp = this.linearModel(factory, date, this.polarOffsetYDriver, this.polarDriftYDriver, indices);
        DerivativeStructure xpDot = this.parametricModel(factory, this.polarDriftXDriver, indices);
        DerivativeStructure ypDot = this.parametricModel(factory, this.polarDriftYDriver, indices);
        FieldTransform<DerivativeStructure> poleShift = new FieldTransform<DerivativeStructure>(date, new FieldTransform<DerivativeStructure>(date, new FieldRotation(plusI, (RealFieldElement)yp, RotationConvention.FRAME_TRANSFORM), new FieldVector3D((RealFieldElement)ypDot, (RealFieldElement)field.getZero(), (RealFieldElement)field.getZero())), new FieldTransform<DerivativeStructure>(date, new FieldRotation(plusJ, (RealFieldElement)xp, RotationConvention.FRAME_TRANSFORM), new FieldVector3D((RealFieldElement)field.getZero(), (RealFieldElement)xpDot, (RealFieldElement)field.getZero())));
        DerivativeStructure x = this.parametricModel(factory, this.eastOffsetDriver, indices);
        DerivativeStructure y = this.parametricModel(factory, this.northOffsetDriver, indices);
        DerivativeStructure z = this.parametricModel(factory, this.zenithOffsetDriver, indices);
        BodyShape baseShape = this.baseFrame.getParentShape();
        Transform baseToBody = this.baseFrame.getTransformTo(baseShape.getBodyFrame(), (AbsoluteDate)null);
        FieldVector3D origin = baseToBody.transformPosition(new FieldVector3D((RealFieldElement)x, (RealFieldElement)y, (RealFieldElement)z));
        FieldGeodeticPoint<DerivativeStructure> originGP = baseShape.transform(origin, baseShape.getBodyFrame(), date);
        FieldTransform<DerivativeStructure> offsetToIntermediate = new FieldTransform<DerivativeStructure>(date, new FieldTransform<DerivativeStructure>(date, new FieldRotation(plusI, plusK, originGP.getEast(), originGP.getZenith()), zero), new FieldTransform<DerivativeStructure>(date, origin));
        FieldTransform<DerivativeStructure> intermediateToBody = new FieldTransform<DerivativeStructure>(date, poleShift, meridianShift);
        FieldTransform<DerivativeStructure> bodyToInert = this.baseFrame.getParent().getTransformTo(inertial, date);
        return new FieldTransform<DerivativeStructure>(date, offsetToIntermediate, new FieldTransform<DerivativeStructure>(date, intermediateToBody, bodyToInert));
    }

    private double linearModel(AbsoluteDate date, ParameterDriver offsetDriver, ParameterDriver driftDriver) throws OrekitException {
        if (offsetDriver.getReferenceDate() == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_REFERENCE_DATE_FOR_PARAMETER, offsetDriver.getName());
        }
        double dt = date.durationFrom(offsetDriver.getReferenceDate());
        double offset = this.parametricModel(offsetDriver);
        double drift = this.parametricModel(driftDriver);
        return dt * drift + offset;
    }

    private DerivativeStructure linearModel(DSFactory factory, FieldAbsoluteDate<DerivativeStructure> date, ParameterDriver offsetDriver, ParameterDriver driftDriver, Map<String, Integer> indices) throws OrekitException {
        if (offsetDriver.getReferenceDate() == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_REFERENCE_DATE_FOR_PARAMETER, offsetDriver.getName());
        }
        DerivativeStructure dt = date.durationFrom(offsetDriver.getReferenceDate());
        DerivativeStructure offset = this.parametricModel(factory, offsetDriver, indices);
        DerivativeStructure drift = this.parametricModel(factory, driftDriver, indices);
        return dt.multiply(drift).add(offset);
    }

    private double parametricModel(ParameterDriver driver) {
        return driver.getValue();
    }

    private DerivativeStructure parametricModel(DSFactory factory, ParameterDriver driver, Map<String, Integer> indices) {
        Integer index = indices.get(driver.getName());
        return index == null ? factory.constant(driver.getValue()) : factory.variable(index.intValue(), driver.getValue());
    }
}

