/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.util.Incrementor;
import org.hipparchus.util.Pair;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.estimation.leastsquares.MeasurementHandler;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.leastsquares.PreCompensation;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.PropagatorsParallelizer;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.NumericalPropagatorBuilder;
import org.orekit.propagation.numerical.JacobiansMapper;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.numerical.PartialDerivativesEquations;
import org.orekit.propagation.sampling.MultiSatStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

class Model
implements MultivariateJacobianFunction {
    private final ParameterDriversList estimatedPropagatorParameters;
    private final NumericalPropagatorBuilder[] builders;
    private final List<ObservedMeasurement<?>> measurements;
    private final ParameterDriversList estimatedMeasurementsParameters;
    private final int[] orbitsStartColumns;
    private final int[] orbitsEndColumns;
    private final Map<String, Integer> parameterColumns;
    private final Map<ObservedMeasurement<?>, EstimatedMeasurement<?>> evaluations;
    private final ModelObserver observer;
    private Incrementor evaluationsCounter;
    private Incrementor iterationsCounter;
    private AbsoluteDate firstDate;
    private AbsoluteDate lastDate;
    private JacobiansMapper[] mappers;
    private RealVector value;
    private RealMatrix jacobian;

    Model(NumericalPropagatorBuilder[] builders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) throws OrekitException {
        int i;
        this.builders = builders;
        this.measurements = measurements;
        this.estimatedMeasurementsParameters = estimatedMeasurementsParameters;
        this.parameterColumns = new HashMap<String, Integer>(estimatedMeasurementsParameters.getDrivers().size());
        this.evaluations = new IdentityHashMap(measurements.size());
        this.observer = observer;
        this.mappers = new JacobiansMapper[builders.length];
        int rows = 0;
        for (ObservedMeasurement<?> measurement : measurements) {
            rows += measurement.getDimension();
        }
        this.orbitsStartColumns = new int[builders.length];
        this.orbitsEndColumns = new int[builders.length];
        int columns = 0;
        for (i = 0; i < builders.length; ++i) {
            this.orbitsStartColumns[i] = columns;
            for (ParameterDriver parameterDriver : builders[i].getOrbitalParametersDrivers().getDrivers()) {
                if (!parameterDriver.isSelected()) continue;
                ++columns;
            }
            this.orbitsEndColumns[i] = columns;
        }
        this.estimatedPropagatorParameters = new ParameterDriversList();
        for (i = 0; i < builders.length; ++i) {
            for (ParameterDriver parameterDriver : builders[i].getPropagationParametersDrivers().getDrivers()) {
                if (!parameterDriver.isSelected()) continue;
                this.estimatedPropagatorParameters.add(parameterDriver);
                ++columns;
            }
        }
        for (ParameterDriver parameterDriver : estimatedMeasurementsParameters.getDrivers()) {
            this.parameterColumns.put(parameterDriver.getName(), columns);
            ++columns;
        }
        this.value = new ArrayRealVector(rows);
        this.jacobian = MatrixUtils.createRealMatrix((int)rows, (int)columns);
    }

    void setEvaluationsCounter(Incrementor evaluationsCounter) {
        this.evaluationsCounter = evaluationsCounter;
    }

    void setIterationsCounter(Incrementor iterationsCounter) {
        this.iterationsCounter = iterationsCounter;
    }

    public Pair<RealVector, RealMatrix> value(RealVector point) throws OrekitExceptionWrapper {
        try {
            NumericalPropagator[] propagators = this.createPropagators(point);
            Orbit[] orbits = new Orbit[propagators.length];
            for (int i = 0; i < propagators.length; ++i) {
                this.mappers[i] = this.configureDerivatives(propagators[i]);
                orbits[i] = propagators[i].getInitialState().getOrbit();
            }
            PropagatorsParallelizer parallelizer = new PropagatorsParallelizer(Arrays.asList(propagators), this.configureMeasurements(point));
            this.evaluations.clear();
            this.value.set(0.0);
            for (int i = 0; i < this.jacobian.getRowDimension(); ++i) {
                for (int j = 0; j < this.jacobian.getColumnDimension(); ++j) {
                    this.jacobian.setEntry(i, j, 0.0);
                }
            }
            parallelizer.propagate(this.firstDate.shiftedBy(-1.0), this.lastDate.shiftedBy(1.0));
            this.observer.modelCalled(orbits, this.evaluations);
            return new Pair((Object)this.value, (Object)this.jacobian);
        }
        catch (OrekitException oe) {
            throw new OrekitExceptionWrapper(oe);
        }
    }

    public int getIterationsCount() {
        return this.iterationsCounter.getCount();
    }

    public int getEvaluationsCount() {
        return this.evaluationsCounter.getCount();
    }

    public NumericalPropagator[] createPropagators(RealVector point) throws OrekitException {
        NumericalPropagator[] propagators = new NumericalPropagator[this.builders.length];
        for (int i = 0; i < this.builders.length; ++i) {
            int j;
            int nbOrb = this.orbitsEndColumns[i] - this.orbitsStartColumns[i];
            int nbParams = this.estimatedPropagatorParameters.getNbParams();
            double[] propagatorArray = new double[nbOrb + nbParams];
            for (j = 0; j < nbOrb; ++j) {
                propagatorArray[j] = point.getEntry(this.orbitsStartColumns[i] + j);
            }
            for (j = 0; j < nbParams; ++j) {
                propagatorArray[nbOrb + j] = point.getEntry(this.orbitsEndColumns[this.builders.length - 1] + j);
            }
            propagators[i] = this.builders[i].buildPropagator(propagatorArray);
        }
        return propagators;
    }

    private MultiSatStepHandler configureMeasurements(RealVector point) throws OrekitException {
        int index = this.orbitsEndColumns[this.builders.length - 1] + this.estimatedPropagatorParameters.getNbParams();
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            parameterDriver.setNormalizedValue(point.getEntry(index++));
        }
        ArrayList<PreCompensation> precompensated = new ArrayList<PreCompensation>();
        for (ObservedMeasurement<?> measurement : this.measurements) {
            if (!measurement.isEnabled()) continue;
            precompensated.add(new PreCompensation(measurement, this.evaluations.get(measurement)));
        }
        precompensated.sort(new ChronologicalComparator());
        this.firstDate = ((PreCompensation)precompensated.get(0)).getDate();
        this.lastDate = ((PreCompensation)precompensated.get(precompensated.size() - 1)).getDate();
        return new MeasurementHandler(this, precompensated);
    }

    private JacobiansMapper configureDerivatives(NumericalPropagator propagator) throws OrekitException {
        String equationName = Model.class.getName() + "-derivatives";
        PartialDerivativesEquations partials = new PartialDerivativesEquations(equationName, propagator);
        SpacecraftState rawState = propagator.getInitialState();
        SpacecraftState stateWithDerivatives = partials.setInitialJacobians(rawState);
        propagator.resetInitialState(stateWithDerivatives);
        return partials.getMapper();
    }

    void fetchEvaluatedMeasurement(int index, EstimatedMeasurement<?> evaluation) throws OrekitException {
        SpacecraftState[] evaluationStates = evaluation.getStates();
        Object observedMeasurement = evaluation.getObservedMeasurement();
        this.evaluations.put((ObservedMeasurement<?>)observedMeasurement, evaluation);
        double[] evaluated = evaluation.getEstimatedValue();
        double[] observed = observedMeasurement.getObservedValue();
        double[] sigma = observedMeasurement.getTheoreticalStandardDeviation();
        double[] weight = evaluation.getCurrentWeight();
        for (int i = 0; i < evaluated.length; ++i) {
            this.value.setEntry(index + i, weight[i] * (evaluated[i] - observed[i]) / sigma[i]);
        }
        for (int k = 0; k < evaluationStates.length; ++k) {
            int p = observedMeasurement.getPropagatorsIndices().get(k);
            double[][] aCY = new double[6][6];
            Orbit currentOrbit = evaluationStates[k].getOrbit();
            currentOrbit.getJacobianWrtParameters(this.builders[p].getPositionAngle(), aCY);
            Array2DRowRealMatrix dCdY = new Array2DRowRealMatrix(aCY, false);
            Array2DRowRealMatrix dMdC = new Array2DRowRealMatrix(evaluation.getStateDerivatives(k), false);
            RealMatrix dMdY = dMdC.multiply((RealMatrix)dCdY);
            double[][] aYY0 = new double[6][6];
            this.mappers[p].getStateJacobian(evaluationStates[k], aYY0);
            Array2DRowRealMatrix dYdY0 = new Array2DRowRealMatrix(aYY0, false);
            RealMatrix dMdY0 = dMdY.multiply((RealMatrix)dYdY0);
            for (int i = 0; i < dMdY0.getRowDimension(); ++i) {
                int jOrb = this.orbitsStartColumns[p];
                for (int j = 0; j < dMdY0.getColumnDimension(); ++j) {
                    ParameterDriver driver = this.builders[p].getOrbitalParametersDrivers().getDrivers().get(j);
                    if (!driver.isSelected()) continue;
                    this.jacobian.setEntry(index + i, jOrb++, weight[i] * dMdY0.getEntry(i, j) / sigma[i] * driver.getScale());
                }
            }
            if (this.estimatedPropagatorParameters.getNbParams() <= 0) continue;
            double[][] aYPp = new double[6][this.estimatedPropagatorParameters.getNbParams()];
            this.mappers[p].getParametersJacobian(evaluationStates[k], aYPp);
            Array2DRowRealMatrix dYdPp = new Array2DRowRealMatrix(aYPp, false);
            RealMatrix dMdPp = dMdY.multiply((RealMatrix)dYdPp);
            for (int i = 0; i < dMdPp.getRowDimension(); ++i) {
                int jPar = this.orbitsEndColumns[this.builders.length - 1];
                for (int j = 0; j < this.estimatedPropagatorParameters.getNbParams(); ++j) {
                    ParameterDriver driver = this.estimatedPropagatorParameters.getDrivers().get(j);
                    this.jacobian.addToEntry(index + i, jPar++, weight[i] * dMdPp.getEntry(i, j) / sigma[i] * driver.getScale());
                }
            }
        }
        for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            double[] aMPm = evaluation.getParameterDerivatives(driver);
            for (int i = 0; i < aMPm.length; ++i) {
                this.jacobian.setEntry(index + i, this.parameterColumns.get(driver.getName()).intValue(), weight[i] * aMPm[i] / sigma[i] * driver.getScale());
            }
        }
    }
}

