/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvider;
import org.orekit.data.ZipJarCrawler;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public class ClasspathCrawler
implements DataProvider {
    private final List<String> listElements = new ArrayList<String>();
    private final ClassLoader classLoader;

    public ClasspathCrawler(String ... list) throws OrekitException {
        this(ClasspathCrawler.class.getClassLoader(), list);
    }

    public ClasspathCrawler(ClassLoader classLoader, String ... list) throws OrekitException {
        this.classLoader = classLoader;
        for (String name : list) {
            if ("".equals(name)) continue;
            String convertedName = name.replace('\\', '/');
            InputStream stream = classLoader.getResourceAsStream(convertedName);
            if (stream == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_RESOURCE, name);
            }
            this.listElements.add(convertedName);
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean feed(Pattern supported, DataLoader visitor) throws OrekitException {
        try {
            OrekitException delayedException = null;
            boolean loaded = false;
            for (String name : this.listElements) {
                try {
                    if (!visitor.stillAcceptsData()) continue;
                    if (ZIP_ARCHIVE_PATTERN.matcher(name).matches()) {
                        ZipJarCrawler zipProvider = new ZipJarCrawler(name);
                        loaded = zipProvider.feed(supported, visitor) || loaded;
                        continue;
                    }
                    Matcher gzipMatcher = GZIP_FILE_PATTERN.matcher(name);
                    String baseName = gzipMatcher.matches() ? gzipMatcher.group(1) : name;
                    if (!supported.matcher(baseName).matches()) continue;
                    InputStream stream = this.classLoader.getResourceAsStream(name);
                    URI uri = this.classLoader.getResource(name).toURI();
                    if (gzipMatcher.matches()) {
                        visitor.loadData(new GZIPInputStream(stream), uri.toString());
                    } else {
                        visitor.loadData(stream, uri.toString());
                    }
                    stream.close();
                    loaded = true;
                }
                catch (OrekitException oe) {
                    delayedException = oe;
                }
                catch (URISyntaxException use) {
                    throw new OrekitException(use, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, use.getMessage());
                }
            }
            if (!loaded && delayedException != null) {
                throw delayedException;
            }
            return loaded;
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
        catch (ParseException pe) {
            throw new OrekitException(pe, (Localizable)new DummyLocalizable(pe.getMessage()), new Object[0]);
        }
    }
}

