/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.random;

import java.io.Serializable;
import java.util.Random;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.random.IntRandomGenerator;
import org.hipparchus.util.MathUtils;

public class JDKRandomGenerator
extends IntRandomGenerator
implements Serializable {
    private static final long serialVersionUID = 20151227L;
    private final Random delegate;

    public JDKRandomGenerator() {
        this.delegate = new Random();
    }

    public JDKRandomGenerator(long seed) {
        this.delegate = new Random(seed);
    }

    public JDKRandomGenerator(Random random) {
        MathUtils.checkNotNull(random);
        this.delegate = random;
    }

    @Override
    public void setSeed(int seed) {
        this.delegate.setSeed(seed);
    }

    @Override
    public void setSeed(long seed) {
        this.delegate.setSeed(seed);
    }

    @Override
    public void setSeed(int[] seed) {
        this.delegate.setSeed(JDKRandomGenerator.convertToLong(seed));
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.delegate.nextBytes(bytes);
    }

    @Override
    public int nextInt() {
        return this.delegate.nextInt();
    }

    @Override
    public long nextLong() {
        return this.delegate.nextLong();
    }

    @Override
    public boolean nextBoolean() {
        return this.delegate.nextBoolean();
    }

    @Override
    public float nextFloat() {
        return this.delegate.nextFloat();
    }

    @Override
    public double nextDouble() {
        return this.delegate.nextDouble();
    }

    @Override
    public double nextGaussian() {
        return this.delegate.nextGaussian();
    }

    @Override
    public int nextInt(int n) {
        try {
            return this.delegate.nextInt(n);
        }
        catch (IllegalArgumentException e) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, n, 0);
        }
    }

    private static long convertToLong(int[] seed) {
        long prime = 0xFFFFFFFBL;
        long combined = 0L;
        for (int s : seed) {
            combined = combined * 0xFFFFFFFBL + (long)s;
        }
        return combined;
    }
}

