/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.Collections;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeStamped;

public class TimeSpanMap<T> {
    private final NavigableSet<Transition<T>> data = new TreeSet<TimeStamped>(new ChronologicalComparator());

    public TimeSpanMap(T entry) {
        this.data.add(new Transition(AbsoluteDate.J2000_EPOCH, entry, entry));
    }

    public void addValidBefore(T entry, AbsoluteDate latestValidityDate) {
        Transition single;
        if (this.data.size() == 1 && (single = (Transition)this.data.first()).getBefore() == single.getAfter()) {
            this.data.clear();
            this.data.add(new Transition(latestValidityDate, entry, single.getAfter()));
            return;
        }
        Transition previous = this.data.floor(new Transition(latestValidityDate, entry, null));
        if (previous == null) {
            this.data.add(new Transition(latestValidityDate, entry, ((Transition)this.data.first()).getBefore()));
        } else {
            this.data.remove(previous);
            this.data.add(new Transition(previous.date, previous.getBefore(), entry));
            this.data.add(new Transition(latestValidityDate, entry, previous.getAfter()));
        }
    }

    public void addValidAfter(T entry, AbsoluteDate earliestValidityDate) {
        Transition single;
        if (this.data.size() == 1 && (single = (Transition)this.data.first()).getBefore() == single.getAfter()) {
            this.data.clear();
            this.data.add(new Transition(earliestValidityDate, single.getBefore(), entry));
            return;
        }
        Transition next = this.data.ceiling(new Transition(earliestValidityDate, entry, null));
        if (next == null) {
            this.data.add(new Transition(earliestValidityDate, ((Transition)this.data.last()).getAfter(), entry));
        } else {
            this.data.remove(next);
            this.data.add(new Transition(earliestValidityDate, next.getBefore(), entry));
            this.data.add(new Transition(next.date, entry, next.getAfter()));
        }
    }

    public T get(AbsoluteDate date) {
        Transition previous = this.data.floor(new Transition(date, null, null));
        if (previous == null) {
            return (T)((Transition)this.data.first()).getBefore();
        }
        return (T)previous.getAfter();
    }

    public SortedSet<Transition<T>> getTransitions() {
        return Collections.unmodifiableSortedSet(this.data);
    }

    public static class Transition<S>
    implements TimeStamped {
        private final AbsoluteDate date;
        private final S before;
        private final S after;

        private Transition(AbsoluteDate date, S before, S after) {
            this.date = date;
            this.before = before;
            this.after = after;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public S getBefore() {
            return this.before;
        }

        public S getAfter() {
            return this.after;
        }
    }
}

