/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.ode.DenseOutputModel;
import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.SecondaryODE;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.ODEEventHandler;
import org.hipparchus.ode.sampling.AbstractODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStepHandler;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.AbstractPropagator;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.integration.IntegratedEphemeris;
import org.orekit.propagation.integration.ModeHandler;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public abstract class AbstractIntegratedPropagator
extends AbstractPropagator {
    private final List<EventDetector> detectors = new ArrayList<EventDetector>();
    private final ODEIntegrator integrator;
    private ModeHandler modeHandler;
    private List<AdditionalEquations> additionalEquations = new ArrayList<AdditionalEquations>();
    private int calls;
    private StateMapper stateMapper;
    private EquationsMapper equationsMapper;
    private boolean resetAtEnd;
    private boolean meanOrbit;

    protected AbstractIntegratedPropagator(ODEIntegrator integrator, boolean meanOrbit) {
        this.integrator = integrator;
        this.meanOrbit = meanOrbit;
        this.resetAtEnd = true;
    }

    public void setResetAtEnd(boolean resetAtEnd) {
        this.resetAtEnd = resetAtEnd;
    }

    protected void initMapper() {
        this.stateMapper = this.createMapper(null, Double.NaN, null, null, null, null);
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        super.setAttitudeProvider(attitudeProvider);
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), attitudeProvider, this.stateMapper.getFrame());
    }

    protected void setOrbitType(OrbitType orbitType) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), orbitType, this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    protected OrbitType getOrbitType() {
        return this.stateMapper.getOrbitType();
    }

    protected boolean isMeanOrbit() {
        return this.meanOrbit;
    }

    protected void setPositionAngleType(PositionAngle positionAngleType) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), positionAngleType, this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    protected PositionAngle getPositionAngleType() {
        return this.stateMapper.getPositionAngleType();
    }

    public void setMu(double mu) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), mu, this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    public double getMu() {
        return this.stateMapper.getMu();
    }

    public int getCalls() {
        return this.calls;
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        if (super.isAdditionalStateManaged(name)) {
            return true;
        }
        for (AdditionalEquations equation : this.additionalEquations) {
            if (!equation.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] alreadyIntegrated = super.getManagedAdditionalStates();
        String[] managed = new String[alreadyIntegrated.length + this.additionalEquations.size()];
        System.arraycopy(alreadyIntegrated, 0, managed, 0, alreadyIntegrated.length);
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            managed[i + alreadyIntegrated.length] = this.additionalEquations.get(i).getName();
        }
        return managed;
    }

    public void addAdditionalEquations(AdditionalEquations additional) throws OrekitException {
        if (this.isAdditionalStateManaged(additional.getName())) {
            throw new OrekitException((Localizable)OrekitMessages.ADDITIONAL_STATE_NAME_ALREADY_IN_USE, additional.getName());
        }
        this.additionalEquations.add(additional);
    }

    public void addEventDetector(EventDetector detector) {
        this.detectors.add(detector);
    }

    @Override
    public Collection<EventDetector> getEventsDetectors() {
        return Collections.unmodifiableCollection(this.detectors);
    }

    @Override
    public void clearEventsDetectors() {
        this.detectors.clear();
    }

    protected void setUpUserEventDetectors() {
        for (EventDetector detector : this.detectors) {
            this.setUpEventDetector(this.integrator, detector);
        }
    }

    protected void setUpEventDetector(ODEIntegrator integ, EventDetector detector) {
        integ.addEventHandler((ODEEventHandler)new AdaptedEventDetector(detector), detector.getMaxCheckInterval(), detector.getThreshold(), detector.getMaxIterationCount());
    }

    @Override
    public void setSlaveMode() {
        super.setSlaveMode();
        if (this.integrator != null) {
            this.integrator.clearStepHandlers();
        }
        this.modeHandler = null;
    }

    @Override
    public void setMasterMode(OrekitStepHandler handler) {
        super.setMasterMode(handler);
        this.integrator.clearStepHandlers();
        AdaptedStepHandler wrapped = new AdaptedStepHandler(handler);
        this.integrator.addStepHandler((ODEStepHandler)wrapped);
        this.modeHandler = wrapped;
    }

    @Override
    public void setEphemerisMode() {
        super.setEphemerisMode();
        this.integrator.clearStepHandlers();
        EphemerisModeHandler ephemeris = new EphemerisModeHandler();
        this.modeHandler = ephemeris;
        this.integrator.addStepHandler((ODEStepHandler)ephemeris);
    }

    @Override
    public void setEphemerisMode(OrekitStepHandler handler) {
        super.setEphemerisMode();
        this.integrator.clearStepHandlers();
        EphemerisModeHandler ephemeris = new EphemerisModeHandler(handler);
        this.modeHandler = ephemeris;
        this.integrator.addStepHandler((ODEStepHandler)ephemeris);
    }

    @Override
    public BoundedPropagator getGeneratedEphemeris() throws IllegalStateException {
        if (this.getMode() != 2) {
            throw new OrekitIllegalStateException(OrekitMessages.PROPAGATOR_NOT_IN_EPHEMERIS_GENERATION_MODE, new Object[0]);
        }
        return ((EphemerisModeHandler)this.modeHandler).getEphemeris();
    }

    protected abstract StateMapper createMapper(AbsoluteDate var1, double var2, OrbitType var4, PositionAngle var5, AttitudeProvider var6, Frame var7);

    protected abstract MainStateEquations getMainStateEquations(ODEIntegrator var1);

    @Override
    public SpacecraftState propagate(AbsoluteDate target) throws OrekitException {
        if (this.getStartDate() == null) {
            if (this.getInitialState() == null) {
                throw new OrekitException((Localizable)OrekitMessages.INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION, new Object[0]);
            }
            this.setStartDate(this.getInitialState().getDate());
        }
        return this.propagate(this.getStartDate(), target);
    }

    @Override
    public SpacecraftState propagate(AbsoluteDate tStart, AbsoluteDate tEnd) throws OrekitException {
        if (this.getInitialState() == null) {
            throw new OrekitException((Localizable)OrekitMessages.INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION, new Object[0]);
        }
        if (!tStart.equals(this.getInitialState().getDate())) {
            this.propagate(tStart, false);
        }
        return this.propagate(tEnd, true);
    }

    protected SpacecraftState propagate(AbsoluteDate tEnd, boolean activateHandlers) throws OrekitException {
        try {
            ODEStateAndDerivative mathFinalState;
            if (this.getInitialState().getDate().equals(tEnd)) {
                return this.getInitialState();
            }
            this.stateMapper = this.createMapper(this.getInitialState().getDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.getInitialState().getFrame());
            Orbit initialOrbit = this.stateMapper.getOrbitType().convertType(this.getInitialState().getOrbit());
            if (Double.isNaN(this.getMu())) {
                this.setMu(initialOrbit.getMu());
            }
            if (this.getInitialState().getMass() <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, this.getInitialState().getMass());
            }
            this.integrator.clearEventHandlers();
            this.setUpUserEventDetectors();
            ODEState mathInitialState = this.createInitialState(this.getInitialIntegrationState());
            ExpandableODE mathODE = this.createODE(this.integrator, mathInitialState);
            this.equationsMapper = mathODE.getMapper();
            if (this.modeHandler != null) {
                this.modeHandler.initialize(activateHandlers, tEnd);
            }
            try {
                this.beforeIntegration(this.getInitialState(), tEnd);
                mathFinalState = this.integrator.integrate(mathODE, mathInitialState, tEnd.durationFrom(this.getInitialState().getDate()));
                this.afterIntegration();
            }
            catch (OrekitExceptionWrapper oew) {
                throw oew.getException();
            }
            SpacecraftState finalState = this.stateMapper.mapArrayToState(this.stateMapper.mapDoubleToDate(mathFinalState.getTime(), tEnd), mathFinalState.getPrimaryState(), mathFinalState.getPrimaryDerivative(), this.meanOrbit);
            finalState = this.updateAdditionalStates(finalState);
            for (int i = 0; i < this.additionalEquations.size(); ++i) {
                double[] secondary = mathFinalState.getSecondaryState(i + 1);
                finalState = finalState.addAdditionalState(this.additionalEquations.get(i).getName(), secondary);
            }
            if (this.resetAtEnd) {
                this.resetInitialState(finalState);
                this.setStartDate(finalState.getDate());
            }
            return finalState;
        }
        catch (MathRuntimeException mre) {
            throw OrekitException.unwrap(mre);
        }
    }

    protected SpacecraftState getInitialIntegrationState() throws OrekitException {
        return this.getInitialState();
    }

    private ODEState createInitialState(SpacecraftState initialState) throws OrekitException {
        double[] primary = new double[this.getBasicDimension()];
        this.stateMapper.mapStateToArray(initialState, primary, null);
        double[][] secondary = new double[this.additionalEquations.size()][];
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            AdditionalEquations additional = this.additionalEquations.get(i);
            secondary[i] = initialState.getAdditionalState(additional.getName());
        }
        return new ODEState(0.0, primary, (double[][])secondary);
    }

    private ExpandableODE createODE(ODEIntegrator integ, ODEState mathInitialState) throws OrekitException {
        ExpandableODE ode = new ExpandableODE((OrdinaryDifferentialEquation)new ConvertedMainStateEquations(this.getMainStateEquations(integ)));
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            AdditionalEquations additional = this.additionalEquations.get(i);
            ConvertedSecondaryStateEquations secondary = new ConvertedSecondaryStateEquations(additional, mathInitialState.getSecondaryStateDimension(i + 1));
            ode.addSecondaryEquations((SecondaryODE)secondary);
        }
        return ode;
    }

    protected void beforeIntegration(SpacecraftState initialState, AbsoluteDate tEnd) throws OrekitException {
    }

    protected void afterIntegration() throws OrekitException {
    }

    public int getBasicDimension() {
        return 7;
    }

    protected ODEIntegrator getIntegrator() {
        return this.integrator;
    }

    private SpacecraftState getCompleteState(double t, double[] y, double[] yDot) throws OrekitException {
        SpacecraftState state = this.stateMapper.mapArrayToState(t, y, yDot, true);
        state = this.updateAdditionalStates(state);
        if (!this.additionalEquations.isEmpty()) {
            for (int i = 0; i < this.additionalEquations.size(); ++i) {
                state = state.addAdditionalState(this.additionalEquations.get(i).getName(), this.equationsMapper.extractEquationData(i + 1, y));
            }
        }
        return state;
    }

    private class EphemerisModeHandler
    implements ModeHandler,
    ODEStepHandler {
        private DenseOutputModel model;
        private BoundedPropagator ephemeris;
        private boolean activate;
        private AbsoluteDate endDate;
        private final AdaptedStepHandler handler;

        EphemerisModeHandler() {
            this.handler = null;
        }

        EphemerisModeHandler(OrekitStepHandler handler) {
            this.handler = new AdaptedStepHandler(handler);
        }

        @Override
        public void initialize(boolean activateHandlers, AbsoluteDate targetDate) {
            this.activate = activateHandlers;
            this.model = new DenseOutputModel();
            this.endDate = targetDate;
            this.ephemeris = null;
            if (this.handler != null) {
                this.handler.initialize(activateHandlers, targetDate);
            }
        }

        public BoundedPropagator getEphemeris() {
            return this.ephemeris;
        }

        public void handleStep(ODEStateInterpolator interpolator, boolean isLast) throws OrekitExceptionWrapper {
            try {
                if (this.activate) {
                    if (this.handler != null) {
                        this.handler.handleStep(interpolator, isLast);
                    }
                    this.model.handleStep(interpolator, isLast);
                    if (isLast) {
                        AbsoluteDate maxDate;
                        AbsoluteDate minDate;
                        double tI = this.model.getInitialTime();
                        double tF = this.model.getFinalTime();
                        AbsoluteDate startDate = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tI);
                        AbsoluteDate finalDate = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tF, this.endDate);
                        if (tF < tI) {
                            minDate = finalDate;
                            maxDate = startDate;
                        } else {
                            minDate = startDate;
                            maxDate = finalDate;
                        }
                        HashMap<String, double[]> unmanaged = new HashMap<String, double[]>();
                        for (Map.Entry<String, double[]> initial : AbstractIntegratedPropagator.this.getInitialState().getAdditionalStates().entrySet()) {
                            if (AbstractIntegratedPropagator.this.isAdditionalStateManaged(initial.getKey())) continue;
                            unmanaged.put(initial.getKey(), initial.getValue());
                        }
                        String[] names = new String[AbstractIntegratedPropagator.this.additionalEquations.size()];
                        for (int i = 0; i < names.length; ++i) {
                            names[i] = ((AdditionalEquations)AbstractIntegratedPropagator.this.additionalEquations.get(i)).getName();
                        }
                        this.ephemeris = new IntegratedEphemeris(startDate, minDate, maxDate, AbstractIntegratedPropagator.this.stateMapper, AbstractIntegratedPropagator.this.meanOrbit, this.model, unmanaged, AbstractIntegratedPropagator.this.getAdditionalStateProviders(), names);
                    }
                }
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public void init(ODEStateAndDerivative s0, double t) {
            this.model.init(s0, t);
            if (this.handler != null) {
                this.handler.init(s0, t);
            }
        }
    }

    private class AdaptedStepInterpolator
    implements OrekitStepInterpolator {
        private final ODEStateInterpolator mathInterpolator;

        AdaptedStepInterpolator(ODEStateInterpolator mathInterpolator) {
            this.mathInterpolator = mathInterpolator;
        }

        @Override
        public SpacecraftState getPreviousState() throws OrekitException {
            return this.convert(this.mathInterpolator.getPreviousState());
        }

        @Override
        public boolean isPreviousStateInterpolated() {
            return this.mathInterpolator.isPreviousStateInterpolated();
        }

        @Override
        public SpacecraftState getCurrentState() throws OrekitException {
            return this.convert(this.mathInterpolator.getCurrentState());
        }

        @Override
        public boolean isCurrentStateInterpolated() {
            return this.mathInterpolator.isCurrentStateInterpolated();
        }

        @Override
        public SpacecraftState getInterpolatedState(AbsoluteDate date) throws OrekitException {
            return this.convert(this.mathInterpolator.getInterpolatedState(date.durationFrom(AbstractIntegratedPropagator.this.stateMapper.getReferenceDate())));
        }

        private SpacecraftState convert(ODEStateAndDerivative os) throws OrekitException {
            SpacecraftState s = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(os.getTime(), os.getPrimaryState(), os.getPrimaryDerivative(), AbstractIntegratedPropagator.this.meanOrbit);
            s = AbstractIntegratedPropagator.this.updateAdditionalStates(s);
            for (int i = 0; i < AbstractIntegratedPropagator.this.additionalEquations.size(); ++i) {
                double[] secondary = os.getSecondaryState(i + 1);
                s = s.addAdditionalState(((AdditionalEquations)AbstractIntegratedPropagator.this.additionalEquations.get(i)).getName(), secondary);
            }
            return s;
        }

        private ODEStateAndDerivative convert(SpacecraftState state) throws OrekitException {
            double[] primary = new double[AbstractIntegratedPropagator.this.getBasicDimension()];
            double[] primaryDot = new double[AbstractIntegratedPropagator.this.getBasicDimension()];
            AbstractIntegratedPropagator.this.stateMapper.mapStateToArray(state, primary, primaryDot);
            double[][] secondary = new double[AbstractIntegratedPropagator.this.additionalEquations.size()][];
            for (int i = 0; i < AbstractIntegratedPropagator.this.additionalEquations.size(); ++i) {
                AdditionalEquations additional = (AdditionalEquations)AbstractIntegratedPropagator.this.additionalEquations.get(i);
                secondary[i] = state.getAdditionalState(additional.getName());
            }
            return new ODEStateAndDerivative(AbstractIntegratedPropagator.this.stateMapper.mapDateToDouble(state.getDate()), primary, primaryDot, (double[][])secondary, (double[][])null);
        }

        @Override
        public boolean isForward() {
            return this.mathInterpolator.isForward();
        }

        @Override
        public AdaptedStepInterpolator restrictStep(SpacecraftState newPreviousState, SpacecraftState newCurrentState) throws OrekitException {
            try {
                AbstractODEStateInterpolator aosi = (AbstractODEStateInterpolator)this.mathInterpolator;
                return new AdaptedStepInterpolator((ODEStateInterpolator)aosi.restrictStep(this.convert(newPreviousState), this.convert(newCurrentState)));
            }
            catch (ClassCastException cce) {
                throw new OrekitInternalError(cce);
            }
        }
    }

    private class AdaptedStepHandler
    implements ODEStepHandler,
    ModeHandler {
        private final OrekitStepHandler handler;
        private boolean activate;

        AdaptedStepHandler(OrekitStepHandler handler) {
            this.handler = handler;
        }

        @Override
        public void initialize(boolean activateHandlers, AbsoluteDate targetDate) {
            this.activate = activateHandlers;
        }

        public void init(ODEStateAndDerivative s0, double t) {
            try {
                if (this.activate) {
                    this.handler.init(AbstractIntegratedPropagator.this.getCompleteState(s0.getTime(), s0.getCompleteState(), s0.getCompleteDerivative()), AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(t));
                }
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public void handleStep(ODEStateInterpolator interpolator, boolean isLast) {
            try {
                if (this.activate) {
                    this.handler.handleStep(new AdaptedStepInterpolator(interpolator), isLast);
                }
            }
            catch (OrekitException pe) {
                throw new OrekitExceptionWrapper(pe);
            }
        }
    }

    private class AdaptedEventDetector
    implements ODEEventHandler {
        private final EventDetector detector;
        private double lastT;
        private double lastG;

        AdaptedEventDetector(EventDetector detector) {
            this.detector = detector;
            this.lastT = Double.NaN;
            this.lastG = Double.NaN;
        }

        public void init(ODEStateAndDerivative s0, double t) {
            try {
                this.detector.init(AbstractIntegratedPropagator.this.getCompleteState(s0.getTime(), s0.getCompleteState(), s0.getCompleteDerivative()), AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(t));
                this.lastT = Double.NaN;
                this.lastG = Double.NaN;
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public double g(ODEStateAndDerivative s) {
            try {
                if (!Precision.equals((double)this.lastT, (double)s.getTime(), (int)0)) {
                    this.lastT = s.getTime();
                    this.lastG = this.detector.g(AbstractIntegratedPropagator.this.getCompleteState(s.getTime(), s.getCompleteState(), s.getCompleteDerivative()));
                }
                return this.lastG;
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public Action eventOccurred(ODEStateAndDerivative s, boolean increasing) {
            try {
                EventHandler.Action whatNext = this.detector.eventOccurred(AbstractIntegratedPropagator.this.getCompleteState(s.getTime(), s.getCompleteState(), s.getCompleteDerivative()), increasing);
                switch (whatNext) {
                    case STOP: {
                        return Action.STOP;
                    }
                    case RESET_STATE: {
                        return Action.RESET_STATE;
                    }
                    case RESET_DERIVATIVES: {
                        return Action.RESET_DERIVATIVES;
                    }
                }
                return Action.CONTINUE;
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public ODEState resetState(ODEStateAndDerivative s) {
            try {
                SpacecraftState oldState = AbstractIntegratedPropagator.this.getCompleteState(s.getTime(), s.getCompleteState(), s.getCompleteDerivative());
                SpacecraftState newState = this.detector.resetState(oldState);
                double[] primary = new double[s.getPrimaryStateDimension()];
                AbstractIntegratedPropagator.this.stateMapper.mapStateToArray(newState, primary, null);
                double[][] secondary = new double[AbstractIntegratedPropagator.this.additionalEquations.size()][];
                for (int i = 0; i < AbstractIntegratedPropagator.this.additionalEquations.size(); ++i) {
                    secondary[i] = newState.getAdditionalState(((AdditionalEquations)AbstractIntegratedPropagator.this.additionalEquations.get(i)).getName());
                }
                return new ODEState(newState.getDate().durationFrom(AbstractIntegratedPropagator.this.getStartDate()), primary, (double[][])secondary);
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }
    }

    private class ConvertedSecondaryStateEquations
    implements SecondaryODE {
        private final AdditionalEquations equations;
        private final int dimension;

        ConvertedSecondaryStateEquations(AdditionalEquations equations, int dimension) {
            this.equations = equations;
            this.dimension = dimension;
        }

        public int getDimension() {
            return this.dimension;
        }

        public double[] computeDerivatives(double t, double[] primary, double[] primaryDot, double[] secondary) throws OrekitExceptionWrapper {
            try {
                SpacecraftState currentState = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(t, primary, primaryDot, true);
                currentState = AbstractIntegratedPropagator.this.updateAdditionalStates(currentState);
                currentState = currentState.addAdditionalState(this.equations.getName(), secondary);
                double[] secondaryDot = new double[secondary.length];
                double[] additionalMainDot = this.equations.computeDerivatives(currentState, secondaryDot);
                if (additionalMainDot != null) {
                    for (int i = 0; i < additionalMainDot.length; ++i) {
                        int n = i;
                        primaryDot[n] = primaryDot[n] + additionalMainDot[i];
                    }
                }
                return secondaryDot;
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }
    }

    private class ConvertedMainStateEquations
    implements OrdinaryDifferentialEquation {
        private final MainStateEquations main;

        ConvertedMainStateEquations(MainStateEquations main) {
            this.main = main;
            AbstractIntegratedPropagator.this.calls = 0;
        }

        public int getDimension() {
            return AbstractIntegratedPropagator.this.getBasicDimension();
        }

        public void init(double t0, double[] y0, double finalTime) {
            try {
                SpacecraftState initialState = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(t0, y0, null, true);
                initialState = AbstractIntegratedPropagator.this.updateAdditionalStates(initialState);
                AbsoluteDate target = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(finalTime);
                this.main.init(initialState, target);
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public double[] computeDerivatives(double t, double[] y) throws OrekitExceptionWrapper {
            try {
                ++AbstractIntegratedPropagator.this.calls;
                SpacecraftState currentState = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(t, y, null, true);
                currentState = AbstractIntegratedPropagator.this.updateAdditionalStates(currentState);
                return this.main.computeDerivatives(currentState);
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }
    }

    public static interface MainStateEquations {
        default public void init(SpacecraftState initialState, AbsoluteDate target) throws OrekitException {
        }

        public double[] computeDerivatives(SpacecraftState var1) throws OrekitException;
    }
}

