/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeStamped;

public class TLE
implements TimeStamped,
Serializable {
    public static final int DEFAULT = 0;
    public static final int SGP = 1;
    public static final int SGP4 = 2;
    public static final int SDP4 = 3;
    public static final int SGP8 = 4;
    public static final int SDP8 = 5;
    private static final Pattern LINE_1_PATTERN = Pattern.compile("1 [ 0-9]{5}[A-Z] [ 0-9]{5}[ A-Z]{3} [ 0-9]{5}[.][ 0-9]{8} (?:(?:[ 0+-][.][ 0-9]{8})|(?: [ +-][.][ 0-9]{7})) [ +-][ 0-9]{5}[+-][ 0-9] [ +-][ 0-9]{5}[+-][ 0-9] [ 0-9] [ 0-9]{4}[ 0-9]");
    private static final Pattern LINE_2_PATTERN = Pattern.compile("2 [ 0-9]{5} [ 0-9]{3}[.][ 0-9]{4} [ 0-9]{3}[.][ 0-9]{4} [ 0-9]{7} [ 0-9]{3}[.][ 0-9]{4} [ 0-9]{3}[.][ 0-9]{4} [ 0-9]{2}[.][ 0-9]{13}[ 0-9]");
    private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final long serialVersionUID = -1596648022319057689L;
    private final int satelliteNumber;
    private final char classification;
    private final int launchYear;
    private final int launchNumber;
    private final String launchPiece;
    private final int ephemerisType;
    private final int elementNumber;
    private final AbsoluteDate epoch;
    private final double meanMotion;
    private final double meanMotionFirstDerivative;
    private final double meanMotionSecondDerivative;
    private final double eccentricity;
    private final double inclination;
    private final double pa;
    private final double raan;
    private final double meanAnomaly;
    private final int revolutionNumberAtEpoch;
    private final double bStar;
    private String line1;
    private String line2;

    public TLE(String line1, String line2) throws OrekitException {
        this.satelliteNumber = this.parseInteger(line1, 2, 5);
        int satNum2 = this.parseInteger(line2, 2, 5);
        if (this.satelliteNumber != satNum2) {
            throw new OrekitException((Localizable)OrekitMessages.TLE_LINES_DO_NOT_REFER_TO_SAME_OBJECT, line1, line2);
        }
        this.classification = line1.charAt(7);
        this.launchYear = this.parseYear(line1, 9);
        this.launchNumber = this.parseInteger(line1, 11, 3);
        this.launchPiece = line1.substring(14, 17).trim();
        this.ephemerisType = this.parseInteger(line1, 62, 1);
        this.elementNumber = this.parseInteger(line1, 64, 4);
        int year = this.parseYear(line1, 18);
        int dayInYear = this.parseInteger(line1, 20, 3);
        long df = 27L * (long)this.parseInteger(line1, 24, 8);
        int secondsA = (int)(df / 31250L);
        double secondsB = (double)(df % 31250L) / 31250.0;
        this.epoch = new AbsoluteDate(new DateComponents(year, dayInYear), new TimeComponents(secondsA, secondsB), (TimeScale)TimeScalesFactory.getUTC());
        this.meanMotion = this.parseDouble(line2, 52, 11) * Math.PI / 43200.0;
        this.meanMotionFirstDerivative = this.parseDouble(line1, 33, 10) * Math.PI / 1.86624E9;
        this.meanMotionSecondDerivative = Double.parseDouble((line1.substring(44, 45) + '.' + line1.substring(45, 50) + 'e' + line1.substring(50, 52)).replace(' ', '0')) * Math.PI / 5.3747712E13;
        this.eccentricity = Double.parseDouble("." + line2.substring(26, 33).replace(' ', '0'));
        this.inclination = FastMath.toRadians((double)this.parseDouble(line2, 8, 8));
        this.pa = FastMath.toRadians((double)this.parseDouble(line2, 34, 8));
        this.raan = FastMath.toRadians((double)Double.parseDouble(line2.substring(17, 25).replace(' ', '0')));
        this.meanAnomaly = FastMath.toRadians((double)this.parseDouble(line2, 43, 8));
        this.revolutionNumberAtEpoch = this.parseInteger(line2, 63, 5);
        this.bStar = Double.parseDouble((line1.substring(53, 54) + '.' + line1.substring(54, 59) + 'e' + line1.substring(59, 61)).replace(' ', '0'));
        this.line1 = line1;
        this.line2 = line2;
    }

    public TLE(int satelliteNumber, char classification, int launchYear, int launchNumber, String launchPiece, int ephemerisType, int elementNumber, AbsoluteDate epoch, double meanMotion, double meanMotionFirstDerivative, double meanMotionSecondDerivative, double e, double i, double pa, double raan, double meanAnomaly, int revolutionNumberAtEpoch, double bStar) {
        this.satelliteNumber = satelliteNumber;
        this.classification = classification;
        this.launchYear = launchYear;
        this.launchNumber = launchNumber;
        this.launchPiece = launchPiece;
        this.ephemerisType = ephemerisType;
        this.elementNumber = elementNumber;
        this.epoch = epoch;
        this.meanMotion = meanMotion;
        this.meanMotionFirstDerivative = meanMotionFirstDerivative;
        this.meanMotionSecondDerivative = meanMotionSecondDerivative;
        this.inclination = i;
        this.raan = raan;
        this.eccentricity = e;
        this.pa = pa;
        this.meanAnomaly = meanAnomaly;
        this.revolutionNumberAtEpoch = revolutionNumberAtEpoch;
        this.bStar = bStar;
        this.line1 = null;
        this.line2 = null;
    }

    public String getLine1() throws OrekitException {
        if (this.line1 == null) {
            this.buildLine1();
        }
        return this.line1;
    }

    public String getLine2() throws OrekitException {
        if (this.line2 == null) {
            this.buildLine2();
        }
        return this.line2;
    }

    private void buildLine1() throws OrekitException {
        StringBuffer buffer = new StringBuffer();
        buffer.append('1');
        buffer.append(' ');
        buffer.append(this.addPadding("satelliteNumber-1", this.satelliteNumber, '0', 5, true));
        buffer.append(this.classification);
        buffer.append(' ');
        buffer.append(this.addPadding("launchYear", this.launchYear % 100, '0', 2, true));
        buffer.append(this.addPadding("launchNumber", this.launchNumber, '0', 3, true));
        buffer.append(this.addPadding("launchPiece", this.launchPiece, ' ', 3, false));
        buffer.append(' ');
        DateTimeComponents dtc = this.epoch.getComponents(TimeScalesFactory.getUTC());
        buffer.append(this.addPadding("year", dtc.getDate().getYear() % 100, '0', 2, true));
        buffer.append(this.addPadding("day", dtc.getDate().getDayOfYear(), '0', 3, true));
        buffer.append('.');
        int fraction = (int)FastMath.rint((double)(31250.0 * dtc.getTime().getSecondsInUTCDay() / 27.0));
        buffer.append(this.addPadding("fraction", fraction, '0', 8, true));
        buffer.append(' ');
        double n1 = this.meanMotionFirstDerivative * 1.86624E9 / Math.PI;
        String sn1 = this.addPadding("meanMotionFirstDerivative", new DecimalFormat(".00000000", SYMBOLS).format(n1), ' ', 10, true);
        buffer.append(sn1);
        buffer.append(' ');
        double n2 = this.meanMotionSecondDerivative * 5.3747712E13 / Math.PI;
        buffer.append(this.formatExponentMarkerFree("meanMotionSecondDerivative", n2, 5, ' ', 8, true));
        buffer.append(' ');
        buffer.append(this.formatExponentMarkerFree("B*", this.bStar, 5, ' ', 8, true));
        buffer.append(' ');
        buffer.append(this.ephemerisType);
        buffer.append(' ');
        buffer.append(this.addPadding("elementNumber", this.elementNumber, ' ', 4, true));
        buffer.append(Integer.toString(TLE.checksum(buffer)));
        this.line1 = buffer.toString();
    }

    private String formatExponentMarkerFree(String name, double d, int mantissaSize, char c, int size, boolean rightJustified) throws OrekitException {
        double dAbs;
        int exponent = (dAbs = FastMath.abs((double)d)) < 1.0E-9 ? -9 : (int)FastMath.ceil((double)FastMath.log10((double)dAbs));
        long mantissa = FastMath.round((double)(dAbs * FastMath.pow((double)10.0, (int)(mantissaSize - exponent))));
        if (mantissa == 0L) {
            exponent = 0;
        }
        String sMantissa = this.addPadding(name, (int)mantissa, '0', mantissaSize, true);
        String sExponent = Integer.toString(FastMath.abs((int)exponent));
        String formatted = (d < 0.0 ? (char)'-' : ' ') + sMantissa + (exponent <= 0 ? (char)'-' : '+') + sExponent;
        return this.addPadding(name, formatted, c, size, rightJustified);
    }

    private void buildLine2() throws OrekitException {
        StringBuffer buffer = new StringBuffer();
        DecimalFormat f34 = new DecimalFormat("##0.0000", SYMBOLS);
        DecimalFormat f211 = new DecimalFormat("#0.00000000", SYMBOLS);
        buffer.append('2');
        buffer.append(' ');
        buffer.append(this.addPadding("satelliteNumber-2", this.satelliteNumber, '0', 5, true));
        buffer.append(' ');
        buffer.append(this.addPadding("inclination", f34.format(FastMath.toDegrees((double)this.inclination)), ' ', 8, true));
        buffer.append(' ');
        buffer.append(this.addPadding("raan", f34.format(FastMath.toDegrees((double)this.raan)), ' ', 8, true));
        buffer.append(' ');
        buffer.append(this.addPadding("eccentricity", (int)FastMath.rint((double)(this.eccentricity * 1.0E7)), '0', 7, true));
        buffer.append(' ');
        buffer.append(this.addPadding("pa", f34.format(FastMath.toDegrees((double)this.pa)), ' ', 8, true));
        buffer.append(' ');
        buffer.append(this.addPadding("meanAnomaly", f34.format(FastMath.toDegrees((double)this.meanAnomaly)), ' ', 8, true));
        buffer.append(' ');
        buffer.append(this.addPadding("meanMotion", f211.format(this.meanMotion * 43200.0 / Math.PI), ' ', 11, true));
        buffer.append(this.addPadding("revolutionNumberAtEpoch", this.revolutionNumberAtEpoch, ' ', 5, true));
        buffer.append(Integer.toString(TLE.checksum(buffer)));
        this.line2 = buffer.toString();
    }

    private String addPadding(String name, int k, char c, int size, boolean rightJustified) throws OrekitException {
        return this.addPadding(name, Integer.toString(k), c, size, rightJustified);
    }

    private String addPadding(String name, String string, char c, int size, boolean rightJustified) throws OrekitException {
        if (string.length() > size) {
            throw new OrekitException((Localizable)OrekitMessages.TLE_INVALID_PARAMETER, this.satelliteNumber, name, string);
        }
        StringBuffer padding = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            padding.append(c);
        }
        if (rightJustified) {
            String concatenated = padding + string;
            int l = concatenated.length();
            return concatenated.substring(l - size, l);
        }
        return (string + padding).substring(0, size);
    }

    private double parseDouble(String line, int start, int length) {
        String field = line.substring(start, start + length).trim();
        return field.length() > 0 ? Double.parseDouble(field.replace(' ', '0')) : 0.0;
    }

    private int parseInteger(String line, int start, int length) {
        String field = line.substring(start, start + length).trim();
        return field.length() > 0 ? Integer.parseInt(field.replace(' ', '0')) : 0;
    }

    private int parseYear(String line, int start) {
        int year = 2000 + this.parseInteger(line, start, 2);
        return year > 2056 ? year - 100 : year;
    }

    public int getSatelliteNumber() {
        return this.satelliteNumber;
    }

    public char getClassification() {
        return this.classification;
    }

    public int getLaunchYear() {
        return this.launchYear;
    }

    public int getLaunchNumber() {
        return this.launchNumber;
    }

    public String getLaunchPiece() {
        return this.launchPiece;
    }

    public int getEphemerisType() {
        return this.ephemerisType;
    }

    public int getElementNumber() {
        return this.elementNumber;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.epoch;
    }

    public double getMeanMotion() {
        return this.meanMotion;
    }

    public double getMeanMotionFirstDerivative() {
        return this.meanMotionFirstDerivative;
    }

    public double getMeanMotionSecondDerivative() {
        return this.meanMotionSecondDerivative;
    }

    public double getE() {
        return this.eccentricity;
    }

    public double getI() {
        return this.inclination;
    }

    public double getPerigeeArgument() {
        return this.pa;
    }

    public double getRaan() {
        return this.raan;
    }

    public double getMeanAnomaly() {
        return this.meanAnomaly;
    }

    public int getRevolutionNumberAtEpoch() {
        return this.revolutionNumberAtEpoch;
    }

    public double getBStar() {
        return this.bStar;
    }

    public String toString() {
        try {
            return this.getLine1() + System.getProperty("line.separator") + this.getLine2();
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    public static boolean isFormatOK(String line1, String line2) throws OrekitException {
        if (line1 == null || line1.length() != 69 || line2 == null || line2.length() != 69) {
            return false;
        }
        if (!LINE_1_PATTERN.matcher(line1).matches() || !LINE_2_PATTERN.matcher(line2).matches()) {
            return false;
        }
        int checksum1 = TLE.checksum(line1);
        if (Integer.parseInt(line1.substring(68)) != checksum1 % 10) {
            throw new OrekitException((Localizable)OrekitMessages.TLE_CHECKSUM_ERROR, 1, line1.substring(68), checksum1 % 10, line1);
        }
        int checksum2 = TLE.checksum(line2);
        if (Integer.parseInt(line2.substring(68)) != checksum2 % 10) {
            throw new OrekitException((Localizable)OrekitMessages.TLE_CHECKSUM_ERROR, 2, line2.substring(68), checksum2 % 10, line2);
        }
        return true;
    }

    private static int checksum(CharSequence line) {
        int sum = 0;
        for (int j = 0; j < 68; ++j) {
            char c = line.charAt(j);
            if (Character.isDigit(c)) {
                sum += Character.digit(c, 10);
                continue;
            }
            if (c != '-') continue;
            ++sum;
        }
        return sum % 10;
    }
}

