/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldKeplerianOrbit<T extends RealFieldElement<T>>
extends FieldOrbit<T> {
    private static final Map<Field<? extends RealFieldElement<?>>, FDSFactory<? extends RealFieldElement<?>>> FACTORIES = new HashMap();
    private static final double A;
    private static final double B;
    private final T a;
    private final T e;
    private final T i;
    private final T pa;
    private final T raan;
    private final T v;
    private final T aDot;
    private final T eDot;
    private final T iDot;
    private final T paDot;
    private final T raanDot;
    private final T vDot;
    private FieldPVCoordinates<T> partialPV;
    private final T one;
    private final T zero;
    private final FieldVector3D<T> PLUS_K;

    public FieldKeplerianOrbit(T a, T e, T i, T pa, T raan, T anomaly, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, double mu) throws IllegalArgumentException {
        this(a, e, i, pa, raan, anomaly, null, null, null, null, null, null, type, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldKeplerianOrbit(T a, T e, T i, T pa, T raan, T anomaly, T aDot, T eDot, T iDot, T paDot, T raanDot, T anomalyDot, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, double mu) throws IllegalArgumentException {
        super(frame, date, mu);
        if (((RealFieldElement)a.multiply(((RealFieldElement)e.negate()).add(1.0))).getReal() < 0.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_A_E_MISMATCH_WITH_CONIC_TYPE, a.getReal(), e.getReal());
        }
        if (!FACTORIES.containsKey(a.getField())) {
            FACTORIES.put(a.getField(), new FDSFactory(a.getField(), 1, 1));
        }
        this.a = a;
        this.aDot = aDot;
        this.e = e;
        this.eDot = eDot;
        this.i = i;
        this.iDot = iDot;
        this.pa = pa;
        this.paDot = paDot;
        this.raan = raan;
        this.raanDot = raanDot;
        this.one = (RealFieldElement)a.getField().getOne();
        this.zero = (RealFieldElement)a.getField().getZero();
        this.PLUS_K = FieldVector3D.getPlusK((Field)a.getField());
        if (this.hasDerivatives()) {
            FieldDerivativeStructure vDS;
            FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(a.getField());
            FieldDerivativeStructure eDS = factory.build(new RealFieldElement[]{e, eDot});
            FieldDerivativeStructure anomalyDS = factory.build(new RealFieldElement[]{anomaly, anomalyDot});
            switch (type) {
                case MEAN: {
                    vDS = a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(FieldKeplerianOrbit.meanToHyperbolicEccentric(anomalyDS, eDS), eDS) : FieldKeplerianOrbit.ellipticEccentricToTrue(FieldKeplerianOrbit.meanToEllipticEccentric(anomalyDS, eDS), eDS);
                    break;
                }
                case ECCENTRIC: {
                    vDS = a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(anomalyDS, eDS) : FieldKeplerianOrbit.ellipticEccentricToTrue(anomalyDS, eDS);
                    break;
                }
                case TRUE: {
                    vDS = anomalyDS;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.v = vDS.getValue();
            this.vDot = vDS.getPartialDerivative(new int[]{1});
        } else {
            switch (type) {
                case MEAN: {
                    this.v = a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(FieldKeplerianOrbit.meanToHyperbolicEccentric(anomaly, e), e) : FieldKeplerianOrbit.ellipticEccentricToTrue(FieldKeplerianOrbit.meanToEllipticEccentric(anomaly, e), e);
                    break;
                }
                case ECCENTRIC: {
                    this.v = a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(anomaly, e) : FieldKeplerianOrbit.ellipticEccentricToTrue(anomaly, e);
                    break;
                }
                case TRUE: {
                    this.v = anomaly;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.vDot = null;
        }
        if (((RealFieldElement)((RealFieldElement)e.multiply(this.v.cos())).add(1.0)).getReal() <= 0.0) {
            double vMax = ((RealFieldElement)((RealFieldElement)((RealFieldElement)e.reciprocal()).negate()).acos()).getReal();
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_ANOMALY_OUT_OF_HYPERBOLIC_RANGE, this.v.getReal(), e.getReal(), -vMax, vMax);
        }
        this.partialPV = null;
    }

    public FieldKeplerianOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, double mu) throws IllegalArgumentException {
        this(pvCoordinates, frame, mu, FieldKeplerianOrbit.hasNonKeplerianAcceleration(pvCoordinates, mu));
    }

    private FieldKeplerianOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, double mu, boolean reliableAcceleration) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
        this.one = (RealFieldElement)pvCoordinates.getPosition().getX().getField().getOne();
        this.zero = (RealFieldElement)this.one.getField().getZero();
        this.PLUS_K = FieldVector3D.getPlusK((Field)this.one.getField());
        FieldVector3D momentum = pvCoordinates.getMomentum();
        RealFieldElement m2 = momentum.getNormSq();
        this.i = FieldVector3D.angle(momentum, this.PLUS_K);
        this.raan = FieldVector3D.crossProduct(this.PLUS_K, momentum).getAlpha();
        FieldVector3D pvP = pvCoordinates.getPosition();
        FieldVector3D pvV = pvCoordinates.getVelocity();
        FieldVector3D pvA = pvCoordinates.getAcceleration();
        RealFieldElement r2 = pvP.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement V2 = pvV.getNormSq();
        RealFieldElement rV2OnMu = (RealFieldElement)((RealFieldElement)r.multiply((Object)V2)).divide(mu);
        this.a = (RealFieldElement)r.divide(((RealFieldElement)rV2OnMu.negate()).add(2.0));
        RealFieldElement muA = (RealFieldElement)this.a.multiply(mu);
        if (this.a.getReal() > 0.0) {
            RealFieldElement eSE = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(muA.sqrt());
            RealFieldElement eCE = (RealFieldElement)rV2OnMu.subtract(1.0);
            this.e = (RealFieldElement)((RealFieldElement)((RealFieldElement)eSE.multiply((Object)eSE)).add(eCE.multiply((Object)eCE))).sqrt();
            this.v = FieldKeplerianOrbit.ellipticEccentricToTrue((RealFieldElement)eSE.atan2((Object)eCE), this.e);
        } else {
            RealFieldElement eSH = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((RealFieldElement)muA.negate()).sqrt());
            RealFieldElement eCH = (RealFieldElement)rV2OnMu.subtract(1.0);
            this.e = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)m2.negate()).divide((Object)muA)).add(1.0)).sqrt();
            this.v = FieldKeplerianOrbit.hyperbolicEccentricToTrue((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)eCH.add((Object)eSH)).divide(eCH.subtract((Object)eSH))).log()).divide(2.0), this.e);
        }
        FieldVector3D node = new FieldVector3D(this.raan, this.zero);
        RealFieldElement px = FieldVector3D.dotProduct(pvP, (FieldVector3D)node);
        RealFieldElement py = (RealFieldElement)FieldVector3D.dotProduct(pvP, (FieldVector3D)FieldVector3D.crossProduct(momentum, (FieldVector3D)node)).divide(m2.sqrt());
        this.pa = (RealFieldElement)((RealFieldElement)py.atan2((Object)px)).subtract(this.v);
        this.partialPV = pvCoordinates;
        if (!FACTORIES.containsKey(this.a.getField())) {
            FACTORIES.put(this.a.getField(), new FDSFactory(this.a.getField(), 1, 1));
        }
        if (reliableAcceleration) {
            RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
            this.getJacobianWrtCartesian(PositionAngle.MEAN, jacobian);
            FieldVector3D keplerianAcceleration = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply((Object)r2)).reciprocal()).multiply(-mu), pvP);
            FieldVector3D nonKeplerianAcceleration = pvA.subtract(keplerianAcceleration);
            RealFieldElement aX = nonKeplerianAcceleration.getX();
            RealFieldElement aY = nonKeplerianAcceleration.getY();
            RealFieldElement aZ = nonKeplerianAcceleration.getZ();
            this.aDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[0][3].multiply((Object)aX)).add(jacobian[0][4].multiply((Object)aY))).add(jacobian[0][5].multiply((Object)aZ));
            this.eDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[1][3].multiply((Object)aX)).add(jacobian[1][4].multiply((Object)aY))).add(jacobian[1][5].multiply((Object)aZ));
            this.iDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[2][3].multiply((Object)aX)).add(jacobian[2][4].multiply((Object)aY))).add(jacobian[2][5].multiply((Object)aZ));
            this.paDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[3][3].multiply((Object)aX)).add(jacobian[3][4].multiply((Object)aY))).add(jacobian[3][5].multiply((Object)aZ));
            this.raanDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[4][3].multiply((Object)aX)).add(jacobian[4][4].multiply((Object)aY))).add(jacobian[4][5].multiply((Object)aZ));
            RealFieldElement MDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getKeplerianMeanMotion().add(jacobian[5][3].multiply((Object)aX))).add(jacobian[5][4].multiply((Object)aY))).add(jacobian[5][5].multiply((Object)aZ));
            FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
            FieldDerivativeStructure eDS = factory.build(new RealFieldElement[]{this.e, this.eDot});
            FieldDerivativeStructure MDS = factory.build(new RealFieldElement[]{this.getMeanAnomaly(), MDot});
            FieldDerivativeStructure vDS = this.a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(FieldKeplerianOrbit.meanToHyperbolicEccentric(MDS, eDS), eDS) : FieldKeplerianOrbit.ellipticEccentricToTrue(FieldKeplerianOrbit.meanToEllipticEccentric(MDS, eDS), eDS);
            this.vDot = vDS.getPartialDerivative(new int[]{1});
        } else {
            this.aDot = null;
            this.eDot = null;
            this.iDot = null;
            this.paDot = null;
            this.raanDot = null;
            this.vDot = null;
        }
    }

    public FieldKeplerianOrbit(FieldPVCoordinates<T> FieldPVCoordinates2, Frame frame, FieldAbsoluteDate<T> date, double mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, FieldPVCoordinates2), frame, mu);
    }

    public FieldKeplerianOrbit(FieldOrbit<T> op) {
        this(op.getPVCoordinates(), op.getFrame(), op.getMu(), op.hasDerivatives());
    }

    @Override
    public OrbitType getType() {
        return OrbitType.KEPLERIAN;
    }

    @Override
    public T getA() {
        return this.a;
    }

    @Override
    public T getADot() {
        return this.aDot;
    }

    @Override
    public T getE() {
        return this.e;
    }

    @Override
    public T getEDot() {
        return this.eDot;
    }

    @Override
    public T getI() {
        return this.i;
    }

    @Override
    public T getIDot() {
        return this.iDot;
    }

    public T getPerigeeArgument() {
        return this.pa;
    }

    public T getPerigeeArgumentDot() {
        return this.paDot;
    }

    public T getRightAscensionOfAscendingNode() {
        return this.raan;
    }

    public T getRightAscensionOfAscendingNodeDot() {
        return this.raanDot;
    }

    public T getTrueAnomaly() {
        return this.v;
    }

    public T getTrueAnomalyDot() {
        return this.vDot;
    }

    public T getEccentricAnomaly() {
        return this.a.getReal() < 0.0 ? FieldKeplerianOrbit.trueToHyperbolicEccentric(this.v, this.e) : FieldKeplerianOrbit.trueToEllipticEccentric(this.v, this.e);
    }

    public T getEccentricAnomalyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure eDS = factory.build(new RealFieldElement[]{this.e, this.eDot});
        FieldDerivativeStructure vDS = factory.build(new RealFieldElement[]{this.v, this.vDot});
        FieldDerivativeStructure EDS = this.a.getReal() < 0.0 ? FieldKeplerianOrbit.trueToHyperbolicEccentric(vDS, eDS) : FieldKeplerianOrbit.trueToEllipticEccentric(vDS, eDS);
        return (T)EDS.getPartialDerivative(new int[]{1});
    }

    public T getMeanAnomaly() {
        return this.a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToMean(FieldKeplerianOrbit.trueToHyperbolicEccentric(this.v, this.e), this.e) : FieldKeplerianOrbit.ellipticEccentricToMean(FieldKeplerianOrbit.trueToEllipticEccentric(this.v, this.e), this.e);
    }

    public T getMeanAnomalyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure eDS = factory.build(new RealFieldElement[]{this.e, this.eDot});
        FieldDerivativeStructure vDS = factory.build(new RealFieldElement[]{this.v, this.vDot});
        FieldDerivativeStructure MDS = this.a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToMean(FieldKeplerianOrbit.trueToHyperbolicEccentric(vDS, eDS), eDS) : FieldKeplerianOrbit.ellipticEccentricToMean(FieldKeplerianOrbit.trueToEllipticEccentric(vDS, eDS), eDS);
        return (T)MDS.getPartialDerivative(new int[]{1});
    }

    public T getAnomaly(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getMeanAnomaly() : (type == PositionAngle.ECCENTRIC ? this.getEccentricAnomaly() : this.getTrueAnomaly());
    }

    public T getAnomalyDot(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getMeanAnomalyDot() : (type == PositionAngle.ECCENTRIC ? this.getEccentricAnomalyDot() : this.getTrueAnomalyDot());
    }

    @Override
    public boolean hasDerivatives() {
        return this.aDot != null;
    }

    public static <T extends RealFieldElement<T>> T ellipticEccentricToTrue(T E, T e) {
        RealFieldElement beta = (RealFieldElement)e.divide(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)e.multiply(e)).negate()).add(1.0)).sqrt()).add(1.0));
        return (T)((RealFieldElement)E.add(((RealFieldElement)((RealFieldElement)((RealFieldElement)beta.multiply(E.sin())).divide(((RealFieldElement)((RealFieldElement)beta.multiply(E.cos())).subtract(1.0)).negate())).atan()).multiply(2)));
    }

    public static <T extends RealFieldElement<T>> T trueToEllipticEccentric(T v, T e) {
        RealFieldElement beta = (RealFieldElement)e.divide(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)e.multiply(e)).negate()).add(1.0)).sqrt()).add(1.0));
        return (T)((RealFieldElement)v.subtract(((RealFieldElement)((RealFieldElement)((RealFieldElement)beta.multiply(v.sin())).divide(((RealFieldElement)beta.multiply(v.cos())).add(1.0))).atan()).multiply(2)));
    }

    public static <T extends RealFieldElement<T>> T hyperbolicEccentricToTrue(T H, T e) {
        RealFieldElement s = (RealFieldElement)((RealFieldElement)((RealFieldElement)e.add(1.0)).divide(e.subtract(1.0))).sqrt();
        RealFieldElement tanH = (RealFieldElement)((RealFieldElement)H.multiply(0.5)).tanh();
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)s.multiply((Object)tanH)).atan()).multiply(2));
    }

    public static <T extends RealFieldElement<T>> T trueToHyperbolicEccentric(T v, T e) {
        RealFieldElement sinhH = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)e.multiply(e)).subtract(1.0)).sqrt()).multiply(v.sin())).divide(((RealFieldElement)e.multiply(v.cos())).add(1.0));
        return (T)((RealFieldElement)sinhH.asinh());
    }

    public static <T extends RealFieldElement<T>> T hyperbolicEccentricToMean(T H, T e) {
        return (T)((RealFieldElement)((RealFieldElement)e.multiply(H.sinh())).subtract(H));
    }

    public static <T extends RealFieldElement<T>> T meanToEllipticEccentric(T M, T e) {
        RealFieldElement w;
        RealFieldElement E;
        RealFieldElement reducedM = FieldKeplerianOrbit.normalizeAngle(M, (RealFieldElement)M.getField().getZero());
        if (((RealFieldElement)reducedM.abs()).getReal() < 0.16666666666666666) {
            E = FastMath.abs((double)reducedM.getReal()) < Precision.SAFE_MIN ? reducedM : (RealFieldElement)reducedM.add(e.multiply(((RealFieldElement)((RealFieldElement)reducedM.multiply(6)).cbrt()).subtract((Object)reducedM)));
        } else if (reducedM.getReal() < 0.0) {
            w = (RealFieldElement)reducedM.add(Math.PI);
            E = (RealFieldElement)reducedM.add(e.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)w.multiply(A)).divide(((RealFieldElement)w.negate()).add(B))).subtract(Math.PI)).subtract((Object)reducedM)));
        } else {
            w = (RealFieldElement)((RealFieldElement)reducedM.negate()).add(Math.PI);
            E = (RealFieldElement)reducedM.add(e.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)w.multiply(A)).divide(((RealFieldElement)w.negate()).add(B))).negate()).subtract((Object)reducedM)).add(Math.PI)));
        }
        RealFieldElement e1 = (RealFieldElement)((RealFieldElement)e.negate()).add(1.0);
        boolean noCancellationRisk = e1.getReal() + E.getReal() * E.getReal() / 6.0 >= 0.1;
        for (int j = 0; j < 2; ++j) {
            RealFieldElement fd;
            RealFieldElement f;
            RealFieldElement fdd = (RealFieldElement)e.multiply(E.sin());
            RealFieldElement fddd = (RealFieldElement)e.multiply(E.cos());
            if (noCancellationRisk) {
                f = (RealFieldElement)((RealFieldElement)E.subtract((Object)fdd)).subtract((Object)reducedM);
                fd = (RealFieldElement)((RealFieldElement)fddd.negate()).add(1.0);
            } else {
                f = (RealFieldElement)FieldKeplerianOrbit.eMeSinE(E, e).subtract((Object)reducedM);
                RealFieldElement s = (RealFieldElement)((RealFieldElement)E.multiply(0.5)).sin();
                fd = (RealFieldElement)e1.add(((RealFieldElement)((RealFieldElement)e.multiply((Object)s)).multiply((Object)s)).multiply(2));
            }
            RealFieldElement dee = (RealFieldElement)((RealFieldElement)f.multiply((Object)fd)).divide(((RealFieldElement)((RealFieldElement)f.multiply((Object)fdd)).multiply(0.5)).subtract(fd.multiply((Object)fd)));
            RealFieldElement w2 = (RealFieldElement)fd.add(((RealFieldElement)dee.multiply(fdd.add(dee.multiply(fddd.divide(3.0))))).multiply(0.5));
            fd = (RealFieldElement)fd.add(dee.multiply(fdd.add(((RealFieldElement)dee.multiply((Object)fddd)).multiply(0.5))));
            E = (RealFieldElement)E.subtract(((RealFieldElement)f.subtract(dee.multiply(fd.subtract((Object)w2)))).divide((Object)fd));
        }
        E = (RealFieldElement)((RealFieldElement)E.add(M)).subtract((Object)reducedM);
        return (T)E;
    }

    private static <T extends RealFieldElement<T>> T eMeSinE(T E, T e) {
        RealFieldElement x = (RealFieldElement)((RealFieldElement)((RealFieldElement)e.negate()).add(1.0)).multiply(E.sin());
        RealFieldElement mE2 = (RealFieldElement)((RealFieldElement)E.negate()).multiply(E);
        Object term = E;
        double d = 0.0;
        RealFieldElement x0 = (RealFieldElement)((RealFieldElement)E.getField().getZero()).add(Double.NaN);
        while (x.getReal() != x0.getReal()) {
            term = (RealFieldElement)term.multiply(mE2.divide((d += 2.0) * (d + 1.0)));
            x0 = x;
            x = (RealFieldElement)x.subtract(term);
        }
        return (T)x;
    }

    public static <T extends RealFieldElement<T>> T meanToHyperbolicEccentric(T M, T e) {
        RealFieldElement H = e.getReal() < 1.6 ? (-Math.PI < M.getReal() && M.getReal() < 0.0 || M.getReal() > Math.PI ? (RealFieldElement)M.subtract(e) : (RealFieldElement)M.add(e)) : (e.getReal() < 3.6 && ((RealFieldElement)M.abs()).getReal() > Math.PI ? (RealFieldElement)M.subtract(e.copySign(M)) : (RealFieldElement)M.divide(e.subtract(1.0)));
        int iter = 0;
        do {
            RealFieldElement f3 = (RealFieldElement)e.multiply(H.cosh());
            RealFieldElement f2 = (RealFieldElement)e.multiply(H.sinh());
            RealFieldElement f1 = (RealFieldElement)f3.subtract(1.0);
            RealFieldElement f0 = (RealFieldElement)((RealFieldElement)f2.subtract((Object)H)).subtract(M);
            RealFieldElement f12 = (RealFieldElement)f1.multiply(2);
            RealFieldElement d = (RealFieldElement)f0.divide((Object)f12);
            RealFieldElement fdf = (RealFieldElement)f1.subtract(d.multiply((Object)f2));
            RealFieldElement ds = (RealFieldElement)f0.divide((Object)fdf);
            RealFieldElement shift = (RealFieldElement)f0.divide(fdf.add(ds.multiply(ds.multiply(f3.divide(6.0)))));
            H = (RealFieldElement)H.subtract((Object)shift);
            if (!(((RealFieldElement)shift.abs()).getReal() <= 1.0E-12)) continue;
            return (T)H;
        } while (++iter < 50);
        throw new MathIllegalArgumentException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_HYPERBOLIC_ECCENTRIC_ANOMALY, new Object[]{iter});
    }

    public static <T extends RealFieldElement<T>> T ellipticEccentricToMean(T E, T e) {
        return (T)((RealFieldElement)E.subtract(e.multiply(E.sin())));
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> ellipticKeplerianToPosition(T a, T e, T i, T pa, T raan, T v, double mu) {
        RealFieldElement cosRaan = (RealFieldElement)raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)raan.sin();
        RealFieldElement cosPa = (RealFieldElement)pa.cos();
        RealFieldElement sinPa = (RealFieldElement)pa.sin();
        RealFieldElement cosI = (RealFieldElement)i.cos();
        RealFieldElement sinI = (RealFieldElement)i.sin();
        RealFieldElement crcp = (RealFieldElement)cosRaan.multiply((Object)cosPa);
        RealFieldElement crsp = (RealFieldElement)cosRaan.multiply((Object)sinPa);
        RealFieldElement srcp = (RealFieldElement)sinRaan.multiply((Object)cosPa);
        RealFieldElement srsp = (RealFieldElement)sinRaan.multiply((Object)sinPa);
        FieldVector3D p = new FieldVector3D((RealFieldElement)crcp.subtract(cosI.multiply((Object)srsp)), (RealFieldElement)srcp.add(cosI.multiply((Object)crsp)), (RealFieldElement)sinI.multiply((Object)sinPa));
        FieldVector3D q = new FieldVector3D((RealFieldElement)((RealFieldElement)crsp.add(cosI.multiply((Object)srcp))).negate(), (RealFieldElement)((RealFieldElement)cosI.multiply((Object)crcp)).subtract((Object)srsp), (RealFieldElement)sinI.multiply((Object)cosPa));
        RealFieldElement uME2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)e.negate()).add(1.0)).multiply(e.add(1.0));
        RealFieldElement s1Me2 = (RealFieldElement)uME2.sqrt();
        T E = a.getReal() < 0.0 ? FieldKeplerianOrbit.trueToHyperbolicEccentric(v, e) : FieldKeplerianOrbit.trueToEllipticEccentric(v, e);
        RealFieldElement cosE = (RealFieldElement)E.cos();
        RealFieldElement sinE = (RealFieldElement)E.sin();
        RealFieldElement x = (RealFieldElement)a.multiply(cosE.subtract(e));
        RealFieldElement y = (RealFieldElement)((RealFieldElement)a.multiply((Object)sinE)).multiply((Object)s1Me2);
        return new FieldVector3D(x, p, y, q);
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> hyperbolicKeplerianToPosition(T a, T e, T i, T pa, T raan, T v, double mu) {
        RealFieldElement cosRaan = (RealFieldElement)raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)raan.sin();
        RealFieldElement cosPa = (RealFieldElement)pa.cos();
        RealFieldElement sinPa = (RealFieldElement)pa.sin();
        RealFieldElement cosI = (RealFieldElement)i.cos();
        RealFieldElement sinI = (RealFieldElement)i.sin();
        RealFieldElement crcp = (RealFieldElement)cosRaan.multiply((Object)cosPa);
        RealFieldElement crsp = (RealFieldElement)cosRaan.multiply((Object)sinPa);
        RealFieldElement srcp = (RealFieldElement)sinRaan.multiply((Object)cosPa);
        RealFieldElement srsp = (RealFieldElement)sinRaan.multiply((Object)sinPa);
        FieldVector3D p = new FieldVector3D((RealFieldElement)crcp.subtract(cosI.multiply((Object)srsp)), (RealFieldElement)srcp.add(cosI.multiply((Object)crsp)), (RealFieldElement)sinI.multiply((Object)sinPa));
        FieldVector3D q = new FieldVector3D((RealFieldElement)((RealFieldElement)crsp.add(cosI.multiply((Object)srcp))).negate(), (RealFieldElement)((RealFieldElement)cosI.multiply((Object)crcp)).subtract((Object)srsp), (RealFieldElement)sinI.multiply((Object)cosPa));
        RealFieldElement sinV = (RealFieldElement)v.sin();
        RealFieldElement cosV = (RealFieldElement)v.cos();
        RealFieldElement f = (RealFieldElement)a.multiply(((RealFieldElement)((RealFieldElement)e.multiply(e)).negate()).add(1.0));
        RealFieldElement posFactor = (RealFieldElement)f.divide(((RealFieldElement)e.multiply((Object)cosV)).add(1.0));
        RealFieldElement x = (RealFieldElement)posFactor.multiply((Object)cosV);
        RealFieldElement y = (RealFieldElement)posFactor.multiply((Object)sinV);
        return new FieldVector3D(x, p, y, q);
    }

    @Override
    public T getEquinoctialEx() {
        return (T)((RealFieldElement)this.e.multiply(((RealFieldElement)this.pa.add(this.raan)).cos()));
    }

    @Override
    public T getEquinoctialExDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure eDS = factory.build(new RealFieldElement[]{this.e, this.eDot});
        FieldDerivativeStructure paDS = factory.build(new RealFieldElement[]{this.pa, this.paDot});
        FieldDerivativeStructure raanDS = factory.build(new RealFieldElement[]{this.raan, this.raanDot});
        return (T)eDS.multiply(paDS.add(raanDS).cos()).getPartialDerivative(new int[]{1});
    }

    @Override
    public T getEquinoctialEy() {
        return (T)((RealFieldElement)this.e.multiply(((RealFieldElement)this.pa.add(this.raan)).sin()));
    }

    @Override
    public T getEquinoctialEyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure eDS = factory.build(new RealFieldElement[]{this.e, this.eDot});
        FieldDerivativeStructure paDS = factory.build(new RealFieldElement[]{this.pa, this.paDot});
        FieldDerivativeStructure raanDS = factory.build(new RealFieldElement[]{this.raan, this.raanDot});
        return (T)eDS.multiply(paDS.add(raanDS).sin()).getPartialDerivative(new int[]{1});
    }

    @Override
    public T getHx() {
        if (FastMath.abs((double)(this.i.getReal() - Math.PI)) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((RealFieldElement)((RealFieldElement)this.raan.cos()).multiply(((RealFieldElement)this.i.divide(2.0)).tan()));
    }

    @Override
    public T getHxDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs((double)(this.i.getReal() - Math.PI)) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure iDS = factory.build(new RealFieldElement[]{this.i, this.iDot});
        FieldDerivativeStructure raanDS = factory.build(new RealFieldElement[]{this.raan, this.raanDot});
        return (T)raanDS.cos().multiply(iDS.multiply(0.5).tan()).getPartialDerivative(new int[]{1});
    }

    @Override
    public T getHy() {
        if (FastMath.abs((double)(this.i.getReal() - Math.PI)) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((RealFieldElement)((RealFieldElement)this.raan.sin()).multiply(((RealFieldElement)this.i.divide(2.0)).tan()));
    }

    @Override
    public T getHyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs((double)(this.i.getReal() - Math.PI)) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure iDS = factory.build(new RealFieldElement[]{this.i, this.iDot});
        FieldDerivativeStructure raanDS = factory.build(new RealFieldElement[]{this.raan, this.raanDot});
        return (T)raanDS.sin().multiply(iDS.multiply(0.5).tan()).getPartialDerivative(new int[]{1});
    }

    @Override
    public T getLv() {
        return (T)((RealFieldElement)((RealFieldElement)this.pa.add(this.raan)).add(this.v));
    }

    @Override
    public T getLvDot() {
        return (T)(this.hasDerivatives() ? (RealFieldElement)((RealFieldElement)this.paDot.add(this.raanDot)).add(this.vDot) : null);
    }

    @Override
    public T getLE() {
        return (T)((RealFieldElement)((RealFieldElement)this.pa.add(this.raan)).add(this.getEccentricAnomaly()));
    }

    @Override
    public T getLEDot() {
        return (T)(this.hasDerivatives() ? (RealFieldElement)((RealFieldElement)this.paDot.add(this.raanDot)).add(this.getEccentricAnomalyDot()) : null);
    }

    @Override
    public T getLM() {
        return (T)((RealFieldElement)((RealFieldElement)this.pa.add(this.raan)).add(this.getMeanAnomaly()));
    }

    @Override
    public T getLMDot() {
        return (T)(this.hasDerivatives() ? (RealFieldElement)((RealFieldElement)this.paDot.add(this.raanDot)).add(this.getMeanAnomalyDot()) : null);
    }

    private void computePVWithoutA() {
        if (this.partialPV != null) {
            return;
        }
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        RealFieldElement cosPa = (RealFieldElement)this.pa.cos();
        RealFieldElement sinPa = (RealFieldElement)this.pa.sin();
        RealFieldElement cosI = (RealFieldElement)this.i.cos();
        RealFieldElement sinI = (RealFieldElement)this.i.sin();
        RealFieldElement crcp = (RealFieldElement)cosRaan.multiply((Object)cosPa);
        RealFieldElement crsp = (RealFieldElement)cosRaan.multiply((Object)sinPa);
        RealFieldElement srcp = (RealFieldElement)sinRaan.multiply((Object)cosPa);
        RealFieldElement srsp = (RealFieldElement)sinRaan.multiply((Object)sinPa);
        FieldVector3D p = new FieldVector3D((RealFieldElement)crcp.subtract(cosI.multiply((Object)srsp)), (RealFieldElement)srcp.add(cosI.multiply((Object)crsp)), (RealFieldElement)sinI.multiply((Object)sinPa));
        FieldVector3D q = new FieldVector3D((RealFieldElement)((RealFieldElement)crsp.add(cosI.multiply((Object)srcp))).negate(), (RealFieldElement)((RealFieldElement)cosI.multiply((Object)crcp)).subtract((Object)srsp), (RealFieldElement)sinI.multiply((Object)cosPa));
        if (this.a.getReal() > 0.0) {
            RealFieldElement uME2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.negate()).add(1.0)).multiply(this.e.add(1.0));
            RealFieldElement s1Me2 = (RealFieldElement)uME2.sqrt();
            T E = this.getEccentricAnomaly();
            RealFieldElement cosE = (RealFieldElement)E.cos();
            RealFieldElement sinE = (RealFieldElement)E.sin();
            RealFieldElement x = (RealFieldElement)this.a.multiply(cosE.subtract(this.e));
            RealFieldElement y = (RealFieldElement)((RealFieldElement)this.a.multiply((Object)sinE)).multiply((Object)s1Me2);
            RealFieldElement factor = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.a.reciprocal()).multiply(this.getMu())).sqrt()).divide(((RealFieldElement)((RealFieldElement)this.e.negate()).multiply((Object)cosE)).add(1.0));
            RealFieldElement xDot = (RealFieldElement)((RealFieldElement)sinE.negate()).multiply((Object)factor);
            RealFieldElement yDot = (RealFieldElement)((RealFieldElement)cosE.multiply((Object)s1Me2)).multiply((Object)factor);
            FieldVector3D position = new FieldVector3D(x, p, y, q);
            FieldVector3D velocity = new FieldVector3D(xDot, p, yDot, q);
            this.partialPV = new FieldPVCoordinates(position, velocity);
        } else {
            RealFieldElement sinV = (RealFieldElement)this.v.sin();
            RealFieldElement cosV = (RealFieldElement)this.v.cos();
            RealFieldElement f = (RealFieldElement)this.a.multiply(((RealFieldElement)((RealFieldElement)this.e.multiply(this.e)).negate()).add(1.0));
            RealFieldElement posFactor = (RealFieldElement)f.divide(((RealFieldElement)this.e.multiply((Object)cosV)).add(1.0));
            RealFieldElement velFactor = (RealFieldElement)((RealFieldElement)((RealFieldElement)f.reciprocal()).multiply(this.getMu())).sqrt();
            FieldVector3D position = new FieldVector3D((RealFieldElement)posFactor.multiply((Object)cosV), p, (RealFieldElement)posFactor.multiply((Object)sinV), q);
            FieldVector3D velocity = new FieldVector3D((RealFieldElement)((RealFieldElement)velFactor.multiply((Object)sinV)).negate(), p, (RealFieldElement)velFactor.multiply(this.e.add((Object)cosV)), q);
            this.partialPV = new FieldPVCoordinates(position, velocity);
        }
    }

    private FieldVector3D<T> nonKeplerianAcceleration() {
        RealFieldElement[][] dCdP = (RealFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
        this.getJacobianWrtParameters(PositionAngle.MEAN, dCdP);
        RealFieldElement nonKeplerianMeanMotion = (RealFieldElement)this.getMeanAnomalyDot().subtract(this.getKeplerianMeanMotion());
        RealFieldElement nonKeplerianAx = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[3][0].multiply(this.aDot)).add(dCdP[3][1].multiply(this.eDot))).add(dCdP[3][2].multiply(this.iDot))).add(dCdP[3][3].multiply(this.paDot))).add(dCdP[3][4].multiply(this.raanDot))).add(dCdP[3][5].multiply((Object)nonKeplerianMeanMotion));
        RealFieldElement nonKeplerianAy = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[4][0].multiply(this.aDot)).add(dCdP[4][1].multiply(this.eDot))).add(dCdP[4][2].multiply(this.iDot))).add(dCdP[4][3].multiply(this.paDot))).add(dCdP[4][4].multiply(this.raanDot))).add(dCdP[4][5].multiply((Object)nonKeplerianMeanMotion));
        RealFieldElement nonKeplerianAz = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[5][0].multiply(this.aDot)).add(dCdP[5][1].multiply(this.eDot))).add(dCdP[5][2].multiply(this.iDot))).add(dCdP[5][3].multiply(this.paDot))).add(dCdP[5][4].multiply(this.raanDot))).add(dCdP[5][5].multiply((Object)nonKeplerianMeanMotion));
        return new FieldVector3D(nonKeplerianAx, nonKeplerianAy, nonKeplerianAz);
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        this.computePVWithoutA();
        RealFieldElement r2 = this.partialPV.getPosition().getNormSq();
        FieldVector3D keplerianAcceleration = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)r2.multiply(r2.sqrt())).reciprocal()).multiply(-this.getMu()), this.partialPV.getPosition());
        FieldVector3D acceleration = this.hasDerivatives() ? keplerianAcceleration.add(this.nonKeplerianAcceleration()) : keplerianAcceleration;
        return new TimeStampedFieldPVCoordinates(this.getDate(), this.partialPV.getPosition(), this.partialPV.getVelocity(), acceleration);
    }

    @Override
    public FieldKeplerianOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((RealFieldElement)((RealFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public FieldKeplerianOrbit<T> shiftedBy(T dt) {
        FieldKeplerianOrbit<RealFieldElement> keplerianShifted = new FieldKeplerianOrbit<RealFieldElement>((RealFieldElement)this.a, (RealFieldElement)this.e, (RealFieldElement)this.i, (RealFieldElement)this.pa, (RealFieldElement)this.raan, (RealFieldElement)((RealFieldElement)this.getKeplerianMeanMotion().multiply(dt)).add(this.getMeanAnomaly()), PositionAngle.MEAN, this.getFrame(), this.getDate().shiftedBy(dt), this.getMu());
        if (this.hasDerivatives()) {
            FieldVector3D<T> nonKeplerianAcceleration = this.nonKeplerianAcceleration();
            super.computePVWithoutA();
            FieldVector3D fixedP = new FieldVector3D(this.one, keplerianShifted.partialPV.getPosition(), (RealFieldElement)((RealFieldElement)dt.multiply(dt)).multiply(0.5), nonKeplerianAcceleration);
            RealFieldElement fixedR2 = fixedP.getNormSq();
            RealFieldElement fixedR = (RealFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.one, keplerianShifted.partialPV.getVelocity(), dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)fixedR2.multiply((Object)fixedR)).reciprocal()).multiply(-this.getMu()), keplerianShifted.partialPV.getPosition(), this.one, nonKeplerianAcceleration);
            return new FieldKeplerianOrbit(new TimeStampedFieldPVCoordinates(keplerianShifted.getDate(), fixedP, fixedV, fixedA), keplerianShifted.getFrame(), keplerianShifted.getMu());
        }
        return keplerianShifted;
    }

    @Override
    public FieldKeplerianOrbit<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldOrbit<T>> sample) {
        List list = sample.collect(Collectors.toList());
        boolean useDerivatives = true;
        for (FieldOrbit orbit : list) {
            useDerivatives = useDerivatives && orbit.hasDerivatives();
        }
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate previousDate = null;
        Object previousPA = (RealFieldElement)this.zero.add(Double.NaN);
        Object previousRAAN = (RealFieldElement)this.zero.add(Double.NaN);
        Object previousM = (RealFieldElement)this.zero.add(Double.NaN);
        for (FieldOrbit orbit : list) {
            Object continuousM;
            Object continuousRAAN;
            Object continuousPA;
            FieldKeplerianOrbit kep = (FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(orbit);
            if (previousDate == null) {
                continuousPA = kep.getPerigeeArgument();
                continuousRAAN = kep.getRightAscensionOfAscendingNode();
                continuousM = kep.getMeanAnomaly();
            } else {
                Object dt = kep.getDate().durationFrom(previousDate);
                RealFieldElement keplerM = (RealFieldElement)previousM.add(kep.getKeplerianMeanMotion().multiply(dt));
                continuousPA = FieldKeplerianOrbit.normalizeAngle(kep.getPerigeeArgument(), previousPA);
                continuousRAAN = FieldKeplerianOrbit.normalizeAngle(kep.getRightAscensionOfAscendingNode(), previousRAAN);
                continuousM = FieldKeplerianOrbit.normalizeAngle(kep.getMeanAnomaly(), keplerM);
            }
            previousDate = kep.getDate();
            previousPA = continuousPA;
            previousRAAN = continuousRAAN;
            previousM = continuousM;
            RealFieldElement[] toAdd = (RealFieldElement[])MathArrays.buildArray((Field)this.getA().getField(), (int)6);
            toAdd[0] = kep.getA();
            toAdd[1] = kep.getE();
            toAdd[2] = kep.getI();
            toAdd[3] = continuousPA;
            toAdd[4] = continuousRAAN;
            toAdd[5] = continuousM;
            if (useDerivatives) {
                RealFieldElement[] toAddDot = (RealFieldElement[])MathArrays.buildArray((Field)this.one.getField(), (int)6);
                toAddDot[0] = kep.getADot();
                toAddDot[1] = kep.getEDot();
                toAddDot[2] = kep.getIDot();
                toAddDot[3] = kep.getPerigeeArgumentDot();
                toAddDot[4] = kep.getRightAscensionOfAscendingNodeDot();
                toAddDot[5] = kep.getMeanAnomalyDot();
                interpolator.addSamplePoint(kep.getDate().durationFrom(date), (FieldElement[][])new RealFieldElement[][]{toAdd, toAddDot});
                continue;
            }
            interpolator.addSamplePoint((FieldElement)this.zero.add(kep.getDate().durationFrom(date)), (FieldElement[][])new RealFieldElement[][]{toAdd});
        }
        RealFieldElement[][] interpolated = (RealFieldElement[][])interpolator.derivatives(this.zero, 1);
        return new FieldKeplerianOrbit<RealFieldElement>(interpolated[0][0], interpolated[0][1], interpolated[0][2], interpolated[0][3], interpolated[0][4], interpolated[0][5], interpolated[1][0], interpolated[1][1], interpolated[1][2], interpolated[1][3], interpolated[1][4], interpolated[1][5], PositionAngle.MEAN, this.getFrame(), date, this.getMu());
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        if (this.a.getReal() > 0.0) {
            return this.computeJacobianMeanWrtCartesianElliptical();
        }
        return this.computeJacobianMeanWrtCartesianHyperbolic();
    }

    private T[][] computeJacobianMeanWrtCartesianElliptical() {
        RealFieldElement factorI1;
        RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray((Field)this.getA().getField(), (int)6, (int)6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        FieldVector3D<T> momentum = this.partialPV.getMomentum();
        RealFieldElement v2 = velocity.getNormSq();
        RealFieldElement r2 = position.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement r3 = (RealFieldElement)r.multiply((Object)r2);
        RealFieldElement px = position.getX();
        RealFieldElement py = position.getY();
        RealFieldElement pz = position.getZ();
        RealFieldElement vx = velocity.getX();
        RealFieldElement vy = velocity.getY();
        RealFieldElement vz = velocity.getZ();
        RealFieldElement mx = momentum.getX();
        RealFieldElement my = momentum.getY();
        RealFieldElement mz = momentum.getZ();
        double mu = this.getMu();
        RealFieldElement sqrtMuA = (RealFieldElement)((RealFieldElement)this.a.multiply(mu)).sqrt();
        RealFieldElement sqrtAoMu = (RealFieldElement)((RealFieldElement)this.a.divide(mu)).sqrt();
        RealFieldElement a2 = (RealFieldElement)this.a.multiply(this.a);
        RealFieldElement twoA = (RealFieldElement)this.a.multiply(2);
        RealFieldElement rOnA = (RealFieldElement)r.divide(this.a);
        RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply(this.e)).negate()).add(1.0);
        RealFieldElement epsilon = (RealFieldElement)oMe2.sqrt();
        RealFieldElement sqrtRec = (RealFieldElement)epsilon.reciprocal();
        RealFieldElement cosI = (RealFieldElement)this.i.cos();
        RealFieldElement sinI = (RealFieldElement)this.i.sin();
        RealFieldElement cosPA = (RealFieldElement)this.pa.cos();
        RealFieldElement sinPA = (RealFieldElement)this.pa.sin();
        RealFieldElement pv = FieldVector3D.dotProduct(position, velocity);
        RealFieldElement cosE = (RealFieldElement)((RealFieldElement)this.a.subtract((Object)r)).divide(this.a.multiply(this.e));
        RealFieldElement sinE = (RealFieldElement)pv.divide(this.e.multiply((Object)sqrtMuA));
        FieldVector3D vectorAR = new FieldVector3D((RealFieldElement)((RealFieldElement)a2.multiply(2)).divide((Object)r3), position);
        FieldVector3D vectorARDot = velocity.scalarMultiply((RealFieldElement)a2.multiply(2.0 / mu));
        this.fillHalfRow((RealFieldElement)this.one, vectorAR, jacobian[0], 0);
        this.fillHalfRow((RealFieldElement)this.one, vectorARDot, jacobian[0], 3);
        RealFieldElement factorER3 = (RealFieldElement)pv.divide((Object)twoA);
        FieldVector3D vectorER = new FieldVector3D((RealFieldElement)((RealFieldElement)cosE.multiply((Object)v2)).divide(r.multiply(mu)), position, (RealFieldElement)sinE.divide((Object)sqrtMuA), velocity, (RealFieldElement)((RealFieldElement)((RealFieldElement)factorER3.negate()).multiply((Object)sinE)).divide((Object)sqrtMuA), vectorAR);
        FieldVector3D vectorERDot = new FieldVector3D((RealFieldElement)sinE.divide((Object)sqrtMuA), position, (RealFieldElement)((RealFieldElement)cosE.multiply(2.0 / mu)).multiply((Object)r), velocity, (RealFieldElement)((RealFieldElement)((RealFieldElement)factorER3.negate()).multiply((Object)sinE)).divide((Object)sqrtMuA), vectorARDot);
        this.fillHalfRow((RealFieldElement)this.one, vectorER, jacobian[1], 0);
        this.fillHalfRow((RealFieldElement)this.one, vectorERDot, jacobian[1], 3);
        RealFieldElement coefE = (RealFieldElement)cosE.divide(this.e.multiply((Object)sqrtMuA));
        FieldVector3D vectorEAnR = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)sinE.negate()).multiply((Object)v2)).divide(((RealFieldElement)this.e.multiply((Object)r)).multiply(mu)), position, coefE, velocity, (RealFieldElement)((RealFieldElement)factorER3.negate()).multiply((Object)coefE), vectorAR);
        FieldVector3D vectorEAnRDot = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)sinE.multiply(-2)).multiply((Object)r)).divide(this.e.multiply(mu)), velocity, coefE, position, (RealFieldElement)((RealFieldElement)factorER3.negate()).multiply((Object)coefE), vectorARDot);
        RealFieldElement s1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)sinE.negate()).multiply((Object)pz)).divide((Object)r)).subtract(((RealFieldElement)cosE.multiply((Object)vz)).multiply((Object)sqrtAoMu));
        RealFieldElement s2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)cosE.negate()).multiply((Object)pz)).divide((Object)r3);
        RealFieldElement s3 = (RealFieldElement)((RealFieldElement)sinE.multiply((Object)vz)).divide(sqrtMuA.multiply(-2));
        RealFieldElement t1 = (RealFieldElement)sqrtRec.multiply(((RealFieldElement)((RealFieldElement)cosE.multiply((Object)pz)).divide((Object)r)).subtract(((RealFieldElement)sinE.multiply((Object)vz)).multiply((Object)sqrtAoMu)));
        RealFieldElement t2 = (RealFieldElement)sqrtRec.multiply(((RealFieldElement)((RealFieldElement)sinE.negate()).multiply((Object)pz)).divide((Object)r3));
        RealFieldElement t3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)sqrtRec.multiply(cosE.subtract(this.e))).multiply((Object)vz)).divide(sqrtMuA.multiply(2));
        RealFieldElement t4 = (RealFieldElement)sqrtRec.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply((Object)sinI)).multiply((Object)cosPA)).multiply((Object)sqrtRec)).subtract(vz.multiply((Object)sqrtAoMu)));
        FieldVector3D s = new FieldVector3D((RealFieldElement)cosE.divide((Object)r), this.PLUS_K, s1, vectorEAnR, s2, position, s3, vectorAR);
        FieldVector3D sDot = new FieldVector3D((RealFieldElement)((RealFieldElement)sinE.negate()).multiply((Object)sqrtAoMu), this.PLUS_K, s1, vectorEAnRDot, s3, vectorARDot);
        FieldVector3D t = new FieldVector3D((RealFieldElement)((RealFieldElement)sqrtRec.multiply((Object)sinE)).divide((Object)r), this.PLUS_K).add(new FieldVector3D(t1, vectorEAnR, t2, position, t3, vectorAR, t4, vectorER));
        FieldVector3D tDot = new FieldVector3D((RealFieldElement)((RealFieldElement)sqrtRec.multiply(cosE.subtract(this.e))).multiply((Object)sqrtAoMu), this.PLUS_K, t1, vectorEAnRDot, t3, vectorARDot, t4, vectorERDot);
        RealFieldElement i1 = factorI1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)sinI.negate()).multiply((Object)sqrtRec)).divide((Object)sqrtMuA);
        RealFieldElement i2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)factorI1.negate()).multiply((Object)mz)).divide((Object)twoA);
        RealFieldElement i3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)factorI1.multiply((Object)mz)).multiply(this.e)).divide((Object)oMe2);
        RealFieldElement i4 = (RealFieldElement)cosI.multiply((Object)sinPA);
        RealFieldElement i5 = (RealFieldElement)cosI.multiply((Object)cosPA);
        this.fillHalfRow(i1, new FieldVector3D(vy, (RealFieldElement)vx.negate(), this.zero), i2, vectorAR, i3, vectorER, i4, s, i5, t, jacobian[2], 0);
        this.fillHalfRow(i1, new FieldVector3D((RealFieldElement)py.negate(), px, this.zero), i2, vectorARDot, i3, vectorERDot, i4, sDot, i5, tDot, jacobian[2], 3);
        this.fillHalfRow((RealFieldElement)cosPA.divide((Object)sinI), s, (RealFieldElement)((RealFieldElement)sinPA.negate()).divide((Object)sinI), t, jacobian[3], 0);
        this.fillHalfRow((RealFieldElement)cosPA.divide((Object)sinI), sDot, (RealFieldElement)((RealFieldElement)sinPA.negate()).divide((Object)sinI), tDot, jacobian[3], 3);
        RealFieldElement factorRaanR = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.a.multiply(mu)).multiply((Object)oMe2)).multiply((Object)sinI)).multiply((Object)sinI)).reciprocal();
        this.fillHalfRow((RealFieldElement)((RealFieldElement)factorRaanR.negate()).multiply((Object)my), new FieldVector3D(this.zero, vz, (RealFieldElement)vy.negate()), (RealFieldElement)factorRaanR.multiply((Object)mx), new FieldVector3D((RealFieldElement)vz.negate(), this.zero, vx), jacobian[4], 0);
        this.fillHalfRow((RealFieldElement)((RealFieldElement)factorRaanR.negate()).multiply((Object)my), new FieldVector3D(this.zero, (RealFieldElement)pz.negate(), py), (RealFieldElement)factorRaanR.multiply((Object)mx), new FieldVector3D(pz, this.zero, (RealFieldElement)px.negate()), jacobian[4], 3);
        this.fillHalfRow(rOnA, vectorEAnR, (RealFieldElement)sinE.negate(), vectorER, jacobian[5], 0);
        this.fillHalfRow(rOnA, vectorEAnRDot, (RealFieldElement)sinE.negate(), vectorERDot, jacobian[5], 3);
        return jacobian;
    }

    private T[][] computeJacobianMeanWrtCartesianHyperbolic() {
        RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray((Field)this.getA().getField(), (int)6, (int)6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        FieldVector3D<T> momentum = this.partialPV.getMomentum();
        RealFieldElement r2 = position.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement r3 = (RealFieldElement)r.multiply((Object)r2);
        RealFieldElement x = position.getX();
        RealFieldElement y = position.getY();
        RealFieldElement z = position.getZ();
        RealFieldElement vx = velocity.getX();
        RealFieldElement vy = velocity.getY();
        RealFieldElement vz = velocity.getZ();
        RealFieldElement mx = momentum.getX();
        RealFieldElement my = momentum.getY();
        RealFieldElement mz = momentum.getZ();
        double mu = this.getMu();
        RealFieldElement absA = (RealFieldElement)this.a.negate();
        RealFieldElement sqrtMuA = (RealFieldElement)((RealFieldElement)absA.multiply(mu)).sqrt();
        RealFieldElement a2 = (RealFieldElement)this.a.multiply(this.a);
        RealFieldElement rOa = (RealFieldElement)r.divide((Object)absA);
        RealFieldElement cosI = (RealFieldElement)this.i.cos();
        RealFieldElement sinI = (RealFieldElement)this.i.sin();
        RealFieldElement pv = FieldVector3D.dotProduct(position, velocity);
        FieldVector3D vectorAR = new FieldVector3D((RealFieldElement)((RealFieldElement)a2.multiply(-2)).divide((Object)r3), position);
        FieldVector3D vectorARDot = velocity.scalarMultiply((RealFieldElement)a2.multiply(-2.0 / mu));
        this.fillHalfRow((RealFieldElement)this.one.negate(), vectorAR, jacobian[0], 0);
        this.fillHalfRow((RealFieldElement)this.one.negate(), vectorARDot, jacobian[0], 3);
        RealFieldElement m = momentum.getNorm();
        RealFieldElement oOm = (RealFieldElement)m.reciprocal();
        FieldVector3D dcXP = new FieldVector3D(this.zero, vz, (RealFieldElement)vy.negate());
        FieldVector3D dcYP = new FieldVector3D((RealFieldElement)vz.negate(), this.zero, vx);
        FieldVector3D dcZP = new FieldVector3D(vy, (RealFieldElement)vx.negate(), this.zero);
        FieldVector3D dcXV = new FieldVector3D(this.zero, (RealFieldElement)z.negate(), y);
        FieldVector3D dcYV = new FieldVector3D(z, this.zero, (RealFieldElement)x.negate());
        FieldVector3D dcZV = new FieldVector3D((RealFieldElement)y.negate(), x, this.zero);
        FieldVector3D dCP = new FieldVector3D((RealFieldElement)mx.multiply((Object)oOm), dcXP, (RealFieldElement)my.multiply((Object)oOm), dcYP, (RealFieldElement)mz.multiply((Object)oOm), dcZP);
        FieldVector3D dCV = new FieldVector3D((RealFieldElement)mx.multiply((Object)oOm), dcXV, (RealFieldElement)my.multiply((Object)oOm), dcYV, (RealFieldElement)mz.multiply((Object)oOm), dcZV);
        RealFieldElement mOMu = (RealFieldElement)m.divide(mu);
        FieldVector3D dpP = new FieldVector3D((RealFieldElement)mOMu.multiply(2), dCP);
        FieldVector3D dpV = new FieldVector3D((RealFieldElement)mOMu.multiply(2), dCV);
        RealFieldElement p = (RealFieldElement)m.multiply((Object)mOMu);
        RealFieldElement moO2ae = (RealFieldElement)((RealFieldElement)((RealFieldElement)absA.multiply(2)).multiply(this.e)).reciprocal();
        RealFieldElement m2OaMu = (RealFieldElement)((RealFieldElement)p.negate()).divide((Object)absA);
        this.fillHalfRow(moO2ae, dpP, (RealFieldElement)m2OaMu.multiply((Object)moO2ae), vectorAR, jacobian[1], 0);
        this.fillHalfRow(moO2ae, dpV, (RealFieldElement)m2OaMu.multiply((Object)moO2ae), vectorARDot, jacobian[1], 3);
        RealFieldElement cI1 = (RealFieldElement)((RealFieldElement)m.multiply((Object)sinI)).reciprocal();
        RealFieldElement cI2 = (RealFieldElement)cosI.multiply((Object)cI1);
        this.fillHalfRow(cI2, dCP, (RealFieldElement)cI1.negate(), dcZP, jacobian[2], 0);
        this.fillHalfRow(cI2, dCV, (RealFieldElement)cI1.negate(), dcZV, jacobian[2], 3);
        RealFieldElement cP1 = (RealFieldElement)y.multiply((Object)oOm);
        RealFieldElement cP2 = (RealFieldElement)((RealFieldElement)x.negate()).multiply((Object)oOm);
        RealFieldElement cP3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)mx.multiply((Object)cP1)).add(my.multiply((Object)cP2))).negate();
        RealFieldElement cP4 = (RealFieldElement)cP3.multiply((Object)oOm);
        RealFieldElement cP5 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)r2.multiply((Object)sinI)).multiply((Object)sinI)).negate()).reciprocal();
        RealFieldElement cP6 = (RealFieldElement)z.multiply((Object)cP5);
        RealFieldElement cP7 = (RealFieldElement)cP3.multiply((Object)cP5);
        FieldVector3D dacP = new FieldVector3D(cP1, dcXP, cP2, dcYP, cP4, dCP, oOm, new FieldVector3D((RealFieldElement)my.negate(), mx, this.zero));
        FieldVector3D dacV = new FieldVector3D(cP1, dcXV, cP2, dcYV, cP4, dCV);
        FieldVector3D dpoP = new FieldVector3D(cP6, dacP, cP7, this.PLUS_K);
        FieldVector3D dpoV = new FieldVector3D(cP6, dacV);
        RealFieldElement re2 = (RealFieldElement)((RealFieldElement)r2.multiply(this.e)).multiply(this.e);
        RealFieldElement recOre2 = (RealFieldElement)((RealFieldElement)p.subtract((Object)r)).divide((Object)re2);
        RealFieldElement resOre2 = (RealFieldElement)((RealFieldElement)pv.multiply((Object)mOMu)).divide((Object)re2);
        FieldVector3D dreP = new FieldVector3D(mOMu, velocity, (RealFieldElement)pv.divide(mu), dCP);
        FieldVector3D dreV = new FieldVector3D(mOMu, position, (RealFieldElement)pv.divide(mu), dCV);
        FieldVector3D davP = new FieldVector3D((RealFieldElement)resOre2.negate(), dpP, recOre2, dreP, (RealFieldElement)resOre2.divide((Object)r), position);
        FieldVector3D davV = new FieldVector3D((RealFieldElement)resOre2.negate(), dpV, recOre2, dreV);
        this.fillHalfRow((RealFieldElement)this.one, dpoP, (RealFieldElement)this.one.negate(), davP, jacobian[3], 0);
        this.fillHalfRow((RealFieldElement)this.one, dpoV, (RealFieldElement)this.one.negate(), davV, jacobian[3], 3);
        RealFieldElement cO0 = (RealFieldElement)cI1.multiply((Object)cI1);
        RealFieldElement cO1 = (RealFieldElement)mx.multiply((Object)cO0);
        RealFieldElement cO2 = (RealFieldElement)((RealFieldElement)my.negate()).multiply((Object)cO0);
        this.fillHalfRow(cO1, dcYP, cO2, dcXP, jacobian[4], 0);
        this.fillHalfRow(cO1, dcYV, cO2, dcXV, jacobian[4], 3);
        RealFieldElement s2a = (RealFieldElement)pv.divide(absA.multiply(2));
        RealFieldElement oObux = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)m.multiply((Object)m)).add(absA.multiply(mu))).sqrt()).reciprocal();
        RealFieldElement scasbu = (RealFieldElement)pv.multiply((Object)oObux);
        FieldVector3D dauP = new FieldVector3D((RealFieldElement)sqrtMuA.reciprocal(), velocity, (RealFieldElement)((RealFieldElement)s2a.negate()).divide((Object)sqrtMuA), vectorAR);
        FieldVector3D dauV = new FieldVector3D((RealFieldElement)sqrtMuA.reciprocal(), position, (RealFieldElement)((RealFieldElement)s2a.negate()).divide((Object)sqrtMuA), vectorARDot);
        FieldVector3D dbuP = new FieldVector3D((RealFieldElement)oObux.multiply(mu / 2.0), vectorAR, (RealFieldElement)m.multiply((Object)oObux), dCP);
        FieldVector3D dbuV = new FieldVector3D((RealFieldElement)oObux.multiply(mu / 2.0), vectorARDot, (RealFieldElement)m.multiply((Object)oObux), dCV);
        FieldVector3D dcuP = new FieldVector3D(oObux, velocity, (RealFieldElement)((RealFieldElement)scasbu.negate()).multiply((Object)oObux), dbuP);
        FieldVector3D dcuV = new FieldVector3D(oObux, position, (RealFieldElement)((RealFieldElement)scasbu.negate()).multiply((Object)oObux), dbuV);
        this.fillHalfRow((RealFieldElement)this.one, dauP, (RealFieldElement)((RealFieldElement)this.e.negate()).divide(rOa.add(1.0)), dcuP, jacobian[5], 0);
        this.fillHalfRow((RealFieldElement)this.one, dauV, (RealFieldElement)((RealFieldElement)this.e.negate()).divide(rOa.add(1.0)), dcuV, jacobian[5], 3);
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        if (this.a.getReal() > 0.0) {
            return this.computeJacobianEccentricWrtCartesianElliptical();
        }
        return this.computeJacobianEccentricWrtCartesianHyperbolic();
    }

    private T[][] computeJacobianEccentricWrtCartesianElliptical() {
        RealFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesianElliptical();
        T eccentricAnomaly = this.getEccentricAnomaly();
        RealFieldElement cosE = (RealFieldElement)eccentricAnomaly.cos();
        RealFieldElement sinE = (RealFieldElement)eccentricAnomaly.sin();
        RealFieldElement aOr = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.negate()).multiply((Object)cosE)).add(1.0)).reciprocal();
        RealFieldElement[] eRow = jacobian[1];
        RealFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = (RealFieldElement)aOr.multiply(anomalyRow[j].add(sinE.multiply((Object)eRow[j])));
        }
        return jacobian;
    }

    private T[][] computeJacobianEccentricWrtCartesianHyperbolic() {
        RealFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesianHyperbolic();
        T H = this.getEccentricAnomaly();
        RealFieldElement coshH = (RealFieldElement)H.cosh();
        RealFieldElement sinhH = (RealFieldElement)H.sinh();
        RealFieldElement absaOr = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply((Object)coshH)).subtract(1.0)).reciprocal();
        RealFieldElement[] eRow = jacobian[1];
        RealFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = (RealFieldElement)absaOr.multiply(anomalyRow[j].subtract(sinhH.multiply((Object)eRow[j])));
        }
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        if (this.a.getReal() > 0.0) {
            return this.computeJacobianTrueWrtCartesianElliptical();
        }
        return this.computeJacobianTrueWrtCartesianHyperbolic();
    }

    private T[][] computeJacobianTrueWrtCartesianElliptical() {
        RealFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesianElliptical();
        RealFieldElement e2 = (RealFieldElement)this.e.multiply(this.e);
        RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)e2.negate()).add(1.0);
        RealFieldElement epsilon = (RealFieldElement)oMe2.sqrt();
        T eccentricAnomaly = this.getEccentricAnomaly();
        RealFieldElement cosE = (RealFieldElement)eccentricAnomaly.cos();
        RealFieldElement sinE = (RealFieldElement)eccentricAnomaly.sin();
        RealFieldElement aOr = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply((Object)cosE)).negate()).add(1.0)).reciprocal();
        RealFieldElement aFactor = (RealFieldElement)epsilon.multiply((Object)aOr);
        RealFieldElement eFactor = (RealFieldElement)((RealFieldElement)sinE.multiply((Object)aOr)).divide((Object)epsilon);
        RealFieldElement[] eRow = jacobian[1];
        RealFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = (RealFieldElement)((RealFieldElement)aFactor.multiply((Object)anomalyRow[j])).add(eFactor.multiply((Object)eRow[j]));
        }
        return jacobian;
    }

    private T[][] computeJacobianTrueWrtCartesianHyperbolic() {
        RealFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesianHyperbolic();
        RealFieldElement e2 = (RealFieldElement)this.e.multiply(this.e);
        RealFieldElement e2Mo = (RealFieldElement)e2.subtract(1.0);
        RealFieldElement epsilon = (RealFieldElement)e2Mo.sqrt();
        T H = this.getEccentricAnomaly();
        RealFieldElement coshH = (RealFieldElement)H.cosh();
        RealFieldElement sinhH = (RealFieldElement)H.sinh();
        RealFieldElement aOr = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply((Object)coshH)).subtract(1.0)).reciprocal();
        RealFieldElement aFactor = (RealFieldElement)epsilon.multiply((Object)aOr);
        RealFieldElement eFactor = (RealFieldElement)((RealFieldElement)sinhH.multiply((Object)aOr)).divide((Object)epsilon);
        RealFieldElement[] eRow = jacobian[1];
        RealFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = (RealFieldElement)((RealFieldElement)aFactor.multiply((Object)anomalyRow[j])).subtract(eFactor.multiply((Object)eRow[j]));
        }
        return jacobian;
    }

    @Override
    public void addKeplerContribution(PositionAngle type, double gm, T[] pDot) {
        RealFieldElement absA = (RealFieldElement)this.a.abs();
        RealFieldElement n = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)absA.reciprocal()).multiply(gm)).sqrt()).divide((Object)absA);
        switch (type) {
            case MEAN: {
                pDot[5] = (RealFieldElement)pDot[5].add((Object)n);
                break;
            }
            case ECCENTRIC: {
                RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply(this.e)).negate()).add(1.0)).abs();
                RealFieldElement ksi = (RealFieldElement)((RealFieldElement)this.e.multiply(this.v.cos())).add(1.0);
                pDot[5] = (RealFieldElement)pDot[5].add(((RealFieldElement)n.multiply((Object)ksi)).divide((Object)oMe2));
                break;
            }
            case TRUE: {
                RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.e.multiply(this.e)).negate()).add(1.0)).abs();
                RealFieldElement ksi = (RealFieldElement)((RealFieldElement)this.e.multiply(this.v.cos())).add(1.0);
                pDot[5] = (RealFieldElement)pDot[5].add(((RealFieldElement)((RealFieldElement)n.multiply((Object)ksi)).multiply((Object)ksi)).divide(oMe2.multiply(oMe2.sqrt())));
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
    }

    public String toString() {
        return new StringBuffer().append("Keplerian parameters: ").append('{').append("a: ").append(this.a.getReal()).append("; e: ").append(this.e.getReal()).append("; i: ").append(FastMath.toDegrees((double)this.i.getReal())).append("; pa: ").append(FastMath.toDegrees((double)this.pa.getReal())).append("; raan: ").append(FastMath.toDegrees((double)this.raan.getReal())).append("; v: ").append(FastMath.toDegrees((double)this.v.getReal())).append(";}").toString();
    }

    public static <T extends RealFieldElement<T>> T normalizeAngle(T a, T center) {
        return (T)((RealFieldElement)a.subtract(Math.PI * 2 * FastMath.floor((double)((a.getReal() + Math.PI - center.getReal()) / (Math.PI * 2)))));
    }

    @Override
    public KeplerianOrbit toOrbit() {
        if (this.hasDerivatives()) {
            return new KeplerianOrbit(this.a.getReal(), this.e.getReal(), this.i.getReal(), this.pa.getReal(), this.raan.getReal(), this.v.getReal(), this.aDot.getReal(), this.eDot.getReal(), this.iDot.getReal(), this.paDot.getReal(), this.raanDot.getReal(), this.vDot.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu());
        }
        return new KeplerianOrbit(this.a.getReal(), this.e.getReal(), this.i.getReal(), this.pa.getReal(), this.raan.getReal(), this.v.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu());
    }

    static {
        double k1 = 11.42477796076938;
        double k2 = 2.141592653589793;
        double k3 = 17.84955592153876;
        A = 1.2043347651023166;
        B = 4.64788969626918;
    }
}

