/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.TurnAroundRange;
import org.orekit.models.earth.TroposphericModel;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;
import org.orekit.utils.StateFunction;

public class TurnAroundRangeTroposphericDelayModifier
implements EstimationModifier<TurnAroundRange> {
    private final TroposphericModel tropoModel;

    public TurnAroundRangeTroposphericDelayModifier(TroposphericModel model) {
        this.tropoModel = model;
    }

    private double getStationHeightAMSL(GroundStation station) {
        double height = station.getBaseFrame().getPoint().getAltitude();
        return height;
    }

    private double rangeErrorTroposphericModel(GroundStation station, SpacecraftState state) throws OrekitException {
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation > 0.0) {
            double height = this.getStationHeightAMSL(station);
            double delay = this.tropoModel.pathDelay(elevation, height);
            return delay;
        }
        return 0.0;
    }

    private double[][] rangeErrorJacobianState(final GroundStation station, SpacecraftState refstate) throws OrekitException {
        double[][] finiteDifferencesJacobian = Differentiation.differentiate(new StateFunction(){

            @Override
            public double[] value(SpacecraftState state) throws OrekitException {
                try {
                    double value = TurnAroundRangeTroposphericDelayModifier.this.rangeErrorTroposphericModel(station, state);
                    return new double[]{value};
                }
                catch (OrekitException oe) {
                    throw new OrekitExceptionWrapper(oe);
                }
            }
        }, 1, Propagator.DEFAULT_LAW, OrbitType.CARTESIAN, PositionAngle.TRUE, 15.0, 3).value(refstate);
        return finiteDifferencesJacobian;
    }

    private double rangeErrorParameterDerivative(final GroundStation station, ParameterDriver driver, final SpacecraftState state) throws OrekitException {
        ParameterFunction rangeError = new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver) throws OrekitException {
                return TurnAroundRangeTroposphericDelayModifier.this.rangeErrorTroposphericModel(station, state);
            }
        };
        ParameterFunction rangeErrorDerivative = Differentiation.differentiate(rangeError, driver, 3, 10.0);
        return rangeErrorDerivative.value(driver);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<TurnAroundRange> estimated) throws OrekitException {
        double parameterDerivative;
        TurnAroundRange measurement = estimated.getObservedMeasurement();
        GroundStation masterStation = measurement.getMasterStation();
        GroundStation slaveStation = measurement.getSlaveStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        double masterDelay = this.rangeErrorTroposphericModel(masterStation, state);
        double slaveDelay = this.rangeErrorTroposphericModel(slaveStation, state);
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + masterDelay + slaveDelay;
        estimated.setEstimatedValue(newValue);
        double[][] masterDjac = this.rangeErrorJacobianState(masterStation, state);
        double[][] slaveDjac = this.rangeErrorJacobianState(slaveStation, state);
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                stateDerivatives[irow][jcol] = stateDerivatives[irow][jcol] + masterDjac[irow][jcol] + slaveDjac[irow][jcol];
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        for (ParameterDriver driver : Arrays.asList(masterStation.getEastOffsetDriver(), masterStation.getNorthOffsetDriver(), masterStation.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeErrorParameterDerivative(masterStation, driver, state));
        }
        for (ParameterDriver driver : Arrays.asList(slaveStation.getEastOffsetDriver(), slaveStation.getNorthOffsetDriver(), slaveStation.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeErrorParameterDerivative(slaveStation, driver, state));
        }
    }
}

