/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class PV
extends AbstractMeasurement<PV> {
    private static final double[][] IDENTITY = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};

    public PV(AbsoluteDate date, Vector3D position, Vector3D velocity, double sigmaPosition, double sigmaVelocity, double baseWeight) {
        this(date, position, velocity, sigmaPosition, sigmaVelocity, baseWeight, 0);
    }

    public PV(AbsoluteDate date, Vector3D position, Vector3D velocity, double sigmaPosition, double sigmaVelocity, double baseWeight, int propagatorIndex) {
        super(date, new double[]{position.getX(), position.getY(), position.getZ(), velocity.getX(), velocity.getY(), velocity.getZ()}, new double[]{sigmaPosition, sigmaPosition, sigmaPosition, sigmaVelocity, sigmaVelocity, sigmaVelocity}, new double[]{baseWeight, baseWeight, baseWeight, baseWeight, baseWeight, baseWeight}, Arrays.asList(propagatorIndex), new ParameterDriver[0]);
    }

    public Vector3D getPosition() {
        double[] pv = this.getObservedValue();
        return new Vector3D(pv[0], pv[1], pv[2]);
    }

    public Vector3D getVelocity() {
        double[] pv = this.getObservedValue();
        return new Vector3D(pv[3], pv[4], pv[5]);
    }

    @Override
    protected EstimatedMeasurement<PV> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) throws OrekitException {
        TimeStampedPVCoordinates pv = states[this.getPropagatorsIndices().get(0)].getPVCoordinates();
        EstimatedMeasurement<PV> estimated = new EstimatedMeasurement<PV>(this, iteration, evaluation, states, new TimeStampedPVCoordinates[]{pv});
        estimated.setEstimatedValue(pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ(), pv.getVelocity().getX(), pv.getVelocity().getY(), pv.getVelocity().getZ());
        estimated.setStateDerivatives(0, IDENTITY);
        return estimated;
    }
}

