/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.distribution.continuous.NormalDistribution;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.ranking.NaNStrategy;
import org.hipparchus.stat.ranking.NaturalRanking;
import org.hipparchus.stat.ranking.TiesStrategy;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class WilcoxonSignedRankTest {
    private NaturalRanking naturalRanking;

    public WilcoxonSignedRankTest() {
        this.naturalRanking = new NaturalRanking(NaNStrategy.FIXED, TiesStrategy.AVERAGE);
    }

    public WilcoxonSignedRankTest(NaNStrategy nanStrategy, TiesStrategy tiesStrategy) {
        this.naturalRanking = new NaturalRanking(nanStrategy, tiesStrategy);
    }

    private void ensureDataConformance(double[] x, double[] y) throws MathIllegalArgumentException, NullArgumentException {
        if (x == null || y == null) {
            throw new NullArgumentException();
        }
        if (x.length == 0 || y.length == 0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NO_DATA, new Object[0]);
        }
        MathArrays.checkEqualLength((double[])y, (double[])x);
    }

    private double[] calculateDifferences(double[] x, double[] y) {
        double[] z = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            z[i] = y[i] - x[i];
        }
        return z;
    }

    private double[] calculateAbsoluteDifferences(double[] z) throws MathIllegalArgumentException, NullArgumentException {
        if (z == null) {
            throw new NullArgumentException();
        }
        if (z.length == 0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NO_DATA, new Object[0]);
        }
        double[] zAbs = new double[z.length];
        for (int i = 0; i < z.length; ++i) {
            zAbs[i] = FastMath.abs((double)z[i]);
        }
        return zAbs;
    }

    public double wilcoxonSignedRank(double[] x, double[] y) throws MathIllegalArgumentException, NullArgumentException {
        this.ensureDataConformance(x, y);
        double[] z = this.calculateDifferences(x, y);
        double[] zAbs = this.calculateAbsoluteDifferences(z);
        double[] ranks = this.naturalRanking.rank(zAbs);
        double Wplus = 0.0;
        for (int i = 0; i < z.length; ++i) {
            if (!(z[i] > 0.0)) continue;
            Wplus += ranks[i];
        }
        int N = x.length;
        double Wminus = (double)(N * (N + 1)) / 2.0 - Wplus;
        return FastMath.max((double)Wplus, (double)Wminus);
    }

    private double calculateExactPValue(double Wmax, int N) {
        int m = 1 << N;
        int largerRankSums = 0;
        for (int i = 0; i < m; ++i) {
            int rankSum = 0;
            for (int j = 0; j < N; ++j) {
                if ((i >> j & 1) != 1) continue;
                rankSum += j + 1;
            }
            if (!((double)rankSum >= Wmax)) continue;
            ++largerRankSums;
        }
        return 2.0 * (double)largerRankSums / (double)m;
    }

    private double calculateAsymptoticPValue(double Wmin, int N) {
        double ES = (double)(N * (N + 1)) / 4.0;
        double VarS = ES * ((double)(2 * N + 1) / 6.0);
        double z = (Wmin - ES - 0.5) / FastMath.sqrt((double)VarS);
        NormalDistribution standardNormal = new NormalDistribution(0.0, 1.0);
        return 2.0 * standardNormal.cumulativeProbability(z);
    }

    public double wilcoxonSignedRankTest(double[] x, double[] y, boolean exactPValue) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.ensureDataConformance(x, y);
        int N = x.length;
        double Wmax = this.wilcoxonSignedRank(x, y);
        if (exactPValue && N > 30) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{N, 30});
        }
        if (exactPValue) {
            return this.calculateExactPValue(Wmax, N);
        }
        double Wmin = (double)(N * (N + 1)) / 2.0 - Wmax;
        return this.calculateAsymptoticPValue(Wmin, N);
    }
}

