/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.distribution.continuous.TDistribution;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.descriptive.StatisticalSummary;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class TTest {
    public double pairedT(double[] sample1, double[] sample2) throws MathIllegalArgumentException, NullArgumentException {
        this.checkSampleData(sample1);
        this.checkSampleData(sample2);
        double meanDifference = StatUtils.meanDifference(sample1, sample2);
        return this.t(meanDifference, 0.0, StatUtils.varianceDifference(sample1, sample2, meanDifference), sample1.length);
    }

    public double pairedTTest(double[] sample1, double[] sample2) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        double meanDifference = StatUtils.meanDifference(sample1, sample2);
        return this.tTest(meanDifference, 0.0, StatUtils.varianceDifference(sample1, sample2, meanDifference), sample1.length);
    }

    public boolean pairedTTest(double[] sample1, double[] sample2, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkSignificanceLevel(alpha);
        return this.pairedTTest(sample1, sample2) < alpha;
    }

    public double t(double mu, double[] observed) throws MathIllegalArgumentException, NullArgumentException {
        this.checkSampleData(observed);
        return this.t(StatUtils.mean(observed), mu, StatUtils.variance(observed), observed.length);
    }

    public double t(double mu, StatisticalSummary sampleStats) throws MathIllegalArgumentException, NullArgumentException {
        this.checkSampleData(sampleStats);
        return this.t(sampleStats.getMean(), mu, sampleStats.getVariance(), sampleStats.getN());
    }

    public double homoscedasticT(double[] sample1, double[] sample2) throws MathIllegalArgumentException, NullArgumentException {
        this.checkSampleData(sample1);
        this.checkSampleData(sample2);
        return this.homoscedasticT(StatUtils.mean(sample1), StatUtils.mean(sample2), StatUtils.variance(sample1), StatUtils.variance(sample2), sample1.length, sample2.length);
    }

    public double t(double[] sample1, double[] sample2) throws MathIllegalArgumentException, NullArgumentException {
        this.checkSampleData(sample1);
        this.checkSampleData(sample2);
        return this.t(StatUtils.mean(sample1), StatUtils.mean(sample2), StatUtils.variance(sample1), StatUtils.variance(sample2), sample1.length, sample2.length);
    }

    public double t(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws MathIllegalArgumentException, NullArgumentException {
        this.checkSampleData(sampleStats1);
        this.checkSampleData(sampleStats2);
        return this.t(sampleStats1.getMean(), sampleStats2.getMean(), sampleStats1.getVariance(), sampleStats2.getVariance(), sampleStats1.getN(), sampleStats2.getN());
    }

    public double homoscedasticT(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws MathIllegalArgumentException, NullArgumentException {
        this.checkSampleData(sampleStats1);
        this.checkSampleData(sampleStats2);
        return this.homoscedasticT(sampleStats1.getMean(), sampleStats2.getMean(), sampleStats1.getVariance(), sampleStats2.getVariance(), sampleStats1.getN(), sampleStats2.getN());
    }

    public double tTest(double mu, double[] sample) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkSampleData(sample);
        return this.tTest(StatUtils.mean(sample), mu, StatUtils.variance(sample), sample.length);
    }

    public boolean tTest(double mu, double[] sample, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkSignificanceLevel(alpha);
        return this.tTest(mu, sample) < alpha;
    }

    public double tTest(double mu, StatisticalSummary sampleStats) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkSampleData(sampleStats);
        return this.tTest(sampleStats.getMean(), mu, sampleStats.getVariance(), sampleStats.getN());
    }

    public boolean tTest(double mu, StatisticalSummary sampleStats, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkSignificanceLevel(alpha);
        return this.tTest(mu, sampleStats) < alpha;
    }

    public double tTest(double[] sample1, double[] sample2) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkSampleData(sample1);
        this.checkSampleData(sample2);
        return this.tTest(StatUtils.mean(sample1), StatUtils.mean(sample2), StatUtils.variance(sample1), StatUtils.variance(sample2), sample1.length, sample2.length);
    }

    public double homoscedasticTTest(double[] sample1, double[] sample2) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkSampleData(sample1);
        this.checkSampleData(sample2);
        return this.homoscedasticTTest(StatUtils.mean(sample1), StatUtils.mean(sample2), StatUtils.variance(sample1), StatUtils.variance(sample2), sample1.length, sample2.length);
    }

    public boolean tTest(double[] sample1, double[] sample2, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkSignificanceLevel(alpha);
        return this.tTest(sample1, sample2) < alpha;
    }

    public boolean homoscedasticTTest(double[] sample1, double[] sample2, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkSignificanceLevel(alpha);
        return this.homoscedasticTTest(sample1, sample2) < alpha;
    }

    public double tTest(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkSampleData(sampleStats1);
        this.checkSampleData(sampleStats2);
        return this.tTest(sampleStats1.getMean(), sampleStats2.getMean(), sampleStats1.getVariance(), sampleStats2.getVariance(), sampleStats1.getN(), sampleStats2.getN());
    }

    public double homoscedasticTTest(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkSampleData(sampleStats1);
        this.checkSampleData(sampleStats2);
        return this.homoscedasticTTest(sampleStats1.getMean(), sampleStats2.getMean(), sampleStats1.getVariance(), sampleStats2.getVariance(), sampleStats1.getN(), sampleStats2.getN());
    }

    public boolean tTest(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkSignificanceLevel(alpha);
        return this.tTest(sampleStats1, sampleStats2) < alpha;
    }

    protected double df(double v1, double v2, double n1, double n2) {
        return (v1 / n1 + v2 / n2) * (v1 / n1 + v2 / n2) / (v1 * v1 / (n1 * n1 * (n1 - 1.0)) + v2 * v2 / (n2 * n2 * (n2 - 1.0)));
    }

    protected double t(double m, double mu, double v, double n) {
        return (m - mu) / FastMath.sqrt((double)(v / n));
    }

    protected double t(double m1, double m2, double v1, double v2, double n1, double n2) {
        return (m1 - m2) / FastMath.sqrt((double)(v1 / n1 + v2 / n2));
    }

    protected double homoscedasticT(double m1, double m2, double v1, double v2, double n1, double n2) {
        double pooledVariance = ((n1 - 1.0) * v1 + (n2 - 1.0) * v2) / (n1 + n2 - 2.0);
        return (m1 - m2) / FastMath.sqrt((double)(pooledVariance * (1.0 / n1 + 1.0 / n2)));
    }

    protected double tTest(double m, double mu, double v, double n) throws MathIllegalArgumentException, MathIllegalStateException {
        double t = FastMath.abs((double)this.t(m, mu, v, n));
        TDistribution distribution = new TDistribution(n - 1.0);
        return 2.0 * distribution.cumulativeProbability(-t);
    }

    protected double tTest(double m1, double m2, double v1, double v2, double n1, double n2) throws MathIllegalArgumentException, MathIllegalStateException {
        double t = FastMath.abs((double)this.t(m1, m2, v1, v2, n1, n2));
        double degreesOfFreedom = this.df(v1, v2, n1, n2);
        TDistribution distribution = new TDistribution(degreesOfFreedom);
        return 2.0 * distribution.cumulativeProbability(-t);
    }

    protected double homoscedasticTTest(double m1, double m2, double v1, double v2, double n1, double n2) throws MathIllegalArgumentException, MathIllegalStateException {
        double t = FastMath.abs((double)this.homoscedasticT(m1, m2, v1, v2, n1, n2));
        double degreesOfFreedom = n1 + n2 - 2.0;
        TDistribution distribution = new TDistribution(degreesOfFreedom);
        return 2.0 * distribution.cumulativeProbability(-t);
    }

    private void checkSignificanceLevel(double alpha) throws MathIllegalArgumentException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.SIGNIFICANCE_LEVEL, new Object[]{alpha, 0.0, 0.5});
        }
    }

    private void checkSampleData(double[] data) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull((Object)data, (Localizable)LocalizedCoreFormats.INPUT_ARRAY, (Object[])new Object[0]);
        if (data.length < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INSUFFICIENT_DATA_FOR_T_STATISTIC, new Object[]{data.length, 2, true});
        }
    }

    private void checkSampleData(StatisticalSummary stat) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull((Object)stat);
        if (stat.getN() < 2L) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INSUFFICIENT_DATA_FOR_T_STATISTIC, new Object[]{stat.getN(), 2, true});
        }
    }
}

