/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;

public class ParameterDriversList {
    private final List<DelegatingDriver> delegating = new ArrayList<DelegatingDriver>();

    public void add(ParameterDriver driver) throws OrekitException {
        for (DelegatingDriver d : this.delegating) {
            if (!d.getName().equals(driver.getName())) continue;
            for (ParameterDriver existing : d.drivers) {
                if (existing != driver) continue;
                return;
            }
            d.add(driver);
            return;
        }
        this.delegating.add(new DelegatingDriver(driver));
    }

    public void sort() {
        Collections.sort(this.delegating, new Comparator<DelegatingDriver>(){

            @Override
            public int compare(DelegatingDriver d1, DelegatingDriver d2) {
                return d1.getName().compareTo(d2.getName());
            }
        });
    }

    public void filter(boolean selected) {
        Iterator<DelegatingDriver> iterator = this.delegating.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isSelected() == selected) continue;
            iterator.remove();
        }
    }

    public int getNbParams() {
        return this.delegating.size();
    }

    public List<DelegatingDriver> getDrivers() {
        return Collections.unmodifiableList(this.delegating);
    }

    @FunctionalInterface
    private static interface Updater {
        public void update(ParameterDriver var1);
    }

    public static class DelegatingDriver
    extends ParameterDriver {
        private final List<ParameterDriver> drivers = new ArrayList<ParameterDriver>();
        private final ChangesForwarder forwarder;

        DelegatingDriver(ParameterDriver driver) throws OrekitException {
            super(driver.getName(), driver.getReferenceValue(), driver.getScale(), driver.getMinValue(), driver.getMaxValue());
            this.drivers.add(driver);
            this.setValue(driver.getValue());
            this.setReferenceDate(driver.getReferenceDate());
            this.setSelected(driver.isSelected());
            this.forwarder = new ChangesForwarder();
            this.addObserver(this.forwarder);
            driver.addObserver(this.forwarder);
        }

        private void add(ParameterDriver driver) throws OrekitException {
            this.setValue(driver.getValue());
            this.setReferenceDate(driver.getReferenceDate());
            if (this.isSelected()) {
                driver.setSelected(true);
            } else {
                this.setSelected(driver.isSelected());
            }
            driver.addObserver(this.forwarder);
            this.drivers.add(driver);
        }

        public List<ParameterDriver> getRawDrivers() {
            return Collections.unmodifiableList(this.drivers);
        }

        private class ChangesForwarder
        implements ParameterObserver {
            private ParameterDriver root;
            private int depth;

            private ChangesForwarder() {
            }

            @Override
            public void valueChanged(double previousValue, ParameterDriver driver) throws OrekitException {
                try {
                    this.updateAll(driver, d -> {
                        try {
                            d.setValue(driver.getValue());
                        }
                        catch (OrekitException oe) {
                            throw new OrekitExceptionWrapper(oe);
                        }
                    });
                }
                catch (OrekitExceptionWrapper oew) {
                    throw oew.getException();
                }
            }

            @Override
            public void referenceDateChanged(AbsoluteDate previousReferenceDate, ParameterDriver driver) {
                this.updateAll(driver, d -> d.setReferenceDate(driver.getReferenceDate()));
            }

            @Override
            public void nameChanged(String previousName, ParameterDriver driver) {
                this.updateAll(driver, d -> d.setName(driver.getName()));
            }

            @Override
            public void selectionChanged(boolean previousSelection, ParameterDriver driver) {
                this.updateAll(driver, d -> d.setSelected(driver.isSelected()));
            }

            private void updateAll(ParameterDriver driver, Updater updater) {
                boolean firstCall;
                boolean bl = firstCall = this.depth++ == 0;
                if (firstCall) {
                    this.root = driver;
                }
                if (driver == DelegatingDriver.this) {
                    for (ParameterDriver d : DelegatingDriver.this.drivers) {
                        if (d == this.root) continue;
                        updater.update(d);
                    }
                } else if (firstCall) {
                    updater.update(DelegatingDriver.this);
                }
                if (--this.depth == 0) {
                    this.root = null;
                }
            }
        }
    }
}

