/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.UnivariateVectorFunction;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.FiniteDifferencesDifferentiator;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableVectorFunction;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;
import org.orekit.utils.StateFunction;
import org.orekit.utils.StateJacobian;

public class Differentiation {
    private static final DSFactory FACTORY = new DSFactory(1, 1);

    private Differentiation() {
    }

    public static ParameterFunction differentiate(final ParameterFunction function, final ParameterDriver driver, int nbPoints, double step) {
        UnivariateFunction uf = new UnivariateFunction(){

            public double value(double normalizedValue) throws OrekitExceptionWrapper {
                try {
                    double saved = driver.getNormalizedValue();
                    driver.setNormalizedValue(normalizedValue);
                    double functionValue = function.value(driver);
                    driver.setNormalizedValue(saved);
                    return functionValue;
                }
                catch (OrekitException oe) {
                    throw new OrekitExceptionWrapper(oe);
                }
            }
        };
        FiniteDifferencesDifferentiator differentiator = new FiniteDifferencesDifferentiator(nbPoints, step);
        final UnivariateDifferentiableFunction differentiated = differentiator.differentiate(uf);
        return new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver) throws OrekitException {
                if (!parameterDriver.getName().equals(driver.getName())) {
                    throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, parameterDriver.getName(), driver.getName());
                }
                try {
                    DerivativeStructure dsParam = FACTORY.variable(0, parameterDriver.getNormalizedValue());
                    DerivativeStructure dsValue = differentiated.value(dsParam);
                    return dsValue.getPartialDerivative(new int[]{1});
                }
                catch (OrekitExceptionWrapper oew) {
                    throw oew.getException();
                }
            }
        };
    }

    public static StateJacobian differentiate(final StateFunction function, final int dimension, final AttitudeProvider provider, final OrbitType orbitType, final PositionAngle positionAngle, final double dP, final int nbPoints) {
        return new StateJacobian(){

            @Override
            public double[][] value(SpacecraftState state) throws OrekitException {
                try {
                    double[] tolerances = NumericalPropagator.tolerances(dP, state.getOrbit(), orbitType)[0];
                    double[][] jacobian = new double[dimension][6];
                    for (int j = 0; j < 6; ++j) {
                        StateComponentFunction componentJ = new StateComponentFunction(j, function, provider, state, orbitType, positionAngle);
                        FiniteDifferencesDifferentiator differentiator = new FiniteDifferencesDifferentiator(nbPoints, tolerances[j]);
                        UnivariateDifferentiableVectorFunction differentiatedJ = differentiator.differentiate((UnivariateVectorFunction)componentJ);
                        DerivativeStructure[] c = differentiatedJ.value(FACTORY.variable(0, 0.0));
                        for (int i = 0; i < dimension; ++i) {
                            jacobian[i][j] = c[i].getPartialDerivative(new int[]{1});
                        }
                    }
                    return jacobian;
                }
                catch (OrekitExceptionWrapper oew) {
                    throw oew.getException();
                }
            }
        };
    }

    private static class StateComponentFunction
    implements UnivariateVectorFunction {
        private final int index;
        private final StateFunction f;
        private final OrbitType orbitType;
        private final PositionAngle positionAngle;
        private final SpacecraftState baseState;
        private final AttitudeProvider provider;

        StateComponentFunction(int index, StateFunction f, AttitudeProvider provider, SpacecraftState baseState, OrbitType orbitType, PositionAngle positionAngle) {
            this.index = index;
            this.f = f;
            this.provider = provider;
            this.orbitType = orbitType;
            this.positionAngle = positionAngle;
            this.baseState = baseState;
        }

        public double[] value(double x) throws OrekitExceptionWrapper {
            try {
                double[] array = new double[6];
                double[] arrayDot = new double[6];
                this.orbitType.mapOrbitToArray(this.baseState.getOrbit(), this.positionAngle, array, arrayDot);
                int n = this.index;
                array[n] = array[n] + x;
                Orbit orbit = this.orbitType.mapArrayToOrbit(array, arrayDot, this.positionAngle, this.baseState.getDate(), this.baseState.getMu(), this.baseState.getFrame());
                SpacecraftState state = new SpacecraftState(orbit, this.provider.getAttitude(orbit, orbit.getDate(), orbit.getFrame()), this.baseState.getMass());
                return this.f.value(state);
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }
    }
}

