/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.ode.ODEIntegrator;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.forces.ForceModel;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.ODEIntegratorBuilder;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.utils.ParameterDriver;

public class NumericalPropagatorBuilder
extends AbstractPropagatorBuilder {
    private final ODEIntegratorBuilder builder;
    private final List<ForceModel> forceModels;
    private double mass;
    private AttitudeProvider attProvider;

    public NumericalPropagatorBuilder(Orbit referenceOrbit, ODEIntegratorBuilder builder, PositionAngle positionAngle, double positionScale) throws OrekitException {
        super(referenceOrbit, positionAngle, positionScale, true);
        this.builder = builder;
        this.forceModels = new ArrayList<ForceModel>();
        this.mass = 1000.0;
        this.attProvider = Propagator.DEFAULT_LAW;
    }

    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        this.attProvider = attitudeProvider;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public void addForceModel(ForceModel model) throws OrekitException {
        this.forceModels.add(model);
        for (ParameterDriver driver : model.getParametersDrivers()) {
            this.addSupportedParameter(driver);
        }
    }

    @Override
    public NumericalPropagator buildPropagator(double[] normalizedParameters) throws OrekitException {
        this.setParameters(normalizedParameters);
        Orbit orbit = this.createInitialOrbit();
        Attitude attitude = this.attProvider.getAttitude(orbit, orbit.getDate(), this.getFrame());
        SpacecraftState state = new SpacecraftState(orbit, attitude, this.mass);
        NumericalPropagator propagator = new NumericalPropagator((ODEIntegrator)this.builder.buildIntegrator(orbit, this.getOrbitType()));
        propagator.setOrbitType(this.getOrbitType());
        propagator.setPositionAngleType(this.getPositionAngle());
        propagator.setAttitudeProvider(this.attProvider);
        for (ForceModel model : this.forceModels) {
            propagator.addForceModel(model);
        }
        propagator.resetInitialState(state);
        return propagator;
    }
}

