/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EOPHistoryLoader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.IERSConventions;

class RapidDataAndPredictionColumnsLoader
implements EOPHistoryLoader {
    private static final double ARC_SECONDS_TO_RADIANS = 4.84813681109536E-6;
    private static final double MILLI_ARC_SECONDS_TO_RADIANS = 4.84813681109536E-9;
    private static final double MILLI_SECONDS_TO_SECONDS = 0.001;
    private static final String INTEGER2_FIELD = "((?:\\p{Blank}|\\p{Digit})\\p{Digit})";
    private static final String MJD_FIELD = "\\p{Blank}+(\\p{Digit}+)(?:\\.00*)";
    private static final String SEPARATOR = "\\p{Blank}*[IP]";
    private static final String REAL_FIELD = "\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)";
    private static int DATE_START = 0;
    private static int DATE_END = 15;
    private static final Pattern DATE_PATTERN = Pattern.compile("((?:\\p{Blank}|\\p{Digit})\\p{Digit})((?:\\p{Blank}|\\p{Digit})\\p{Digit})((?:\\p{Blank}|\\p{Digit})\\p{Digit})\\p{Blank}+(\\p{Digit}+)(?:\\.00*)");
    private static int POLE_START = 16;
    private static int POLE_END = 55;
    private static final Pattern POLE_PATTERN = Pattern.compile("\\p{Blank}*[IP]\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private static int UT1_UTC_START = 57;
    private static int UT1_UTC_END = 78;
    private static final Pattern UT1_UTC_PATTERN = Pattern.compile("\\p{Blank}*[IP]\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private static int LOD_START = 79;
    private static int LOD_END = 93;
    private static final Pattern LOD_PATTERN = Pattern.compile("\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private static int NUTATION_START = 95;
    private static int NUTATION_END = 134;
    private static final Pattern NUTATION_PATTERN = Pattern.compile("\\p{Blank}*[IP]\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private final boolean isNonRotatingOrigin;
    private final String supportedNames;

    RapidDataAndPredictionColumnsLoader(boolean isNonRotatingOrigin, String supportedNames) {
        this.isNonRotatingOrigin = isNonRotatingOrigin;
        this.supportedNames = supportedNames;
    }

    @Override
    public void fillHistory(IERSConventions.NutationCorrectionConverter converter, SortedSet<EOPEntry> history) throws OrekitException {
        Parser parser = new Parser(converter, this.isNonRotatingOrigin);
        DataProvidersManager.getInstance().feed(this.supportedNames, parser);
        history.addAll(parser.history);
    }

    private static class Parser
    implements DataLoader {
        private final IERSConventions.NutationCorrectionConverter converter;
        private final boolean isNonRotatingOrigin;
        private final List<EOPEntry> history;
        private int lineNumber;
        private String line;

        Parser(IERSConventions.NutationCorrectionConverter converter, boolean isNonRotatingOrigin) {
            this.converter = converter;
            this.isNonRotatingOrigin = isNonRotatingOrigin;
            this.history = new ArrayList<EOPEntry>();
            this.lineNumber = 0;
        }

        @Override
        public boolean stillAcceptsData() {
            return true;
        }

        @Override
        public void loadData(InputStream input, String name) throws OrekitException, IOException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            this.lineNumber = 0;
            this.line = reader.readLine();
            while (this.line != null) {
                double[] equinox;
                double[] nro;
                double lod;
                double dtu1;
                double y;
                double x;
                int mjd;
                ++this.lineNumber;
                String datePart = this.line.length() >= DATE_END ? this.line.substring(DATE_START, DATE_END) : "";
                String polePart = this.line.length() >= POLE_END ? this.line.substring(POLE_START, POLE_END) : "";
                String ut1utcPart = this.line.length() >= UT1_UTC_END ? this.line.substring(UT1_UTC_START, UT1_UTC_END) : "";
                String lodPart = this.line.length() >= LOD_END ? this.line.substring(LOD_START, LOD_END) : "";
                String nutationPart = this.line.length() >= NUTATION_END ? this.line.substring(NUTATION_START, NUTATION_END) : "";
                Matcher dateMatcher = DATE_PATTERN.matcher(datePart);
                if (dateMatcher.matches()) {
                    int yy = Integer.parseInt(dateMatcher.group(1).trim());
                    int mm = Integer.parseInt(dateMatcher.group(2).trim());
                    int dd = Integer.parseInt(dateMatcher.group(3).trim());
                    mjd = Integer.parseInt(dateMatcher.group(4).trim());
                    DateComponents reconstructedDate = new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd);
                    if (reconstructedDate.getYear() % 100 != yy || reconstructedDate.getMonth() != mm || reconstructedDate.getDay() != dd) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNumber, name, this.line);
                    }
                } else {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNumber, name, this.line);
                }
                if (polePart.trim().length() == 0) {
                    x = 0.0;
                    y = 0.0;
                } else {
                    Matcher poleMatcher = POLE_PATTERN.matcher(polePart);
                    if (poleMatcher.matches()) {
                        x = 4.84813681109536E-6 * Double.parseDouble(poleMatcher.group(1));
                        y = 4.84813681109536E-6 * Double.parseDouble(poleMatcher.group(3));
                    } else {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNumber, name, this.line);
                    }
                }
                if (ut1utcPart.trim().length() == 0) {
                    dtu1 = 0.0;
                } else {
                    Matcher ut1utcMatcher = UT1_UTC_PATTERN.matcher(ut1utcPart);
                    if (ut1utcMatcher.matches()) {
                        dtu1 = Double.parseDouble(ut1utcMatcher.group(1));
                    } else {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNumber, name, this.line);
                    }
                }
                if (lodPart.trim().length() == 0) {
                    lod = 0.0;
                } else {
                    Matcher lodMatcher = LOD_PATTERN.matcher(lodPart);
                    if (lodMatcher.matches()) {
                        lod = 0.001 * Double.parseDouble(lodMatcher.group(1));
                    } else {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNumber, name, this.line);
                    }
                }
                if (nutationPart.trim().length() == 0) {
                    nro = new double[2];
                    equinox = new double[2];
                } else {
                    Matcher nutationMatcher = NUTATION_PATTERN.matcher(nutationPart);
                    AbsoluteDate mjdDate = new AbsoluteDate(new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd), (TimeScale)TimeScalesFactory.getUTC());
                    if (nutationMatcher.matches()) {
                        if (this.isNonRotatingOrigin) {
                            nro = new double[]{4.84813681109536E-9 * Double.parseDouble(nutationMatcher.group(1)), 4.84813681109536E-9 * Double.parseDouble(nutationMatcher.group(3))};
                            equinox = this.converter.toEquinox(mjdDate, nro[0], nro[1]);
                        } else {
                            equinox = new double[]{4.84813681109536E-9 * Double.parseDouble(nutationMatcher.group(1)), 4.84813681109536E-9 * Double.parseDouble(nutationMatcher.group(3))};
                            nro = this.converter.toNonRotating(mjdDate, equinox[0], equinox[1]);
                        }
                    } else {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNumber, name, this.line);
                    }
                }
                this.history.add(new EOPEntry(mjd, dtu1, lod, x, y, equinox[0], equinox[1], nro[0], nro[1]));
                this.line = reader.readLine();
            }
        }
    }
}

