/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;

class PulsatingSphericalHarmonics
implements RawSphericalHarmonicsProvider {
    private final RawSphericalHarmonicsProvider provider;
    private final double pulsation;
    private final double[][] cosC;
    private final double[][] sinC;
    private final double[][] cosS;
    private final double[][] sinS;

    PulsatingSphericalHarmonics(RawSphericalHarmonicsProvider provider, double period, double[][] cosC, double[][] sinC, double[][] cosS, double[][] sinS) {
        this.provider = provider;
        this.pulsation = Math.PI * 2 / period;
        this.cosC = cosC;
        this.sinC = sinC;
        this.cosS = cosS;
        this.sinS = sinS;
    }

    @Override
    public int getMaxDegree() {
        return this.provider.getMaxDegree();
    }

    @Override
    public int getMaxOrder() {
        return this.provider.getMaxOrder();
    }

    @Override
    public double getMu() {
        return this.provider.getMu();
    }

    @Override
    public double getAe() {
        return this.provider.getAe();
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        return this.provider.getReferenceDate();
    }

    @Override
    public double getOffset(AbsoluteDate date) {
        return this.provider.getOffset(date);
    }

    @Override
    public TideSystem getTideSystem() {
        return this.provider.getTideSystem();
    }

    @Override
    public RawSphericalHarmonicsProvider.RawSphericalHarmonics onDate(final AbsoluteDate date) throws OrekitException {
        final RawSphericalHarmonicsProvider.RawSphericalHarmonics raw = this.provider.onDate(date);
        double alpha = this.pulsation * this.getOffset(date);
        final double cAlpha = FastMath.cos((double)alpha);
        final double sAlpha = FastMath.sin((double)alpha);
        return new RawSphericalHarmonicsProvider.RawSphericalHarmonics(){

            @Override
            public AbsoluteDate getDate() {
                return date;
            }

            @Override
            public double getRawCnm(int n, int m) throws OrekitException {
                double cnm = raw.getRawCnm(n, m);
                if (n < PulsatingSphericalHarmonics.this.cosC.length && m < PulsatingSphericalHarmonics.this.cosC[n].length) {
                    cnm += PulsatingSphericalHarmonics.this.cosC[n][m] * cAlpha + PulsatingSphericalHarmonics.this.sinC[n][m] * sAlpha;
                }
                return cnm;
            }

            @Override
            public double getRawSnm(int n, int m) throws OrekitException {
                double snm = raw.getRawSnm(n, m);
                if (n < PulsatingSphericalHarmonics.this.cosS.length && m < PulsatingSphericalHarmonics.this.cosS[n].length) {
                    snm += PulsatingSphericalHarmonics.this.cosS[n][m] * cAlpha + PulsatingSphericalHarmonics.this.sinS[n][m] * sAlpha;
                }
                return snm;
            }
        };
    }
}

