/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.iod;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class IodLambert {
    private final double mu;

    public IodLambert(double mu) {
        this.mu = mu;
    }

    public KeplerianOrbit estimate(Frame frame, boolean posigrade, int nRev, Vector3D p1, AbsoluteDate t1, Vector3D p2, AbsoluteDate t2) {
        double[] Vdep;
        boolean exitflag;
        double r1 = p1.getNorm();
        double r2 = p2.getNorm();
        double tau = t2.durationFrom(t1);
        double R = FastMath.max((double)r1, (double)r2);
        double V = FastMath.sqrt((double)(this.mu / R));
        double T = R / V;
        double dth = Vector3D.angle((Vector3D)p1, (Vector3D)p2);
        if (!posigrade) {
            dth = Math.PI * 2 - dth;
        }
        if (exitflag = this.solveLambertPb(r1 / R, r2 / R, dth += (double)(nRev * 2) * Math.PI, tau / T, nRev, Vdep = new double[2])) {
            Vector3D Pn = p1.crossProduct((Vector)p2);
            Vector3D Pt = Pn.crossProduct((Vector)p1);
            double RT = Pt.getNorm();
            if (!posigrade) {
                RT = -RT;
            }
            Vector3D Vel1 = new Vector3D(V * Vdep[0] / r1, p1, V * Vdep[1] / RT, Pt);
            return new KeplerianOrbit(new PVCoordinates(p1, Vel1), frame, t1, this.mu);
        }
        return null;
    }

    boolean solveLambertPb(double r1, double r2, double dth, double tau, int mRev, double[] V1) {
        double eta;
        double x;
        double y2;
        double y1;
        double x2;
        double x1;
        double in2;
        double in1;
        boolean leftbranch = FastMath.signum((float)mRev) > 0.0f;
        int longway = 0;
        if (tau > 0.0) {
            longway = 1;
        }
        int m = FastMath.abs((int)mRev);
        double rtof = FastMath.abs((double)tau);
        double theta = dth;
        if (longway < 0) {
            theta = Math.PI * 2 - dth;
        }
        double chord = FastMath.sqrt((double)(r1 * r1 + r2 * r2 - 2.0 * r1 * r2 * FastMath.cos((double)theta)));
        double speri = 0.5 * (r1 + r2 + chord);
        double minSma = speri / 2.0;
        double lambda = FastMath.sqrt((double)(1.0 - chord / speri));
        double logt = FastMath.log((double)rtof);
        if (m == 0) {
            in1 = -0.6523333;
            in2 = 0.6523333;
            x1 = FastMath.log((double)(1.0 + in1));
            x2 = FastMath.log((double)(1.0 + in2));
        } else {
            if (!leftbranch) {
                in1 = -0.523334;
                in2 = -0.223334;
            } else {
                in1 = 0.723334;
                in2 = 0.523334;
            }
            x1 = FastMath.tan((double)(in1 * 0.5 * Math.PI));
            x2 = FastMath.tan((double)(in2 * 0.5 * Math.PI));
        }
        double tof1 = this.timeOfFlight(in1, longway, m, minSma, speri, chord);
        double tof2 = this.timeOfFlight(in2, longway, m, minSma, speri, chord);
        if (m == 0) {
            y1 = FastMath.log((double)tof1) - logt;
            y2 = FastMath.log((double)tof2) - logt;
        } else {
            y1 = tof1 - rtof;
            y2 = tof2 - rtof;
        }
        double err = 1.0E20;
        double tol = 1.0E-13;
        int maxiter = 50;
        double xnew = 0.0;
        for (int iterations = 0; err > 1.0E-13 && iterations < 50; ++iterations) {
            xnew = (x1 * y2 - y1 * x2) / (y2 - y1);
            x = m == 0 ? FastMath.exp((double)xnew) - 1.0 : FastMath.atan((double)xnew) * 2.0 / Math.PI;
            double tof = this.timeOfFlight(x, longway, m, minSma, speri, chord);
            double ynew = m == 0 ? FastMath.log((double)tof) - logt : tof - rtof;
            x1 = x2;
            x2 = xnew;
            y1 = y2;
            y2 = ynew;
            err = FastMath.abs((double)(x1 - xnew));
        }
        if (err > 1.0E-13) {
            return false;
        }
        x = m == 0 ? FastMath.exp((double)xnew) - 1.0 : FastMath.atan((double)xnew) * 2.0 / Math.PI;
        double sma = minSma / (1.0 - x * x);
        if (x < 1.0) {
            double alfa = 2.0 * FastMath.acos((double)x);
            double beta = (double)(longway * 2) * FastMath.asin((double)FastMath.sqrt((double)((speri - chord) / (2.0 * sma))));
            double psi = (alfa - beta) / 2.0;
            double etaSq = 2.0 * sma * FastMath.pow((double)FastMath.sin((double)psi), (int)2) / speri;
            eta = FastMath.sqrt((double)etaSq);
        } else {
            double gamma = 2.0 * FastMath.acosh((double)x);
            double delta = (double)(longway * 2) * FastMath.asinh((double)FastMath.sqrt((double)((chord - speri) / (2.0 * sma))));
            double psi = (gamma - delta) / 2.0;
            double etaSq = -2.0 * sma * FastMath.pow((double)FastMath.sinh((double)psi), (int)2) / speri;
            eta = FastMath.sqrt((double)etaSq);
        }
        double VR1 = 1.0 / eta * FastMath.sqrt((double)(1.0 / minSma)) * (2.0 * lambda * minSma / r1 - (lambda + x * eta));
        double VT1 = 1.0 / eta * FastMath.sqrt((double)(1.0 / minSma)) * FastMath.sqrt((double)(r2 / r1)) * FastMath.sin((double)(dth / 2.0));
        V1[0] = VR1;
        V1[1] = VT1;
        return true;
    }

    private double timeOfFlight(double x, int longway, int mrev, double minSma, double speri, double chord) {
        double tof;
        double a = minSma / (1.0 - x * x);
        if (FastMath.abs((double)x) < 1.0) {
            double beta = (double)(longway * 2) * FastMath.asin((double)FastMath.sqrt((double)((speri - chord) / (2.0 * a))));
            double alfa = 2.0 * FastMath.acos((double)x);
            tof = a * FastMath.sqrt((double)a) * (alfa - FastMath.sin((double)alfa) - (beta - FastMath.sin((double)beta)) + Math.PI * 2 * (double)mrev);
        } else {
            double alfa = 2.0 * FastMath.acosh((double)x);
            double beta = (double)(longway * 2) * FastMath.asinh((double)FastMath.sqrt((double)((speri - chord) / (-2.0 * a))));
            tof = -a * FastMath.sqrt((double)(-a)) * (FastMath.sinh((double)alfa) - alfa - (FastMath.sinh((double)beta) - beta));
        }
        return tof;
    }
}

