/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvider;
import org.orekit.data.ZipJarCrawler;
import org.orekit.errors.OrekitException;

public class NetworkCrawler
implements DataProvider {
    private final List<URL> urls = new ArrayList<URL>();
    private int timeout;

    public NetworkCrawler(URL ... urls) {
        for (URL url : urls) {
            this.urls.add(url);
        }
        this.timeout = 10000;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean feed(Pattern supported, DataLoader visitor) throws OrekitException {
        try {
            OrekitException delayedException = null;
            boolean loaded = false;
            for (URL url : this.urls) {
                try {
                    if (!visitor.stillAcceptsData()) continue;
                    String name = url.toURI().toString();
                    String fileName = new File(url.getPath()).getName();
                    if (ZIP_ARCHIVE_PATTERN.matcher(fileName).matches()) {
                        new ZipJarCrawler(url).feed(supported, visitor);
                        loaded = true;
                        continue;
                    }
                    Matcher gzipMatcher = GZIP_FILE_PATTERN.matcher(fileName);
                    String baseName = gzipMatcher.matches() ? gzipMatcher.group(1) : fileName;
                    if (!supported.matcher(baseName).matches()) continue;
                    InputStream stream = this.getStream(url);
                    if (gzipMatcher.matches()) {
                        visitor.loadData(new GZIPInputStream(stream), name);
                    } else {
                        visitor.loadData(stream, name);
                    }
                    stream.close();
                    loaded = true;
                }
                catch (OrekitException oe) {
                    delayedException = oe;
                }
            }
            if (!loaded && delayedException != null) {
                throw delayedException;
            }
            return loaded;
        }
        catch (IOException | URISyntaxException | ParseException e) {
            throw new OrekitException(e, (Localizable)new DummyLocalizable(e.getMessage()), new Object[0]);
        }
    }

    private InputStream getStream(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(this.timeout);
        return connection.getInputStream();
    }
}

