/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvider;
import org.orekit.data.ZipJarCrawler;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public class DirectoryCrawler
implements DataProvider {
    private final File root;

    public DirectoryCrawler(File root) throws OrekitException {
        if (!root.isDirectory()) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_DIRECTORY, root.getAbsolutePath());
        }
        this.root = root;
    }

    @Override
    public boolean feed(Pattern supported, DataLoader visitor) throws OrekitException {
        try {
            return this.feed(supported, visitor, this.root);
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
        catch (ParseException pe) {
            throw new OrekitException(pe, (Localizable)new DummyLocalizable(pe.getMessage()), new Object[0]);
        }
    }

    private boolean feed(Pattern supported, DataLoader visitor, File directory) throws OrekitException, IOException, ParseException {
        File[] list = directory.listFiles();
        Arrays.sort(list, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.compareTo(o2);
            }
        });
        OrekitException delayedException = null;
        boolean loaded = false;
        for (int i = 0; i < list.length; ++i) {
            try {
                String baseName;
                if (!visitor.stillAcceptsData()) continue;
                if (list[i].isDirectory()) {
                    loaded = this.feed(supported, visitor, list[i]) || loaded;
                    continue;
                }
                if (ZIP_ARCHIVE_PATTERN.matcher(list[i].getName()).matches()) {
                    ZipJarCrawler zipProvider = new ZipJarCrawler(list[i]);
                    loaded = zipProvider.feed(supported, visitor) || loaded;
                    continue;
                }
                Matcher gzipMatcher = GZIP_FILE_PATTERN.matcher(list[i].getName());
                String string = baseName = gzipMatcher.matches() ? gzipMatcher.group(1) : list[i].getName();
                if (!supported.matcher(baseName).matches()) continue;
                InputStream input = new FileInputStream(list[i]);
                if (gzipMatcher.matches()) {
                    input = new GZIPInputStream(input);
                }
                visitor.loadData(input, list[i].getPath());
                input.close();
                loaded = true;
                continue;
            }
            catch (OrekitException oe) {
                delayedException = oe;
            }
        }
        if (!loaded && delayedException != null) {
            throw delayedException;
        }
        return loaded;
    }
}

