/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.FieldPropagator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class AttitudesSequence
implements AttitudeProvider {
    private static final long serialVersionUID = 20150603L;
    private AttitudeProvider active = null;
    private Attitude transitionPreceding = null;
    private AbsoluteDate transitionFollowing = null;
    private AngularDerivativesFilter filter = null;
    private boolean forward = true;
    private final List<Switch<?>> switches = new ArrayList();

    public void resetActiveProvider(AttitudeProvider provider) {
        this.active = provider;
    }

    public void registerSwitchEvents(Propagator propagator) {
        for (Switch<?> s : this.switches) {
            propagator.addEventDetector(s);
        }
    }

    public <T extends RealFieldElement<T>> void registerSwitchEvents(final Field<T> field, FieldPropagator<T> propagator) {
        for (final Switch<?> sw : this.switches) {
            propagator.addEventDetector(new FieldEventDetector<T>(){

                @Override
                public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
                    sw.init(s0.toSpacecraftState(), t.toAbsoluteDate());
                }

                @Override
                public T g(FieldSpacecraftState<T> s) throws OrekitException {
                    return (RealFieldElement)((RealFieldElement)field.getZero()).add(sw.g(s.toSpacecraftState()));
                }

                @Override
                public T getThreshold() {
                    return (RealFieldElement)((RealFieldElement)field.getZero()).add(sw.getThreshold());
                }

                @Override
                public T getMaxCheckInterval() {
                    return (RealFieldElement)((RealFieldElement)field.getZero()).add(sw.getMaxCheckInterval());
                }

                @Override
                public int getMaxIterationCount() {
                    return sw.getMaxIterationCount();
                }

                @Override
                public FieldEventHandler.Action eventOccurred(FieldSpacecraftState<T> s, boolean increasing) throws OrekitException {
                    switch (sw.eventOccurred(s.toSpacecraftState(), increasing)) {
                        case STOP: {
                            return FieldEventHandler.Action.STOP;
                        }
                        case RESET_DERIVATIVES: {
                            return FieldEventHandler.Action.RESET_DERIVATIVES;
                        }
                        case RESET_STATE: {
                            return FieldEventHandler.Action.RESET_STATE;
                        }
                    }
                    return FieldEventHandler.Action.CONTINUE;
                }

                @Override
                public FieldSpacecraftState<T> resetState(FieldSpacecraftState<T> oldState) throws OrekitException {
                    return new FieldSpacecraftState(field, sw.resetState(oldState.toSpacecraftState()));
                }
            });
        }
    }

    public <T extends EventDetector> void addSwitchingCondition(AttitudeProvider past, AttitudeProvider future, T switchEvent, boolean switchOnIncrease, boolean switchOnDecrease, double transitionTime, AngularDerivativesFilter transitionFilter, SwitchHandler handler) throws OrekitException {
        if (transitionTime < switchEvent.getThreshold()) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_SHORT_TRANSITION_TIME_FOR_ATTITUDES_SWITCH, transitionTime, switchEvent.getThreshold());
        }
        if (this.active == null) {
            this.active = past;
        }
        this.switches.add(new Switch(this, switchEvent, switchOnIncrease, switchOnDecrease, past, future, transitionTime, transitionFilter, handler));
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        if (this.transitionPreceding != null) {
            double dtPreceding = date.durationFrom(this.transitionPreceding.getDate());
            double dtFollowing = date.durationFrom(this.transitionFollowing);
            if (this.forward && dtPreceding > 0.0 && dtFollowing < 0.0 || !this.forward && dtPreceding < 0.0 && dtFollowing > 0.0) {
                TimeStampedAngularCoordinates preceding = this.transitionPreceding.withReferenceFrame(frame).getOrientation();
                TimeStampedAngularCoordinates following = this.active.getAttitude(pvProv, this.transitionFollowing, frame).getOrientation();
                TimeStampedAngularCoordinates interpolated = TimeStampedAngularCoordinates.interpolate(date, this.filter, Arrays.asList(preceding, following));
                return new Attitude(frame, interpolated);
            }
        }
        return this.active.getAttitude(pvProv, date, frame);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) throws OrekitException {
        if (this.transitionPreceding != null) {
            double dtPreceding = date.durationFrom(this.transitionPreceding.getDate()).getReal();
            double dtFollowing = date.durationFrom(this.transitionFollowing).getReal();
            if (this.forward && dtPreceding > 0.0 && dtFollowing < 0.0 || !this.forward && dtPreceding < 0.0 && dtFollowing > 0.0) {
                TimeStampedFieldAngularCoordinates<T> preceding = new TimeStampedFieldAngularCoordinates<T>(date.getField(), this.transitionPreceding.withReferenceFrame(frame).getOrientation());
                TimeStampedFieldAngularCoordinates<T> following = this.active.getAttitude(pvProv, new FieldAbsoluteDate<T>(date.getField(), this.transitionFollowing), frame).getOrientation();
                TimeStampedFieldAngularCoordinates<T> interpolated = TimeStampedFieldAngularCoordinates.interpolate(date, this.filter, Arrays.asList(preceding, following));
                return new FieldAttitude<T>(frame, interpolated);
            }
        }
        return this.active.getAttitude(pvProv, date, frame);
    }

    public static interface SwitchHandler {
        public void switchOccurred(AttitudeProvider var1, AttitudeProvider var2, SpacecraftState var3) throws OrekitException;
    }

    private class Switch<T extends EventDetector>
    implements EventDetector {
        private static final long serialVersionUID = 20150604L;
        private final T event;
        private final boolean switchOnIncrease;
        private final boolean switchOnDecrease;
        private final AttitudeProvider past;
        private final AttitudeProvider future;
        private final double transitionTime;
        private final AngularDerivativesFilter transitionFilter;
        private final SwitchHandler switchHandler;
        final /* synthetic */ AttitudesSequence this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        Switch(T switchOnDecrease, boolean past, boolean future, AttitudeProvider transitionTime, AttitudeProvider attitudeProvider, double transitionFilter, AngularDerivativesFilter angularDerivativesFilter, SwitchHandler switchHandler) {
            void switchHandler2;
            void event;
            this.this$0 = (AttitudesSequence)d;
            this.event = event;
            this.switchOnIncrease = switchOnIncrease;
            this.switchOnDecrease = switchOnDecrease;
            this.past = past;
            this.future = future;
            this.transitionTime = transitionTime;
            this.transitionFilter = transitionFilter;
            this.switchHandler = switchHandler2;
        }

        @Override
        public double getThreshold() {
            return this.event.getThreshold();
        }

        @Override
        public double getMaxCheckInterval() {
            return this.event.getMaxCheckInterval();
        }

        @Override
        public int getMaxIterationCount() {
            return this.event.getMaxIterationCount();
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            this.this$0.transitionPreceding = null;
            this.this$0.transitionFollowing = null;
            this.this$0.forward = t.durationFrom(s0.getDate()) >= 0.0;
            this.event.init(s0, t);
        }

        @Override
        public double g(SpacecraftState s) throws OrekitException {
            return this.event.g(this.this$0.forward ? s : s.shiftedBy(-this.transitionTime));
        }

        @Override
        public EventHandler.Action eventOccurred(SpacecraftState s, boolean increasing) throws OrekitException {
            if (this.this$0.active == (this.this$0.forward ? this.past : this.future) && (increasing && this.switchOnIncrease || !increasing && this.switchOnDecrease)) {
                if (this.this$0.forward) {
                    this.this$0.transitionPreceding = s.getAttitude();
                    this.this$0.transitionFollowing = this.this$0.transitionPreceding.getDate().shiftedBy(this.transitionTime);
                    this.this$0.filter = this.transitionFilter;
                    this.this$0.active = this.future;
                    if (this.switchHandler != null) {
                        this.switchHandler.switchOccurred(this.past, this.future, s);
                    }
                    return this.event.eventOccurred(s, increasing);
                }
                this.this$0.transitionPreceding = s.getAttitude();
                this.this$0.transitionFollowing = this.this$0.transitionPreceding.getDate().shiftedBy(-this.transitionTime);
                this.this$0.filter = this.transitionFilter;
                Orbit sOrbit = s.getOrbit().shiftedBy(-this.transitionTime);
                Attitude sAttitude = this.past.getAttitude(sOrbit, sOrbit.getDate(), sOrbit.getFrame());
                SpacecraftState sState = new SpacecraftState(sOrbit, sAttitude, s.getMass());
                for (Map.Entry<String, double[]> entry : s.getAdditionalStates().entrySet()) {
                    sState = sState.addAdditionalState(entry.getKey(), entry.getValue());
                }
                this.this$0.active = this.past;
                if (this.switchHandler != null) {
                    this.switchHandler.switchOccurred(this.future, this.past, sState);
                }
                return this.event.eventOccurred(sState, increasing);
            }
            return this.event.eventOccurred(s, increasing);
        }

        @Override
        public SpacecraftState resetState(SpacecraftState oldState) throws OrekitException {
            return this.event.resetState(oldState);
        }
    }
}

