/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DoubleArrayDictionary
implements Serializable {
    private static final long serialVersionUID = 20211121L;
    private static final int DEFAULT_INITIAL_CAPACITY = 4;
    private final List<Entry> data;

    public DoubleArrayDictionary() {
        this(4);
    }

    public DoubleArrayDictionary(int initialCapacity) {
        this.data = new ArrayList<Entry>(initialCapacity);
    }

    public DoubleArrayDictionary(DoubleArrayDictionary dictionary) {
        this(4 + dictionary.getData().size());
        for (Entry entry : dictionary.getData()) {
            this.data.add(new Entry(entry.getKey(), entry.getValue()));
        }
    }

    public DoubleArrayDictionary(Map<String, double[]> map) {
        this(map.size());
        for (Map.Entry<String, double[]> entry : map.entrySet()) {
            this.data.add(new Entry(entry.getKey(), entry.getValue()));
        }
    }

    public List<Entry> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public int size() {
        return this.data.size();
    }

    public Map<String, double[]> toMap() {
        HashMap<String, double[]> map = new HashMap<String, double[]>(this.data.size());
        for (Entry entry : this.data) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public void clear() {
        this.data.clear();
    }

    public void put(String key, double[] value) {
        this.remove(key);
        this.data.add(new Entry(key, value));
    }

    public void putAll(Map<String, double[]> map) {
        for (Map.Entry<String, double[]> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(DoubleArrayDictionary dictionary) {
        for (Entry entry : dictionary.data) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public double[] get(String key) {
        Entry entry = this.getEntry(key);
        return entry == null ? null : entry.getValue();
    }

    public Entry getEntry(String key) {
        for (Entry entry : this.data) {
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    public boolean remove(String key) {
        Iterator<Entry> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getKey().equals(key)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public DoubleArrayDictionary unmodifiableView() {
        return new View();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.data.get(i).getKey());
            builder.append('[');
            builder.append(this.data.get(i).getValue().length);
            builder.append(']');
        }
        builder.append('}');
        return builder.toString();
    }

    private class View
    extends DoubleArrayDictionary {
        private static final long serialVersionUID = 20211121L;

        private View() {
        }

        @Override
        public List<Entry> getData() {
            return DoubleArrayDictionary.this.getData();
        }

        @Override
        public int size() {
            return DoubleArrayDictionary.this.size();
        }

        @Override
        public Map<String, double[]> toMap() {
            return DoubleArrayDictionary.this.toMap();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void put(String key, double[] value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<String, double[]> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(DoubleArrayDictionary dictionary) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] get(String key) {
            return DoubleArrayDictionary.this.get(key);
        }

        @Override
        public Entry getEntry(String key) {
            return DoubleArrayDictionary.this.getEntry(key);
        }

        @Override
        public boolean remove(String key) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 20211121L;
        private final String key;
        private final double[] value;

        Entry(String key, double[] value) {
            this.key = key;
            this.value = (double[])value.clone();
        }

        public String getKey() {
            return this.key;
        }

        public double[] getValue() {
            return (double[])this.value.clone();
        }

        public int size() {
            return this.value.length;
        }

        public void increment(double[] increment) {
            for (int i = 0; i < increment.length; ++i) {
                int n = i;
                this.value[n] = this.value[n] + increment[i];
            }
        }

        public void scaledIncrement(double factor, Entry raw) {
            for (int i = 0; i < raw.value.length; ++i) {
                int n = i;
                this.value[n] = this.value[n] + factor * raw.value[i];
            }
        }

        public void zero() {
            Arrays.fill(this.value, 0.0);
        }
    }
}

