/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldInterpolationGrid;

public class FieldFixedNumberInterpolationGrid<T extends CalculusFieldElement<T>>
implements FieldInterpolationGrid<T> {
    private final int pointsPerStep;
    private final Field<T> field;

    public FieldFixedNumberInterpolationGrid(Field<T> field, int pointsPerStep) {
        this.field = field;
        this.pointsPerStep = pointsPerStep;
    }

    @Override
    public T[] getGridPoints(T stepStart, T stepEnd) {
        CalculusFieldElement[] grid = (CalculusFieldElement[])MathArrays.buildArray(this.field, (int)this.pointsPerStep);
        CalculusFieldElement stepSize = (CalculusFieldElement)((CalculusFieldElement)stepEnd.subtract(stepStart)).divide((double)(this.pointsPerStep - 1));
        for (int i = 0; i < this.pointsPerStep; ++i) {
            grid[i] = (CalculusFieldElement)((CalculusFieldElement)stepSize.multiply(i)).add(stepStart);
        }
        return grid;
    }
}

