/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.ode.FieldODEIntegrator;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.sampling.FieldODEStateInterpolator;
import org.hipparchus.ode.sampling.FieldODEStepHandler;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.integration.FieldAbstractIntegratedPropagator;
import org.orekit.propagation.integration.FieldStateMapper;
import org.orekit.propagation.numerical.FieldNumericalPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTNewtonianAttraction;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldFixedNumberInterpolationGrid;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldInterpolationGrid;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldMaxGapInterpolationGrid;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldArrayDictionary;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;

public class FieldDSSTPropagator<T extends CalculusFieldElement<T>>
extends FieldAbstractIntegratedPropagator<T> {
    private static final int I = 1;
    private static final int INTERPOLATION_POINTS_PER_STEP = 3;
    private static final double EPSILON_DEFAULT = 1.0E-13;
    private static final int MAX_ITERATIONS_DEFAULT = 200;
    private boolean initialIsOsculating;
    private final Field<T> field;
    private final transient List<DSSTForceModel> forceModels;
    private FieldMeanPlusShortPeriodicMapper mapper;
    private FieldInterpolationGrid<T> interpolationgrid;

    @DefaultDataContext
    public FieldDSSTPropagator(Field<T> field, FieldODEIntegrator<T> integrator, PropagationType propagationType) {
        this(field, integrator, propagationType, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()));
    }

    public FieldDSSTPropagator(Field<T> field, FieldODEIntegrator<T> integrator, PropagationType propagationType, AttitudeProvider attitudeProvider) {
        super(field, integrator, propagationType);
        this.field = field;
        this.forceModels = new ArrayList<DSSTForceModel>();
        this.initMapper(field);
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngle.MEAN);
        this.setAttitudeProvider(attitudeProvider);
        this.setInterpolationGridToFixedNumberOfPoints(3);
    }

    @DefaultDataContext
    public FieldDSSTPropagator(Field<T> field, FieldODEIntegrator<T> integrator) {
        this(field, integrator, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()));
    }

    public FieldDSSTPropagator(Field<T> field, FieldODEIntegrator<T> integrator, AttitudeProvider attitudeProvider) {
        super(field, integrator, PropagationType.MEAN);
        this.field = field;
        this.forceModels = new ArrayList<DSSTForceModel>();
        this.initMapper(field);
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngle.MEAN);
        this.setAttitudeProvider(attitudeProvider);
        this.setInterpolationGridToFixedNumberOfPoints(3);
    }

    @Override
    public void setMu(T mu) {
        this.addForceModel(new DSSTNewtonianAttraction(mu.getReal()));
    }

    private void superSetMu(T mu) {
        super.setMu(mu);
    }

    private boolean hasNewtonianAttraction() {
        int last = this.forceModels.size() - 1;
        return last >= 0 && this.forceModels.get(last) instanceof DSSTNewtonianAttraction;
    }

    public void setInitialState(FieldSpacecraftState<T> initialState) {
        this.setInitialState(initialState, PropagationType.OSCULATING);
    }

    public void setInitialState(FieldSpacecraftState<T> initialState, PropagationType stateType) {
        switch (stateType) {
            case MEAN: {
                this.initialIsOsculating = false;
                break;
            }
            case OSCULATING: {
                this.initialIsOsculating = true;
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
        this.resetInitialState(initialState);
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        super.resetInitialState(state);
        if (!this.hasNewtonianAttraction()) {
            this.setMu(state.getMu());
        }
        super.setStartDate(state.getDate());
    }

    public void setSelectedCoefficients(Set<String> selectedCoefficients) {
        this.mapper.setSelectedCoefficients((Set<String>)(selectedCoefficients == null ? null : new HashSet<String>(selectedCoefficients)));
    }

    public Set<String> getSelectedCoefficients() {
        Set<String> set = this.mapper.getSelectedCoefficients();
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    public boolean initialIsOsculating() {
        return this.initialIsOsculating;
    }

    public void setInterpolationGridToFixedNumberOfPoints(int interpolationPoints) {
        this.interpolationgrid = new FieldFixedNumberInterpolationGrid<T>(this.field, interpolationPoints);
    }

    public void setInterpolationGridToMaxTimeGap(T maxGap) {
        this.interpolationgrid = new FieldMaxGapInterpolationGrid<T>(this.field, maxGap);
    }

    public void addForceModel(DSSTForceModel force) {
        if (force instanceof DSSTNewtonianAttraction) {
            try {
                force.getParametersDrivers().get(0).addObserver(new ParameterObserver(){

                    @Override
                    public void valueChanged(double previousValue, ParameterDriver driver) {
                        FieldDSSTPropagator.this.superSetMu((CalculusFieldElement)((CalculusFieldElement)FieldDSSTPropagator.this.field.getZero()).add(driver.getValue()));
                    }
                });
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
            if (this.hasNewtonianAttraction()) {
                this.forceModels.set(this.forceModels.size() - 1, force);
            } else {
                this.forceModels.add(force);
            }
        } else if (this.hasNewtonianAttraction()) {
            this.forceModels.add(this.forceModels.size() - 1, force);
        } else {
            this.forceModels.add(force);
        }
        force.registerAttitudeProvider(this.getAttitudeProvider());
    }

    public void removeForceModels() {
        int last = this.forceModels.size() - 1;
        if (this.hasNewtonianAttraction()) {
            DSSTForceModel newton = this.forceModels.get(last);
            this.forceModels.clear();
            this.forceModels.add(newton);
        } else {
            this.forceModels.clear();
        }
    }

    public List<DSSTForceModel> getAllForceModels() {
        return Collections.unmodifiableList(this.forceModels);
    }

    @Override
    public OrbitType getOrbitType() {
        return super.getOrbitType();
    }

    @Override
    public PositionAngle getPositionAngleType() {
        return super.getPositionAngleType();
    }

    public static <T extends CalculusFieldElement<T>> FieldSpacecraftState<T> computeOsculatingState(FieldSpacecraftState<T> mean, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forces) {
        FieldAuxiliaryElements<T> aux = new FieldAuxiliaryElements<T>(mean.getOrbit(), 1);
        ArrayList<FieldShortPeriodTerms<T>> shortPeriodTerms = new ArrayList<FieldShortPeriodTerms<T>>();
        for (DSSTForceModel force : forces) {
            CalculusFieldElement[] parameters = force.getParameters(mean.getDate().getField());
            force.registerAttitudeProvider(attitudeProvider);
            shortPeriodTerms.addAll(force.initializeShortPeriodTerms(aux, PropagationType.OSCULATING, parameters));
            force.updateShortPeriodTerms(parameters, new FieldSpacecraftState[]{mean});
        }
        FieldEquinoctialOrbit<T> osculatingOrbit = FieldDSSTPropagator.computeOsculatingOrbit(mean, shortPeriodTerms);
        return new FieldSpacecraftState<T>(osculatingOrbit, mean.getAttitude(), mean.getMass(), mean.getAdditionalStatesValues());
    }

    public static <T extends CalculusFieldElement<T>> FieldSpacecraftState<T> computeMeanState(FieldSpacecraftState<T> osculating, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forceModel) {
        return FieldDSSTPropagator.computeMeanState(osculating, attitudeProvider, forceModel, 1.0E-13, 200);
    }

    public static <T extends CalculusFieldElement<T>> FieldSpacecraftState<T> computeMeanState(FieldSpacecraftState<T> osculating, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forceModel, double epsilon, int maxIterations) {
        FieldOrbit<T> meanOrbit = FieldDSSTPropagator.computeMeanOrbit(osculating, attitudeProvider, forceModel, epsilon, maxIterations);
        return new FieldSpacecraftState<T>(meanOrbit, osculating.getAttitude(), osculating.getMass(), osculating.getAdditionalStatesValues());
    }

    public void setSatelliteRevolution(int satelliteRevolution) {
        this.mapper.setSatelliteRevolution(satelliteRevolution);
    }

    public int getSatelliteRevolution() {
        return this.mapper.getSatelliteRevolution();
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        super.setAttitudeProvider(attitudeProvider);
        for (DSSTForceModel force : this.forceModels) {
            force.registerAttitudeProvider(attitudeProvider);
        }
    }

    @Override
    protected void beforeIntegration(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> tEnd) {
        PropagationType type = this.isMeanOrbit();
        FieldAuxiliaryElements<T> aux = new FieldAuxiliaryElements<T>(initialState.getOrbit(), 1);
        ArrayList shortPeriodTerms = new ArrayList();
        for (DSSTForceModel dSSTForceModel : this.forceModels) {
            shortPeriodTerms.addAll(dSSTForceModel.initializeShortPeriodTerms(aux, type, dSSTForceModel.getParameters(this.field)));
        }
        this.mapper.setShortPeriodTerms(shortPeriodTerms);
        if (type == PropagationType.OSCULATING) {
            FieldShortPeriodicsHandler spHandler = new FieldShortPeriodicsHandler(this.forceModels);
            for (DSSTForceModel forceModel : this.forceModels) {
                forceModel.updateShortPeriodTerms(forceModel.getParameters(this.field), new FieldSpacecraftState[]{initialState});
            }
            ArrayList<FieldShortPeriodicsHandler> arrayList = new ArrayList<FieldShortPeriodicsHandler>();
            arrayList.add(spHandler);
            FieldODEIntegrator integrator = this.getIntegrator();
            Collection existing = integrator.getStepHandlers();
            arrayList.addAll(existing);
            integrator.clearStepHandlers();
            for (FieldODEStepHandler fieldODEStepHandler : arrayList) {
                integrator.addStepHandler(fieldODEStepHandler);
            }
        }
    }

    @Override
    protected void afterIntegration() {
        if (this.isMeanOrbit() == PropagationType.OSCULATING) {
            ArrayList preserved = new ArrayList();
            FieldODEIntegrator integrator = this.getIntegrator();
            integrator.clearStepHandlers();
            for (FieldODEStepHandler sp : preserved) {
                integrator.addStepHandler(sp);
            }
        }
    }

    private static <T extends CalculusFieldElement<T>> FieldOrbit<T> computeMeanOrbit(FieldSpacecraftState<T> osculating, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forceModel, double epsilon, int maxIterations) {
        CalculusFieldElement zero = (CalculusFieldElement)osculating.getDate().getField().getZero();
        FieldEquinoctialOrbit<CalculusFieldElement> meanOrbit = (FieldEquinoctialOrbit<CalculusFieldElement>)OrbitType.EQUINOCTIAL.convertType(osculating.getOrbit());
        CalculusFieldElement epsilonT = (CalculusFieldElement)zero.add(epsilon);
        CalculusFieldElement thresholdA = (CalculusFieldElement)epsilonT.multiply((FieldElement)((CalculusFieldElement)FastMath.abs(meanOrbit.getA()).add(1.0)));
        CalculusFieldElement thresholdE = (CalculusFieldElement)epsilonT.multiply((FieldElement)((CalculusFieldElement)meanOrbit.getE().add(1.0)));
        CalculusFieldElement thresholdI = (CalculusFieldElement)epsilonT.multiply((FieldElement)((CalculusFieldElement)meanOrbit.getI().add(1.0)));
        CalculusFieldElement thresholdL = (CalculusFieldElement)epsilonT.multiply((FieldElement)((CalculusFieldElement)zero.getPi()));
        for (DSSTForceModel force : forceModel) {
            force.registerAttitudeProvider(attitudeProvider);
        }
        int i = 0;
        while (i++ < maxIterations) {
            FieldSpacecraftState<T> meanState = new FieldSpacecraftState<T>(meanOrbit, osculating.getAttitude(), osculating.getMass());
            FieldAuxiliaryElements aux = new FieldAuxiliaryElements(meanOrbit, 1);
            ArrayList<FieldShortPeriodTerms<T>> shortPeriodTerms = new ArrayList<FieldShortPeriodTerms<T>>();
            for (DSSTForceModel force : forceModel) {
                CalculusFieldElement[] parameters = force.getParameters(osculating.getDate().getField());
                shortPeriodTerms.addAll(force.initializeShortPeriodTerms(aux, PropagationType.OSCULATING, parameters));
                force.updateShortPeriodTerms(parameters, new FieldSpacecraftState[]{meanState});
            }
            FieldEquinoctialOrbit<T> rebuilt = FieldDSSTPropagator.computeOsculatingOrbit(meanState, shortPeriodTerms);
            CalculusFieldElement deltaA = (CalculusFieldElement)osculating.getA().subtract(rebuilt.getA());
            CalculusFieldElement deltaEx = (CalculusFieldElement)osculating.getEquinoctialEx().subtract(rebuilt.getEquinoctialEx());
            CalculusFieldElement deltaEy = (CalculusFieldElement)osculating.getEquinoctialEy().subtract(rebuilt.getEquinoctialEy());
            CalculusFieldElement deltaHx = (CalculusFieldElement)osculating.getHx().subtract(rebuilt.getHx());
            CalculusFieldElement deltaHy = (CalculusFieldElement)osculating.getHy().subtract(rebuilt.getHy());
            CalculusFieldElement deltaLv = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)osculating.getLv().subtract(rebuilt.getLv())), (CalculusFieldElement)zero);
            if (FastMath.abs((CalculusFieldElement)deltaA).getReal() < thresholdA.getReal() && FastMath.abs((CalculusFieldElement)deltaEx).getReal() < thresholdE.getReal() && FastMath.abs((CalculusFieldElement)deltaEy).getReal() < thresholdE.getReal() && FastMath.abs((CalculusFieldElement)deltaHx).getReal() < thresholdI.getReal() && FastMath.abs((CalculusFieldElement)deltaHy).getReal() < thresholdI.getReal() && FastMath.abs((CalculusFieldElement)deltaLv).getReal() < thresholdL.getReal()) {
                return meanOrbit;
            }
            meanOrbit = new FieldEquinoctialOrbit<CalculusFieldElement>((CalculusFieldElement)meanOrbit.getA().add((FieldElement)deltaA), (CalculusFieldElement)meanOrbit.getEquinoctialEx().add((FieldElement)deltaEx), (CalculusFieldElement)meanOrbit.getEquinoctialEy().add((FieldElement)deltaEy), (CalculusFieldElement)meanOrbit.getHx().add((FieldElement)deltaHx), (CalculusFieldElement)meanOrbit.getHy().add((FieldElement)deltaHy), (CalculusFieldElement)meanOrbit.getLv().add((FieldElement)deltaLv), PositionAngle.TRUE, meanOrbit.getFrame(), meanOrbit.getDate(), (CalculusFieldElement)meanOrbit.getMu());
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_DSST_MEAN_PARAMETERS, i);
    }

    private static <T extends CalculusFieldElement<T>> FieldEquinoctialOrbit<T> computeOsculatingOrbit(FieldSpacecraftState<T> meanState, List<FieldShortPeriodTerms<T>> shortPeriodTerms) {
        CalculusFieldElement[] mean = (CalculusFieldElement[])MathArrays.buildArray(meanState.getDate().getField(), (int)6);
        CalculusFieldElement[] meanDot = (CalculusFieldElement[])MathArrays.buildArray(meanState.getDate().getField(), (int)6);
        OrbitType.EQUINOCTIAL.mapOrbitToArray(meanState.getOrbit(), PositionAngle.MEAN, mean, meanDot);
        CalculusFieldElement[] y = (CalculusFieldElement[])mean.clone();
        for (FieldShortPeriodTerms<T> spt : shortPeriodTerms) {
            CalculusFieldElement[] shortPeriodic = spt.value(meanState.getOrbit());
            for (int i = 0; i < shortPeriodic.length; ++i) {
                y[i] = (CalculusFieldElement)y[i].add((FieldElement)shortPeriodic[i]);
            }
        }
        return (FieldEquinoctialOrbit)OrbitType.EQUINOCTIAL.mapArrayToOrbit(y, meanDot, PositionAngle.MEAN, meanState.getDate(), (CalculusFieldElement)meanState.getMu(), meanState.getFrame());
    }

    @Override
    protected FieldSpacecraftState<T> getInitialIntegrationState() {
        if (this.initialIsOsculating) {
            return FieldDSSTPropagator.computeMeanState(this.getInitialState(), this.getAttitudeProvider(), this.forceModels);
        }
        return this.getInitialState();
    }

    @Override
    protected FieldStateMapper<T> createMapper(FieldAbsoluteDate<T> referenceDate, T mu, OrbitType ignoredOrbitType, PositionAngle ignoredPositionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
        FieldMeanPlusShortPeriodicMapper newMapper = new FieldMeanPlusShortPeriodicMapper(this, referenceDate, mu, attitudeProvider, frame);
        if (this.mapper != null) {
            newMapper.setSatelliteRevolution(this.mapper.getSatelliteRevolution());
            newMapper.setSelectedCoefficients(this.mapper.getSelectedCoefficients());
            newMapper.setShortPeriodTerms(this.mapper.getShortPeriodTerms());
        }
        this.mapper = newMapper;
        return this.mapper;
    }

    @Override
    protected FieldAbstractIntegratedPropagator.MainStateEquations<T> getMainStateEquations(FieldODEIntegrator<T> integrator) {
        return new Main(integrator);
    }

    public static <T extends CalculusFieldElement<T>> double[][] tolerances(T dP, FieldOrbit<T> orbit) {
        return FieldNumericalPropagator.tolerances(dP, orbit, OrbitType.EQUINOCTIAL);
    }

    public static <T extends CalculusFieldElement<T>> double[][] tolerances(T dP, T dV, FieldOrbit<T> orbit) {
        return FieldNumericalPropagator.tolerances(dP, dV, orbit, OrbitType.EQUINOCTIAL);
    }

    private class FieldShortPeriodicsHandler
    implements FieldODEStepHandler<T> {
        private final List<DSSTForceModel> forceModels;

        FieldShortPeriodicsHandler(List<DSSTForceModel> forceModels) {
            this.forceModels = forceModels;
        }

        public void handleStep(FieldODEStateInterpolator<T> interpolator) {
            CalculusFieldElement[] interpolationPoints = FieldDSSTPropagator.this.interpolationgrid.getGridPoints(interpolator.getPreviousState().getTime(), interpolator.getCurrentState().getTime());
            FieldSpacecraftState[] meanStates = new FieldSpacecraftState[interpolationPoints.length];
            for (int i = 0; i < interpolationPoints.length; ++i) {
                CalculusFieldElement time = interpolationPoints[i];
                FieldODEStateAndDerivative sd = interpolator.getInterpolatedState(time);
                meanStates[i] = FieldDSSTPropagator.this.mapper.mapArrayToState(time, sd.getPrimaryState(), sd.getPrimaryDerivative(), PropagationType.MEAN);
            }
            for (DSSTForceModel forceModel : this.forceModels) {
                forceModel.updateShortPeriodTerms(forceModel.getParameters(FieldDSSTPropagator.this.field), meanStates);
            }
        }
    }

    private class Main
    implements FieldAbstractIntegratedPropagator.MainStateEquations<T> {
        private final T[] yDot;

        Main(FieldODEIntegrator<T> integrator) {
            this.yDot = (CalculusFieldElement[])MathArrays.buildArray((Field)FieldDSSTPropagator.this.field, (int)7);
            for (DSSTForceModel forceModel : FieldDSSTPropagator.this.forceModels) {
                FieldEventDetector<T>[] modelDetectors = forceModel.getFieldEventsDetectors(FieldDSSTPropagator.this.field);
                if (modelDetectors == null) continue;
                for (FieldEventDetector detector : modelDetectors) {
                    FieldDSSTPropagator.this.setUpEventDetector(integrator, detector);
                }
            }
        }

        @Override
        public void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
            FieldDSSTPropagator.this.forceModels.forEach(fm -> fm.init(initialState, target));
        }

        @Override
        public T[] computeDerivatives(FieldSpacecraftState<T> state) {
            CalculusFieldElement zero = (CalculusFieldElement)state.getDate().getField().getZero();
            Arrays.fill(this.yDot, zero);
            FieldAuxiliaryElements auxiliaryElements = new FieldAuxiliaryElements(state.getOrbit(), 1);
            for (DSSTForceModel forceModel : FieldDSSTPropagator.this.forceModels) {
                CalculusFieldElement[] daidt = this.elementRates(forceModel, state, auxiliaryElements, forceModel.getParameters(FieldDSSTPropagator.this.field));
                for (int i = 0; i < daidt.length; ++i) {
                    this.yDot[i] = (CalculusFieldElement)this.yDot[i].add((FieldElement)daidt[i]);
                }
            }
            return (CalculusFieldElement[])this.yDot.clone();
        }

        private T[] elementRates(DSSTForceModel forceModel, FieldSpacecraftState<T> state, FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
            return forceModel.getMeanElementRate(state, auxiliaryElements, (CalculusFieldElement[])parameters);
        }
    }

    private static class FieldMeanPlusShortPeriodicMapper
    extends FieldStateMapper<T> {
        private Set<String> selectedCoefficients;
        private int satelliteRevolution;
        private List<FieldShortPeriodTerms<T>> shortPeriodTerms;
        final /* synthetic */ FieldDSSTPropagator this$0;

        FieldMeanPlusShortPeriodicMapper(FieldAbsoluteDate<T> referenceDate, T mu, AttitudeProvider attitudeProvider, Frame frame) {
            this.this$0 = var1_1;
            super(referenceDate, mu, OrbitType.EQUINOCTIAL, PositionAngle.MEAN, attitudeProvider, frame);
            this.selectedCoefficients = null;
            this.satelliteRevolution = 2;
            this.shortPeriodTerms = Collections.emptyList();
        }

        @Override
        public FieldSpacecraftState<T> mapArrayToState(FieldAbsoluteDate<T> date, T[] y, T[] yDot, PropagationType type) {
            FieldArrayDictionary coefficients;
            CalculusFieldElement[] elements = (CalculusFieldElement[])y.clone();
            switch (type) {
                case MEAN: {
                    coefficients = null;
                    break;
                }
                case OSCULATING: {
                    FieldOrbit meanOrbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(elements, (CalculusFieldElement[])yDot, PositionAngle.MEAN, date, (CalculusFieldElement)this.getMu(), this.getFrame());
                    coefficients = this.selectedCoefficients == null ? null : new FieldArrayDictionary(date.getField());
                    for (FieldShortPeriodTerms spt : this.shortPeriodTerms) {
                        CalculusFieldElement[] shortPeriodic = spt.value(meanOrbit);
                        for (int i = 0; i < shortPeriodic.length; ++i) {
                            elements[i] = (CalculusFieldElement)elements[i].add((FieldElement)shortPeriodic[i]);
                        }
                        if (this.selectedCoefficients == null) continue;
                        coefficients.putAll(spt.getCoefficients(date, this.selectedCoefficients));
                    }
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            CalculusFieldElement mass = elements[6];
            if (mass.getReal() <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, mass);
            }
            FieldOrbit orbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(elements, (CalculusFieldElement[])yDot, PositionAngle.MEAN, date, (CalculusFieldElement)this.getMu(), this.getFrame());
            FieldAttitude attitude = this.getAttitudeProvider().getAttitude(orbit, date, this.getFrame());
            if (coefficients == null) {
                return new FieldSpacecraftState<CalculusFieldElement>(orbit, attitude, mass);
            }
            return new FieldSpacecraftState<CalculusFieldElement>(orbit, attitude, mass, coefficients);
        }

        @Override
        public void mapStateToArray(FieldSpacecraftState<T> state, T[] y, T[] yDot) {
            OrbitType.EQUINOCTIAL.mapOrbitToArray(state.getOrbit(), PositionAngle.MEAN, (CalculusFieldElement[])y, (CalculusFieldElement[])yDot);
            y[6] = state.getMass();
        }

        public void setSatelliteRevolution(int satelliteRevolution) {
            this.satelliteRevolution = satelliteRevolution;
        }

        public int getSatelliteRevolution() {
            return this.satelliteRevolution;
        }

        public void setSelectedCoefficients(Set<String> selectedCoefficients) {
            this.selectedCoefficients = selectedCoefficients;
        }

        public Set<String> getSelectedCoefficients() {
            return this.selectedCoefficients;
        }

        public void setShortPeriodTerms(List<FieldShortPeriodTerms<T>> shortPeriodTerms) {
            this.shortPeriodTerms = shortPeriodTerms;
        }

        public List<FieldShortPeriodTerms<T>> getShortPeriodTerms() {
            return this.shortPeriodTerms;
        }
    }
}

