/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.ode.ODEIntegrator;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.leastsquares.DSSTBatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.AbstractKalmanModel;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.DSSTKalmanModel;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.ODEIntegratorBuilder;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.integration.AdditionalEquationsAdapter;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTNewtonianAttraction;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class DSSTPropagatorBuilder
extends AbstractPropagatorBuilder
implements OrbitDeterminationPropagatorBuilder {
    private final ODEIntegratorBuilder builder;
    private final List<DSSTForceModel> forceModels;
    private double mass;
    private PropagationType propagationType;
    private PropagationType stateType;

    public DSSTPropagatorBuilder(Orbit referenceOrbit, ODEIntegratorBuilder builder, double positionScale, PropagationType propagationType, PropagationType stateType) {
        this(referenceOrbit, builder, positionScale, propagationType, stateType, InertialProvider.of(referenceOrbit.getFrame()));
    }

    public DSSTPropagatorBuilder(Orbit referenceOrbit, ODEIntegratorBuilder builder, double positionScale, PropagationType propagationType, PropagationType stateType, AttitudeProvider attitudeProvider) {
        super(referenceOrbit, PositionAngle.MEAN, positionScale, true, attitudeProvider);
        this.builder = builder;
        this.forceModels = new ArrayList<DSSTForceModel>();
        this.mass = 1000.0;
        this.propagationType = propagationType;
        this.stateType = stateType;
    }

    public PropagationType getPropagationType() {
        return this.propagationType;
    }

    public PropagationType getStateType() {
        return this.stateType;
    }

    public DSSTPropagatorBuilder copy() {
        DSSTPropagatorBuilder copyBuilder = new DSSTPropagatorBuilder((EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(this.createInitialOrbit()), this.builder, this.getPositionScale(), this.propagationType, this.stateType, this.getAttitudeProvider());
        copyBuilder.setMass(this.mass);
        for (DSSTForceModel model : this.forceModels) {
            copyBuilder.addForceModel(model);
        }
        return copyBuilder;
    }

    public ODEIntegratorBuilder getIntegratorBuilder() {
        return this.builder;
    }

    public List<DSSTForceModel> getAllForceModels() {
        return Collections.unmodifiableList(this.forceModels);
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public void addForceModel(DSSTForceModel model) {
        if (model instanceof DSSTNewtonianAttraction) {
            if (this.hasNewtonianAttraction()) {
                this.forceModels.set(this.forceModels.size() - 1, model);
            } else {
                this.forceModels.add(model);
            }
        } else if (this.hasNewtonianAttraction()) {
            this.forceModels.add(this.forceModels.size() - 1, model);
        } else {
            this.forceModels.add(model);
        }
        for (ParameterDriver driver : model.getParametersDrivers()) {
            this.addSupportedParameter(driver);
        }
    }

    public void resetOrbit(Orbit newOrbit, PropagationType orbitType) {
        this.stateType = orbitType;
        super.resetOrbit(newOrbit);
    }

    @Override
    public DSSTPropagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        EquinoctialOrbit orbit = (EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(this.createInitialOrbit());
        Attitude attitude = this.getAttitudeProvider().getAttitude(orbit, orbit.getDate(), this.getFrame());
        SpacecraftState state = new SpacecraftState((Orbit)orbit, attitude, this.mass);
        DSSTPropagator propagator = new DSSTPropagator((ODEIntegrator)this.builder.buildIntegrator(orbit, OrbitType.EQUINOCTIAL), this.propagationType, this.getAttitudeProvider());
        if (!this.hasNewtonianAttraction()) {
            this.addForceModel(new DSSTNewtonianAttraction(orbit.getMu()));
        }
        for (DSSTForceModel model : this.forceModels) {
            propagator.addForceModel(model);
        }
        propagator.setInitialState(state, this.stateType);
        for (AdditionalDerivativesProvider provider : this.getAdditionalDerivativesProviders()) {
            propagator.addAdditionalDerivativesProvider(provider);
        }
        for (AdditionalEquations equations : this.getAdditionalEquations()) {
            propagator.addAdditionalDerivativesProvider(new AdditionalEquationsAdapter(equations, propagator::getInitialState));
        }
        return propagator;
    }

    @Override
    public DSSTBatchLSModel buildLSModel(OrbitDeterminationPropagatorBuilder[] builders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        return new DSSTBatchLSModel(builders, measurements, estimatedMeasurementsParameters, observer, this.propagationType, this.stateType);
    }

    @Override
    public AbstractKalmanModel buildKalmanModel(List<OrbitDeterminationPropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementsParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        return new DSSTKalmanModel(propagatorBuilders, covarianceMatricesProviders, estimatedMeasurementsParameters, measurementProcessNoiseMatrix, this.propagationType, this.stateType);
    }

    private boolean hasNewtonianAttraction() {
        int last = this.forceModels.size() - 1;
        return last >= 0 && this.forceModels.get(last) instanceof DSSTNewtonianAttraction;
    }
}

