/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.util.ArithmeticUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.InertialProvider;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.ParseUtils;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;
import org.orekit.utils.ParameterDriver;

public class TLE
implements TimeStamped,
Serializable {
    public static final int SGP = 1;
    public static final int SGP4 = 2;
    public static final int SDP4 = 3;
    public static final int SGP8 = 4;
    public static final int SDP8 = 5;
    public static final int DEFAULT = 0;
    public static final String B_STAR = "BSTAR";
    private static final double EPSILON_DEFAULT = 1.0E-10;
    private static final int MAX_ITERATIONS_DEFAULT = 100;
    private static final double B_STAR_SCALE = FastMath.scalb((double)1.0, (int)-20);
    private static final String MEAN_MOTION = "meanMotion";
    private static final String INCLINATION = "inclination";
    private static final String ECCENTRICITY = "eccentricity";
    private static final Pattern LINE_1_PATTERN = Pattern.compile("1 [ 0-9A-Z&&[^IO]][ 0-9]{4}[A-Z] [ 0-9]{5}[ A-Z]{3} [ 0-9]{5}[.][ 0-9]{8} (?:(?:[ 0+-][.][ 0-9]{8})|(?: [ +-][.][ 0-9]{7})) [ +-][ 0-9]{5}[+-][ 0-9] [ +-][ 0-9]{5}[+-][ 0-9] [ 0-9] [ 0-9]{4}[ 0-9]");
    private static final Pattern LINE_2_PATTERN = Pattern.compile("2 [ 0-9A-Z&&[^IO]][ 0-9]{4} [ 0-9]{3}[.][ 0-9]{4} [ 0-9]{3}[.][ 0-9]{4} [ 0-9]{7} [ 0-9]{3}[.][ 0-9]{4} [ 0-9]{3}[.][ 0-9]{4} [ 0-9]{2}[.][ 0-9]{13}[ 0-9]");
    private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final long serialVersionUID = -1596648022319057689L;
    private final int satelliteNumber;
    private final char classification;
    private final int launchYear;
    private final int launchNumber;
    private final String launchPiece;
    private final int ephemerisType;
    private final int elementNumber;
    private final AbsoluteDate epoch;
    private final double meanMotion;
    private final double meanMotionFirstDerivative;
    private final double meanMotionSecondDerivative;
    private final double eccentricity;
    private final double inclination;
    private final double pa;
    private final double raan;
    private final double meanAnomaly;
    private final int revolutionNumberAtEpoch;
    private String line1;
    private String line2;
    private final TimeScale utc;
    private final transient ParameterDriver bStarParameterDriver;

    @DefaultDataContext
    public TLE(String line1, String line2) {
        this(line1, line2, DataContext.getDefault().getTimeScales().getUTC());
    }

    public TLE(String line1, String line2, TimeScale utc) {
        this.satelliteNumber = ParseUtils.parseSatelliteNumber(line1, 2, 5);
        int satNum2 = ParseUtils.parseSatelliteNumber(line2, 2, 5);
        if (this.satelliteNumber != satNum2) {
            throw new OrekitException((Localizable)OrekitMessages.TLE_LINES_DO_NOT_REFER_TO_SAME_OBJECT, line1, line2);
        }
        this.classification = line1.charAt(7);
        this.launchYear = ParseUtils.parseYear(line1, 9);
        this.launchNumber = ParseUtils.parseInteger(line1, 11, 3);
        this.launchPiece = line1.substring(14, 17).trim();
        this.ephemerisType = ParseUtils.parseInteger(line1, 62, 1);
        this.elementNumber = ParseUtils.parseInteger(line1, 64, 4);
        int year = ParseUtils.parseYear(line1, 18);
        int dayInYear = ParseUtils.parseInteger(line1, 20, 3);
        long df = 27L * (long)ParseUtils.parseInteger(line1, 24, 8);
        int secondsA = (int)(df / 31250L);
        double secondsB = (double)(df % 31250L) / 31250.0;
        this.epoch = new AbsoluteDate(new DateComponents(year, dayInYear), new TimeComponents(secondsA, secondsB), utc);
        this.meanMotion = ParseUtils.parseDouble(line2, 52, 11) * Math.PI / 43200.0;
        this.meanMotionFirstDerivative = ParseUtils.parseDouble(line1, 33, 10) * Math.PI / 1.86624E9;
        this.meanMotionSecondDerivative = Double.parseDouble((line1.substring(44, 45) + '.' + line1.substring(45, 50) + 'e' + line1.substring(50, 52)).replace(' ', '0')) * Math.PI / 5.3747712E13;
        this.eccentricity = Double.parseDouble("." + line2.substring(26, 33).replace(' ', '0'));
        this.inclination = FastMath.toRadians((double)ParseUtils.parseDouble(line2, 8, 8));
        this.pa = FastMath.toRadians((double)ParseUtils.parseDouble(line2, 34, 8));
        this.raan = FastMath.toRadians((double)Double.parseDouble(line2.substring(17, 25).replace(' ', '0')));
        this.meanAnomaly = FastMath.toRadians((double)ParseUtils.parseDouble(line2, 43, 8));
        this.revolutionNumberAtEpoch = ParseUtils.parseInteger(line2, 63, 5);
        double bStarValue = Double.parseDouble((line1.substring(53, 54) + '.' + line1.substring(54, 59) + 'e' + line1.substring(59, 61)).replace(' ', '0'));
        this.line1 = line1;
        this.line2 = line2;
        this.utc = utc;
        this.bStarParameterDriver = new ParameterDriver(B_STAR, bStarValue, B_STAR_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @DefaultDataContext
    public TLE(int satelliteNumber, char classification, int launchYear, int launchNumber, String launchPiece, int ephemerisType, int elementNumber, AbsoluteDate epoch, double meanMotion, double meanMotionFirstDerivative, double meanMotionSecondDerivative, double e, double i, double pa, double raan, double meanAnomaly, int revolutionNumberAtEpoch, double bStar) {
        this(satelliteNumber, classification, launchYear, launchNumber, launchPiece, ephemerisType, elementNumber, epoch, meanMotion, meanMotionFirstDerivative, meanMotionSecondDerivative, e, i, pa, raan, meanAnomaly, revolutionNumberAtEpoch, bStar, DataContext.getDefault().getTimeScales().getUTC());
    }

    public TLE(int satelliteNumber, char classification, int launchYear, int launchNumber, String launchPiece, int ephemerisType, int elementNumber, AbsoluteDate epoch, double meanMotion, double meanMotionFirstDerivative, double meanMotionSecondDerivative, double e, double i, double pa, double raan, double meanAnomaly, int revolutionNumberAtEpoch, double bStar, TimeScale utc) {
        this.satelliteNumber = satelliteNumber;
        this.classification = classification;
        this.launchYear = launchYear;
        this.launchNumber = launchNumber;
        this.launchPiece = launchPiece;
        this.ephemerisType = ephemerisType;
        this.elementNumber = elementNumber;
        this.epoch = epoch;
        this.meanMotion = meanMotion;
        this.meanMotionFirstDerivative = meanMotionFirstDerivative;
        this.meanMotionSecondDerivative = meanMotionSecondDerivative;
        this.inclination = i;
        this.raan = MathUtils.normalizeAngle((double)raan, (double)Math.PI);
        this.eccentricity = e;
        this.pa = MathUtils.normalizeAngle((double)pa, (double)Math.PI);
        this.meanAnomaly = MathUtils.normalizeAngle((double)meanAnomaly, (double)Math.PI);
        this.revolutionNumberAtEpoch = revolutionNumberAtEpoch;
        this.line1 = null;
        this.line2 = null;
        this.utc = utc;
        this.bStarParameterDriver = new ParameterDriver(B_STAR, bStar, B_STAR_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public TimeScale getUtc() {
        return this.utc;
    }

    public String getLine1() {
        if (this.line1 == null) {
            this.buildLine1();
        }
        return this.line1;
    }

    public String getLine2() {
        if (this.line2 == null) {
            this.buildLine2();
        }
        return this.line2;
    }

    private void buildLine1() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('1');
        buffer.append(' ');
        buffer.append(ParseUtils.buildSatelliteNumber(this.satelliteNumber, "satelliteNumber-1"));
        buffer.append(this.classification);
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding("launchYear", this.launchYear % 100, '0', 2, true, this.satelliteNumber));
        buffer.append(ParseUtils.addPadding("launchNumber", this.launchNumber, '0', 3, true, this.satelliteNumber));
        buffer.append(ParseUtils.addPadding("launchPiece", this.launchPiece, ' ', 3, false, this.satelliteNumber));
        buffer.append(' ');
        DateTimeComponents dtc = this.epoch.getComponents(this.utc);
        buffer.append(ParseUtils.addPadding("year", dtc.getDate().getYear() % 100, '0', 2, true, this.satelliteNumber));
        buffer.append(ParseUtils.addPadding("day", dtc.getDate().getDayOfYear(), '0', 3, true, this.satelliteNumber));
        buffer.append('.');
        int fraction = (int)FastMath.rint((double)(31250.0 * dtc.getTime().getSecondsInUTCDay() / 27.0));
        buffer.append(ParseUtils.addPadding("fraction", fraction, '0', 8, true, this.satelliteNumber));
        buffer.append(' ');
        double n1 = this.meanMotionFirstDerivative * 1.86624E9 / Math.PI;
        String sn1 = ParseUtils.addPadding("meanMotionFirstDerivative", new DecimalFormat(".00000000", SYMBOLS).format(n1), ' ', 10, true, this.satelliteNumber);
        buffer.append(sn1);
        buffer.append(' ');
        double n2 = this.meanMotionSecondDerivative * 5.3747712E13 / Math.PI;
        buffer.append(this.formatExponentMarkerFree("meanMotionSecondDerivative", n2, 5, ' ', 8, true));
        buffer.append(' ');
        buffer.append(this.formatExponentMarkerFree("B*", this.getBStar(), 5, ' ', 8, true));
        buffer.append(' ');
        buffer.append(this.ephemerisType);
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding("elementNumber", this.elementNumber, ' ', 4, true, this.satelliteNumber));
        buffer.append(TLE.checksum(buffer));
        this.line1 = buffer.toString();
    }

    private String formatExponentMarkerFree(String name, double d, int mantissaSize, char c, int size, boolean rightJustified) {
        double dAbs;
        int exponent = (dAbs = FastMath.abs((double)d)) < 1.0E-9 ? -9 : (int)FastMath.ceil((double)FastMath.log10((double)dAbs));
        long mantissa = FastMath.round((double)(dAbs * FastMath.pow((double)10.0, (int)(mantissaSize - exponent))));
        if (mantissa == 0L) {
            exponent = 0;
        } else if (mantissa > (long)(ArithmeticUtils.pow((int)10, (int)mantissaSize) - 1)) {
            mantissa = FastMath.round((double)(dAbs * FastMath.pow((double)10.0, (int)(mantissaSize - ++exponent))));
        }
        String sMantissa = ParseUtils.addPadding(name, (int)mantissa, '0', mantissaSize, true, this.satelliteNumber);
        String sExponent = Integer.toString(FastMath.abs((int)exponent));
        String formatted = (d < 0.0 ? (char)'-' : ' ') + sMantissa + (exponent <= 0 ? (char)'-' : '+') + sExponent;
        return ParseUtils.addPadding(name, formatted, c, size, rightJustified, this.satelliteNumber);
    }

    private void buildLine2() {
        StringBuilder buffer = new StringBuilder();
        DecimalFormat f34 = new DecimalFormat("##0.0000", SYMBOLS);
        DecimalFormat f211 = new DecimalFormat("#0.00000000", SYMBOLS);
        buffer.append('2');
        buffer.append(' ');
        buffer.append(ParseUtils.buildSatelliteNumber(this.satelliteNumber, "satelliteNumber-2"));
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding(INCLINATION, f34.format(FastMath.toDegrees((double)this.inclination)), ' ', 8, true, this.satelliteNumber));
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding("raan", f34.format(FastMath.toDegrees((double)this.raan)), ' ', 8, true, this.satelliteNumber));
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding(ECCENTRICITY, (int)FastMath.rint((double)(this.eccentricity * 1.0E7)), '0', 7, true, this.satelliteNumber));
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding("pa", f34.format(FastMath.toDegrees((double)this.pa)), ' ', 8, true, this.satelliteNumber));
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding("meanAnomaly", f34.format(FastMath.toDegrees((double)this.meanAnomaly)), ' ', 8, true, this.satelliteNumber));
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding(MEAN_MOTION, f211.format(this.meanMotion * 43200.0 / Math.PI), ' ', 11, true, this.satelliteNumber));
        buffer.append(ParseUtils.addPadding("revolutionNumberAtEpoch", this.revolutionNumberAtEpoch, ' ', 5, true, this.satelliteNumber));
        buffer.append(TLE.checksum(buffer));
        this.line2 = buffer.toString();
    }

    public int getSatelliteNumber() {
        return this.satelliteNumber;
    }

    public char getClassification() {
        return this.classification;
    }

    public int getLaunchYear() {
        return this.launchYear;
    }

    public int getLaunchNumber() {
        return this.launchNumber;
    }

    public String getLaunchPiece() {
        return this.launchPiece;
    }

    public int getEphemerisType() {
        return this.ephemerisType;
    }

    public int getElementNumber() {
        return this.elementNumber;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.epoch;
    }

    public double getMeanMotion() {
        return this.meanMotion;
    }

    public double getMeanMotionFirstDerivative() {
        return this.meanMotionFirstDerivative;
    }

    public double getMeanMotionSecondDerivative() {
        return this.meanMotionSecondDerivative;
    }

    public double getE() {
        return this.eccentricity;
    }

    public double getI() {
        return this.inclination;
    }

    public double getPerigeeArgument() {
        return this.pa;
    }

    public double getRaan() {
        return this.raan;
    }

    public double getMeanAnomaly() {
        return this.meanAnomaly;
    }

    public int getRevolutionNumberAtEpoch() {
        return this.revolutionNumberAtEpoch;
    }

    public double getBStar() {
        return this.bStarParameterDriver.getValue();
    }

    public String toString() {
        return this.getLine1() + System.getProperty("line.separator") + this.getLine2();
    }

    @DefaultDataContext
    public static TLE stateToTLE(SpacecraftState state, TLE templateTLE) {
        return TLE.stateToTLE(state, templateTLE, DataContext.getDefault().getTimeScales().getUTC(), DataContext.getDefault().getFrames().getTEME());
    }

    public static TLE stateToTLE(SpacecraftState state, TLE templateTLE, TimeScale utc, Frame teme) {
        return TLE.stateToTLE(state, templateTLE, utc, teme, 1.0E-10, 100);
    }

    public static TLE stateToTLE(SpacecraftState state, TLE templateTLE, TimeScale utc, Frame teme, double epsilon, int maxIterations) {
        EquinoctialOrbit equiOrbit = TLE.convert(state.getOrbit(), teme);
        double sma = equiOrbit.getA();
        double ex = equiOrbit.getEquinoctialEx();
        double ey = equiOrbit.getEquinoctialEy();
        double hx = equiOrbit.getHx();
        double hy = equiOrbit.getHy();
        double lv = equiOrbit.getLv();
        KeplerianOrbit keplerianOrbit = (KeplerianOrbit)OrbitType.KEPLERIAN.convertType(equiOrbit);
        TLE current = TLE.newTLE(keplerianOrbit, templateTLE, utc);
        double thrA = epsilon * (1.0 + sma);
        double thrE = epsilon * (1.0 + FastMath.hypot((double)ex, (double)ey));
        double thrH = epsilon * (1.0 + FastMath.hypot((double)hx, (double)hy));
        double thrV = epsilon * Math.PI;
        int k = 0;
        while (k++ < maxIterations) {
            TLEPropagator propagator = TLEPropagator.selectExtrapolator(current, new InertialProvider(Rotation.IDENTITY, teme), state.getMass(), teme);
            Orbit recovOrbit = propagator.getInitialState().getOrbit();
            EquinoctialOrbit recovEquiOrbit = (EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(recovOrbit);
            double deltaSma = equiOrbit.getA() - recovEquiOrbit.getA();
            double deltaEx = equiOrbit.getEquinoctialEx() - recovEquiOrbit.getEquinoctialEx();
            double deltaEy = equiOrbit.getEquinoctialEy() - recovEquiOrbit.getEquinoctialEy();
            double deltaHx = equiOrbit.getHx() - recovEquiOrbit.getHx();
            double deltaHy = equiOrbit.getHy() - recovEquiOrbit.getHy();
            double deltaLv = MathUtils.normalizeAngle((double)(equiOrbit.getLv() - recovEquiOrbit.getLv()), (double)0.0);
            if (FastMath.abs((double)deltaSma) < thrA && FastMath.abs((double)deltaEx) < thrE && FastMath.abs((double)deltaEy) < thrE && FastMath.abs((double)deltaHx) < thrH && FastMath.abs((double)deltaHy) < thrH && FastMath.abs((double)deltaLv) < thrV) {
                for (ParameterDriver templateDrivers : templateTLE.getParametersDrivers()) {
                    if (!templateDrivers.isSelected()) continue;
                    current.getParameterDriver(templateDrivers.getName()).setSelected(true);
                }
                return current;
            }
            EquinoctialOrbit newEquiOrbit = new EquinoctialOrbit(sma += deltaSma, ex += deltaEx, ey += deltaEy, hx += deltaHx, hy += deltaHy, lv += deltaLv, PositionAngle.TRUE, equiOrbit.getFrame(), equiOrbit.getDate(), equiOrbit.getMu());
            KeplerianOrbit newKeplOrbit = (KeplerianOrbit)OrbitType.KEPLERIAN.convertType(newEquiOrbit);
            current = TLE.newTLE(newKeplOrbit, templateTLE, utc);
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_TLE, k);
    }

    private static EquinoctialOrbit convert(Orbit orbitIn, Frame teme) {
        return new EquinoctialOrbit(orbitIn.getPVCoordinates(teme), teme, orbitIn.getMu());
    }

    private static TLE newTLE(KeplerianOrbit keplerianOrbit, TLE templateTLE, TimeScale utc) {
        double meanMotion = keplerianOrbit.getKeplerianMeanMotion();
        double e = keplerianOrbit.getE();
        double i = keplerianOrbit.getI();
        double raan = keplerianOrbit.getRightAscensionOfAscendingNode();
        double pa = keplerianOrbit.getPerigeeArgument();
        double meanAnomaly = keplerianOrbit.getMeanAnomaly();
        AbsoluteDate epoch = keplerianOrbit.getDate();
        int satelliteNumber = templateTLE.getSatelliteNumber();
        char classification = templateTLE.getClassification();
        int launchYear = templateTLE.getLaunchYear();
        int launchNumber = templateTLE.getLaunchNumber();
        String launchPiece = templateTLE.getLaunchPiece();
        int ephemerisType = templateTLE.getEphemerisType();
        int elementNumber = templateTLE.getElementNumber();
        int revolutionNumberAtEpoch = templateTLE.getRevolutionNumberAtEpoch();
        double dt = epoch.durationFrom(templateTLE.getDate());
        int newRevolutionNumberAtEpoch = (int)((double)revolutionNumberAtEpoch + FastMath.floor((double)((MathUtils.normalizeAngle((double)meanAnomaly, (double)Math.PI) + dt * meanMotion) / (Math.PI * 2))));
        double bStar = templateTLE.getBStar();
        double meanMotionFirstDerivative = templateTLE.getMeanMotionFirstDerivative();
        double meanMotionSecondDerivative = templateTLE.getMeanMotionSecondDerivative();
        return new TLE(satelliteNumber, classification, launchYear, launchNumber, launchPiece, ephemerisType, elementNumber, epoch, meanMotion, meanMotionFirstDerivative, meanMotionSecondDerivative, e, i, pa, raan, meanAnomaly, newRevolutionNumberAtEpoch, bStar, utc);
    }

    public static boolean isFormatOK(String line1, String line2) {
        if (line1 == null || line1.length() != 69 || line2 == null || line2.length() != 69) {
            return false;
        }
        if (!LINE_1_PATTERN.matcher(line1).matches() || !LINE_2_PATTERN.matcher(line2).matches()) {
            return false;
        }
        int checksum1 = TLE.checksum(line1);
        if (Integer.parseInt(line1.substring(68)) != checksum1 % 10) {
            throw new OrekitException((Localizable)OrekitMessages.TLE_CHECKSUM_ERROR, 1, Integer.toString(checksum1 % 10), line1.substring(68), line1);
        }
        int checksum2 = TLE.checksum(line2);
        if (Integer.parseInt(line2.substring(68)) != checksum2 % 10) {
            throw new OrekitException((Localizable)OrekitMessages.TLE_CHECKSUM_ERROR, 2, Integer.toString(checksum2 % 10), line2.substring(68), line2);
        }
        return true;
    }

    private static int checksum(CharSequence line) {
        int sum = 0;
        for (int j = 0; j < 68; ++j) {
            char c = line.charAt(j);
            if (Character.isDigit(c)) {
                sum += Character.digit(c, 10);
                continue;
            }
            if (c != '-') continue;
            ++sum;
        }
        return sum % 10;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TLE)) {
            return false;
        }
        TLE tle = (TLE)o;
        return this.satelliteNumber == tle.satelliteNumber && this.classification == tle.classification && this.launchYear == tle.launchYear && this.launchNumber == tle.launchNumber && Objects.equals(this.launchPiece, tle.launchPiece) && this.ephemerisType == tle.ephemerisType && this.elementNumber == tle.elementNumber && Objects.equals(this.epoch, tle.epoch) && this.meanMotion == tle.meanMotion && this.meanMotionFirstDerivative == tle.meanMotionFirstDerivative && this.meanMotionSecondDerivative == tle.meanMotionSecondDerivative && this.eccentricity == tle.eccentricity && this.inclination == tle.inclination && this.pa == tle.pa && this.raan == tle.raan && this.meanAnomaly == tle.meanAnomaly && this.revolutionNumberAtEpoch == tle.revolutionNumberAtEpoch && this.getBStar() == tle.getBStar();
    }

    public int hashCode() {
        return Objects.hash(this.satelliteNumber, Character.valueOf(this.classification), this.launchYear, this.launchNumber, this.launchPiece, this.ephemerisType, this.elementNumber, this.epoch, this.meanMotion, this.meanMotionFirstDerivative, this.meanMotionSecondDerivative, this.eccentricity, this.inclination, this.pa, this.raan, this.meanAnomaly, this.revolutionNumberAtEpoch, this.getBStar());
    }

    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.bStarParameterDriver);
    }

    public ParameterDriver getParameterDriver(String name) {
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!name.equals(driver.getName())) continue;
            return driver;
        }
        StringBuilder sBuilder = new StringBuilder();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (sBuilder.length() > 0) {
                sBuilder.append(", ");
            }
            sBuilder.append(driver.getName());
        }
        throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, name, sBuilder.toString());
    }

    private Object writeReplace() {
        return new DataTransferObject(this.line1, this.line2, this.utc);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = -1596648022319057689L;
        private String line1;
        private String line2;
        private final TimeScale utc;

        DataTransferObject(String line1, String line2, TimeScale utc) {
            this.line1 = line1;
            this.line2 = line2;
            this.utc = utc;
        }

        private Object readResolve() {
            return new TLE(this.line1, this.line2, this.utc);
        }
    }
}

