/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.gnss.data.GNSSClockElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ClockCorrectionsProvider
implements AdditionalStateProvider {
    public static final String CLOCK_CORRECTIONS = "";
    private final GNSSClockElements gnssClk;
    private final AbsoluteDate clockRef;

    public ClockCorrectionsProvider(GNSSClockElements gnssClk) {
        this.gnssClk = gnssClk;
        this.clockRef = gnssClk.getDate();
    }

    @Override
    public String getName() {
        return CLOCK_CORRECTIONS;
    }

    private double getDT(AbsoluteDate date) {
        double dt;
        double cycleDuration = this.gnssClk.getCycleDuration();
        for (dt = date.durationFrom(this.clockRef); dt > 0.5 * cycleDuration; dt -= cycleDuration) {
        }
        while (dt < -0.5 * cycleDuration) {
            dt += cycleDuration;
        }
        return dt;
    }

    @Override
    public double[] getAdditionalState(SpacecraftState state) {
        double dt = this.getDT(state.getDate());
        double dtSat = this.gnssClk.getAf0() + dt * (this.gnssClk.getAf1() + dt * this.gnssClk.getAf2());
        TimeStampedPVCoordinates pv = state.getPVCoordinates();
        double dtRel = -2.0 * Vector3D.dotProduct((Vector3D)pv.getPosition(), (Vector3D)pv.getVelocity()) / 8.987551787368176E16;
        double tg = this.gnssClk.getTGD();
        return new double[]{dtSat, dtRel, tg};
    }
}

