/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.MappingFunction;
import org.orekit.models.earth.troposphere.SaastamoinenModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class EstimatedTroposphericModel
implements DiscreteTroposphericModel {
    public static final String TOTAL_ZENITH_DELAY = "total zenith delay";
    private final MappingFunction model;
    private final ParameterDriver totalZenithDelay;
    private double t0;
    private double p0;

    public EstimatedTroposphericModel(double t0, double p0, MappingFunction model, double totalDelay) {
        this.totalZenithDelay = new ParameterDriver(TOTAL_ZENITH_DELAY, totalDelay, FastMath.scalb((double)1.0, (int)0), 0.0, Double.POSITIVE_INFINITY);
        this.t0 = t0;
        this.p0 = p0;
        this.model = model;
    }

    public EstimatedTroposphericModel(MappingFunction model, double totalDelay) {
        this(291.15, 1013.25, model, totalDelay);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.totalZenithDelay);
    }

    @Override
    public double pathDelay(double elevation, GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        SaastamoinenModel saastamoinen = new SaastamoinenModel(this.t0, this.p0, 0.0);
        double zhd = saastamoinen.pathDelay(1.5707963267948966, point, parameters, date);
        double ztd = parameters[0];
        double[] mf = this.model.mappingFactors(elevation, point, date);
        return mf[0] * zhd + mf[1] * (ztd - zhd);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(T elevation, FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        SaastamoinenModel saastamoinen = new SaastamoinenModel(this.t0, this.p0, 0.0);
        CalculusFieldElement zhd = saastamoinen.pathDelay((CalculusFieldElement)((CalculusFieldElement)elevation.getPi()).multiply(0.5), point, (CalculusFieldElement[])parameters, date);
        T ztd = parameters[0];
        CalculusFieldElement[] mf = this.model.mappingFactors(elevation, point, date);
        return (T)((CalculusFieldElement)((CalculusFieldElement)mf[0].multiply((FieldElement)zhd)).add((FieldElement)((CalculusFieldElement)mf[1].multiply((FieldElement)((CalculusFieldElement)ztd.subtract((FieldElement)zhd))))));
    }
}

