/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.BilinearInterpolatingFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.ParameterDriver;

public class GlobalIonosphereMapModel
extends AbstractSelfFeedingLoader
implements IonosphericModel {
    private static final long serialVersionUID = 201928052L;
    private static final Pattern SEPARATOR = Pattern.compile("\\s+");
    private static final double THRESHOLD = 0.001;
    private double latitude = Double.NaN;
    private double longitude = Double.NaN;
    private double r0;
    private double h;
    private double dt;
    private int nbMaps;
    private boolean mapping;
    private AbsoluteDate startDate;
    private AbsoluteDate endDate;
    private Map<AbsoluteDate, Double> tecMap = new HashMap<AbsoluteDate, Double>();
    private final TimeScale utc;

    @DefaultDataContext
    public GlobalIonosphereMapModel(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales().getUTC());
    }

    public GlobalIonosphereMapModel(String supportedNames, DataProvidersManager dataProvidersManager, TimeScale utc) {
        super(supportedNames, dataProvidersManager);
        this.utc = utc;
    }

    public double pathDelay(AbsoluteDate date, GeodeticPoint geo, double elevation, double frequency) {
        double stec;
        double tec = this.getTEC(date, geo);
        double freq2 = frequency * frequency;
        if (this.mapping) {
            stec = tec;
        } else {
            double fz = this.mappingFunction(elevation);
            stec = tec * fz;
        }
        double alpha = 4.03E17 / freq2;
        return alpha * stec;
    }

    @Override
    public double pathDelay(SpacecraftState state, TopocentricFrame baseFrame, double frequency, double[] parameters) {
        Vector3D position = state.getPVCoordinates(baseFrame).getPosition();
        double elevation = position.getDelta();
        if (elevation > 0.0) {
            AbsoluteDate date = state.getDate();
            GeodeticPoint geo = baseFrame.getPoint();
            return this.pathDelay(date, geo, elevation, frequency);
        }
        return 0.0;
    }

    public <T extends CalculusFieldElement<T>> T pathDelay(FieldAbsoluteDate<T> date, GeodeticPoint geo, T elevation, double frequency) {
        Object stec;
        T tec = this.getTEC(date, geo);
        double freq2 = frequency * frequency;
        if (this.mapping) {
            stec = tec;
        } else {
            T fz = this.mappingFunction(elevation);
            stec = (CalculusFieldElement)tec.multiply(fz);
        }
        double alpha = 4.03E17 / freq2;
        return (T)((CalculusFieldElement)stec.multiply(alpha));
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(FieldSpacecraftState<T> state, TopocentricFrame baseFrame, double frequency, T[] parameters) {
        FieldVector3D position = state.getPVCoordinates(baseFrame).getPosition();
        CalculusFieldElement elevation = position.getDelta();
        if (elevation.getReal() > 0.0) {
            FieldAbsoluteDate<T> date = state.getDate();
            GeodeticPoint geo = baseFrame.getPoint();
            return (T)this.pathDelay(date, geo, elevation, frequency);
        }
        return (T)((CalculusFieldElement)elevation.getField().getZero());
    }

    public double getTEC(AbsoluteDate date, GeodeticPoint recPoint) {
        this.loadsIfNeeded(recPoint);
        this.checkDate(date);
        DateTimeComponents dateTime = date.getComponents(this.utc);
        double secInDay = dateTime.getTime().getSecondsInLocalDay();
        double ratio = FastMath.floor((double)(secInDay / this.dt)) * this.dt;
        AbsoluteDate tI = new AbsoluteDate(dateTime.getDate(), new TimeComponents(ratio), this.utc);
        AbsoluteDate tIp1 = tI.shiftedBy(this.dt);
        double tecI = this.tecMap.get(tI);
        double tecIp1 = this.tecMap.get(tIp1);
        double tec = tIp1.durationFrom(date) / this.dt * tecI + date.durationFrom(tI) / this.dt * tecIp1;
        return tec;
    }

    public <T extends CalculusFieldElement<T>> T getTEC(FieldAbsoluteDate<T> date, GeodeticPoint recPoint) {
        this.loadsIfNeeded(recPoint);
        this.checkDate(date.toAbsoluteDate());
        Field<T> field = date.getField();
        DateTimeComponents dateTime = date.getComponents(this.utc);
        double secInDay = dateTime.getTime().getSecondsInLocalDay();
        double ratio = FastMath.floor((double)(secInDay / this.dt)) * this.dt;
        FieldAbsoluteDate<T> tI = new FieldAbsoluteDate<T>(field, dateTime.getDate(), new TimeComponents(ratio), this.utc);
        TimeShiftable tIp1 = tI.shiftedBy(this.dt);
        double tecI = this.tecMap.get(tI.toAbsoluteDate());
        double tecIp1 = this.tecMap.get(((FieldAbsoluteDate)tIp1).toAbsoluteDate());
        CalculusFieldElement tec = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((FieldAbsoluteDate)tIp1).durationFrom(date).divide(this.dt)).multiply(tecI)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)date.durationFrom(tI).divide(this.dt)).multiply(tecIp1)));
        return (T)tec;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double mappingFunction(double elevation) {
        double z = FastMath.abs((double)(1.5707963267948966 - elevation));
        double ratio = this.r0 / (this.r0 + this.h);
        double coef = FastMath.sin((double)z) * ratio;
        double fz = 1.0 / FastMath.sqrt((double)(1.0 - coef * coef));
        return fz;
    }

    private <T extends CalculusFieldElement<T>> T mappingFunction(T elevation) {
        CalculusFieldElement z = FastMath.abs((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)elevation.getPi()).multiply(0.5)).subtract(elevation)));
        double ratio = this.r0 / (this.r0 + this.h);
        CalculusFieldElement coef = (CalculusFieldElement)FastMath.sin((CalculusFieldElement)z).multiply(ratio);
        CalculusFieldElement fz = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)coef.multiply((FieldElement)coef)).negate()).add(1.0))).reciprocal();
        return (T)fz;
    }

    private void loadsIfNeeded(GeodeticPoint recPoint) {
        double lat = recPoint.getLatitude();
        double lon = MathUtils.normalizeAngle((double)recPoint.getLongitude(), (double)0.0);
        if (this.tecMap.isEmpty() || FastMath.abs((double)(lat - this.latitude)) > 0.001 || FastMath.abs((double)(lon - this.longitude)) > 0.001) {
            this.latitude = lat;
            this.longitude = lon;
            Parser parser = new Parser();
            this.feed(parser);
            IONEXHeader top = parser.getIONEXHeader();
            this.startDate = top.getFirstDate();
            this.endDate = top.getLastDate();
            this.dt = top.getInterval();
            this.nbMaps = top.getTECMapsNumer();
            this.r0 = top.getEarthRadius();
            this.h = top.getHIon();
            this.mapping = top.isMappingFunction();
            for (TECMap map : parser.getTECMaps()) {
                this.tecMap.put(map.getDate(), map.getTEC());
            }
        }
        this.checkSize();
    }

    private void checkDate(AbsoluteDate date) {
        if (this.startDate.durationFrom(date) > 0.0 || date.durationFrom(this.endDate) > 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.NO_TEC_DATA_IN_FILE_FOR_DATE, this.getSupportedNames(), date);
        }
    }

    private void checkSize() {
        if (this.tecMap.size() != this.nbMaps) {
            throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_NUMBER_OF_TEC_MAPS_IN_FILE, this.tecMap.size(), this.nbMaps);
        }
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.getSupportedNames());
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 201928052L;
        private final String supportedNames;

        DataTransferObject(String supportedNames) {
            this.supportedNames = supportedNames;
        }

        private Object readResolve() {
            try {
                return new GlobalIonosphereMapModel(this.supportedNames);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }

    private static class IONEXHeader {
        private AbsoluteDate firstDate;
        private AbsoluteDate lastDate;
        private int interval;
        private int nbOfMaps;
        private double baseRadius;
        private double hIon;
        private boolean isMappingFunction;

        IONEXHeader(AbsoluteDate firstDate, AbsoluteDate lastDate, int interval, int nbOfMaps, double baseRadius, double hIon, boolean mappingFunction) {
            this.firstDate = firstDate;
            this.lastDate = lastDate;
            this.interval = interval;
            this.nbOfMaps = nbOfMaps;
            this.baseRadius = baseRadius;
            this.hIon = hIon;
            this.isMappingFunction = mappingFunction;
        }

        public AbsoluteDate getFirstDate() {
            return this.firstDate;
        }

        public AbsoluteDate getLastDate() {
            return this.lastDate;
        }

        public int getInterval() {
            return this.interval;
        }

        public int getTECMapsNumer() {
            return this.nbOfMaps;
        }

        public double getEarthRadius() {
            return this.baseRadius;
        }

        public double getHIon() {
            return this.hIon;
        }

        public boolean isMappingFunction() {
            return this.isMappingFunction;
        }
    }

    private static class TECMap {
        private AbsoluteDate date;
        private double tec;

        TECMap(AbsoluteDate date, double tec) {
            this.date = date;
            this.tec = tec;
        }

        public AbsoluteDate getDate() {
            return this.date;
        }

        public double getTEC() {
            return this.tec;
        }
    }

    private class Parser
    implements DataLoader {
        private static final String END = "END OF TEC MAP";
        private static final String EPOCH = "EPOCH OF CURRENT MAP";
        private static final int LABEL_START = 60;
        private static final double KM_TO_M = 1000.0;
        private IONEXHeader header;
        private List<TECMap> maps;

        private Parser() {
        }

        @Override
        public boolean stillAcceptsData() {
            return true;
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException, ParseException {
            this.maps = new ArrayList<TECMap>();
            int lineNumber = 0;
            String line = null;
            try (InputStreamReader isr = new InputStreamReader(input, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(isr);){
                int interval = 3600;
                int nbOfMaps = 1;
                int exponent = -1;
                double baseRadius = 6371000.0;
                double hIon = 350000.0;
                boolean mappingF = false;
                boolean inTEC = false;
                double[] latitudes = null;
                double[] longitudes = null;
                AbsoluteDate firstEpoch = null;
                AbsoluteDate lastEpoch = null;
                AbsoluteDate epoch = firstEpoch;
                ArrayList<Double> values = new ArrayList<Double>();
                line = br.readLine();
                while (line != null) {
                    block52: {
                        block51: {
                            ++lineNumber;
                            if (line.length() <= 60) break block51;
                            switch (line.substring(60).trim()) {
                                case "EPOCH OF FIRST MAP": {
                                    firstEpoch = this.parseDate(line);
                                    break;
                                }
                                case "EPOCH OF LAST MAP": {
                                    lastEpoch = this.parseDate(line);
                                    break;
                                }
                                case "INTERVAL": {
                                    interval = this.parseInt(line, 2, 4);
                                    break;
                                }
                                case "# OF MAPS IN FILE": {
                                    nbOfMaps = this.parseInt(line, 2, 4);
                                    break;
                                }
                                case "BASE RADIUS": {
                                    baseRadius = this.parseDouble(line, 2, 6) * 1000.0;
                                    break;
                                }
                                case "MAPPING FUNCTION": {
                                    mappingF = !this.parseString(line, 2, 4).equals("NONE");
                                    break;
                                }
                                case "EXPONENT": {
                                    exponent = this.parseInt(line, 4, 2);
                                    break;
                                }
                                case "HGT1 / HGT2 / DHGT": {
                                    if (this.parseDouble(line, 17, 3) == 0.0) {
                                        hIon = this.parseDouble(line, 3, 5) * 1000.0;
                                        break;
                                    }
                                    break block52;
                                }
                                case "LAT1 / LAT2 / DLAT": {
                                    latitudes = this.parseCoordinate(line);
                                    break;
                                }
                                case "LON1 / LON2 / DLON": {
                                    longitudes = this.parseCoordinate(line);
                                    break;
                                }
                                case "END OF HEADER": {
                                    if (latitudes == null || longitudes == null) {
                                        throw new OrekitException((Localizable)OrekitMessages.NO_LATITUDE_LONGITUDE_BONDARIES_IN_IONEX_HEADER, GlobalIonosphereMapModel.this.getSupportedNames());
                                    }
                                    if (firstEpoch == null || lastEpoch == null) {
                                        throw new OrekitException((Localizable)OrekitMessages.NO_EPOCH_IN_IONEX_HEADER, GlobalIonosphereMapModel.this.getSupportedNames());
                                    }
                                    this.header = new IONEXHeader(firstEpoch, lastEpoch, interval, nbOfMaps, baseRadius, hIon, mappingF);
                                    break;
                                }
                                case "START OF TEC MAP": {
                                    inTEC = true;
                                    break;
                                }
                                case "END OF TEC MAP": {
                                    double tec = this.interpolateTEC(values, exponent, latitudes, longitudes);
                                    TECMap map = new TECMap(epoch, tec);
                                    this.maps.add(map);
                                    inTEC = false;
                                    values = new ArrayList();
                                    epoch = null;
                                    break;
                                }
                                default: {
                                    String[] readLine;
                                    if (!inTEC) break block52;
                                    if (line.endsWith(EPOCH)) {
                                        epoch = this.parseDate(line);
                                    }
                                    if (line.endsWith("LAT/LON1/LON2/DLON/H") || line.endsWith(END) || line.endsWith(EPOCH)) break block52;
                                    line = line.trim();
                                    for (String s : readLine = SEPARATOR.split(line)) {
                                        values.add(Double.valueOf(s));
                                    }
                                    break block52;
                                }
                            }
                            break block52;
                        }
                        if (inTEC) {
                            String[] readLine;
                            line = line.trim();
                            for (String s : readLine = SEPARATOR.split(line)) {
                                values.add(Double.valueOf(s));
                            }
                        }
                    }
                    line = br.readLine();
                }
                input.close();
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
            }
        }

        public IONEXHeader getIONEXHeader() {
            return this.header;
        }

        public List<TECMap> getTECMaps() {
            return this.maps;
        }

        private String parseString(String line, int start, int length) {
            return line.substring(start, FastMath.min((int)line.length(), (int)(start + length))).trim();
        }

        private int parseInt(String line, int start, int length) {
            return Integer.parseInt(this.parseString(line, start, length));
        }

        private double parseDouble(String line, int start, int length) {
            return Double.parseDouble(this.parseString(line, start, length));
        }

        private AbsoluteDate parseDate(String line) {
            return new AbsoluteDate(this.parseInt(line, 0, 6), this.parseInt(line, 6, 6), this.parseInt(line, 12, 6), this.parseInt(line, 18, 6), this.parseInt(line, 24, 6), this.parseDouble(line, 30, 13), GlobalIonosphereMapModel.this.utc);
        }

        private double[] parseCoordinate(String line) {
            double a = this.parseDouble(line, 2, 6);
            double b = this.parseDouble(line, 8, 6);
            double c = this.parseDouble(line, 14, 6);
            double[] coordinate = new double[(int)FastMath.abs((double)((a - b) / c)) + 1];
            int i = 0;
            for (double cor = FastMath.min((double)a, (double)b); cor <= FastMath.max((double)a, (double)b); cor += FastMath.abs((double)c)) {
                coordinate[i] = FastMath.toRadians((double)cor);
                ++i;
            }
            return coordinate;
        }

        private double interpolateTEC(ArrayList<Double> values, double exponent, double[] latitudes, double[] longitudes) {
            int dimLat = latitudes.length;
            int dimLon = longitudes.length;
            double[][] fvalTEC = new double[dimLat][dimLon];
            int index = dimLon * dimLat;
            for (int x = 0; x < dimLat; ++x) {
                for (int y = dimLon - 1; y >= 0; --y) {
                    fvalTEC[x][y] = values.get(--index);
                }
            }
            BilinearInterpolatingFunction functionTEC = new BilinearInterpolatingFunction(latitudes, longitudes, fvalTEC);
            double tec = functionTEC.value(GlobalIonosphereMapModel.this.latitude, GlobalIonosphereMapModel.this.longitude) * FastMath.pow((double)10.0, (double)exponent);
            return tec;
        }
    }
}

