/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.orekit.data.DataLoader;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.atmosphere.data.CommonLineReader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;

public class SOLFSMYDataLoader
implements DataLoader {
    private static final Pattern PATTERN_SPACE = Pattern.compile("\\s+");
    private final TimeScale utc;
    private AbsoluteDate firstDate;
    private AbsoluteDate lastDate;
    private SortedSet<LineParameters> set;

    public SOLFSMYDataLoader(TimeScale utc) {
        this.utc = utc;
        this.firstDate = null;
        this.lastDate = null;
        this.set = new TreeSet<TimeStamped>(new ChronologicalComparator());
    }

    public SortedSet<LineParameters> getDataSet() {
        return this.set;
    }

    public AbsoluteDate getMinDate() {
        return this.firstDate;
    }

    public AbsoluteDate getMaxDate() {
        return this.lastDate;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        int lineNumber = 0;
        String line = null;
        HashSet<AbsoluteDate> parsedEpochs = new HashSet<AbsoluteDate>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            CommonLineReader reader = new CommonLineReader(br);
            line = reader.readLine();
            while (line != null) {
                double julianSeconds;
                String[] splitLine;
                double julianDay;
                int julianDayInt;
                AbsoluteDate date;
                ++lineNumber;
                if (line.length() > 0 && line.charAt(0) != '#' && parsedEpochs.add(date = AbsoluteDate.createJDDate(julianDayInt = (int)(julianDay = Double.parseDouble((splitLine = PATTERN_SPACE.split(line))[3])), julianSeconds = (julianDay - (double)julianDayInt) * 86400.0, this.utc))) {
                    double f10 = Double.parseDouble(splitLine[4]);
                    double f10b = Double.parseDouble(splitLine[5]);
                    double s10 = Double.parseDouble(splitLine[6]);
                    double s10b = Double.parseDouble(splitLine[7]);
                    double xm10 = Double.parseDouble(splitLine[8]);
                    double xm10b = Double.parseDouble(splitLine[9]);
                    double y10 = Double.parseDouble(splitLine[10]);
                    double y10b = Double.parseDouble(splitLine[11]);
                    this.set.add(new LineParameters(date, f10, f10b, s10, s10b, xm10, xm10b, y10, y10b));
                }
                line = reader.readLine();
            }
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException(nfe, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
        try {
            this.firstDate = this.set.first().getDate();
            this.lastDate = this.set.last().getDate();
        }
        catch (NoSuchElementException nse) {
            throw new OrekitException(nse, OrekitMessages.NO_DATA_IN_FILE, name);
        }
    }

    @Override
    public boolean stillAcceptsData() {
        return true;
    }

    public static class LineParameters
    implements TimeStamped,
    Serializable {
        private static final long serialVersionUID = -9008818050532123587L;
        private final AbsoluteDate date;
        private final double f10;
        private final double f10b;
        private final double s10;
        private final double s10b;
        private final double xm10;
        private final double xm10b;
        private final double y10;
        private final double y10b;

        public LineParameters(AbsoluteDate date, double f10, double f10b, double s10, double s10b, double xm10, double xm10b, double y10, double y10b) {
            this.date = date;
            this.f10 = f10;
            this.f10b = f10b;
            this.s10 = s10;
            this.s10b = s10b;
            this.xm10 = xm10;
            this.xm10b = xm10b;
            this.y10 = y10;
            this.y10b = y10b;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public double getF10() {
            return this.f10;
        }

        public double getF10B() {
            return this.f10b;
        }

        public double getS10() {
            return this.s10;
        }

        public double getS10B() {
            return this.s10b;
        }

        public double getXM10() {
            return this.xm10;
        }

        public double getXM10B() {
            return this.xm10b;
        }

        public double getY10() {
            return this.y10;
        }

        public double getY10B() {
            return this.y10b;
        }
    }
}

