/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.messages.rtcm.ephemeris;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.metric.messages.rtcm.ephemeris.RtcmEphemerisData;
import org.orekit.propagation.analytical.gnss.data.GalileoNavigationMessage;
import org.orekit.time.GNSSDate;
import org.orekit.time.TimeScales;

public class Rtcm1045Data
extends RtcmEphemerisData {
    private GalileoNavigationMessage galileoNavigationMessage;
    private double galileoToc;
    private int galileoDataValidityStatus;

    @DefaultDataContext
    public GalileoNavigationMessage getGalileoNavigationMessage() {
        return this.getGalileoNavigationMessage(DataContext.getDefault().getTimeScales());
    }

    public GalileoNavigationMessage getGalileoNavigationMessage(TimeScales timeScales) {
        SatelliteSystem system = SatelliteSystem.GALILEO;
        int week = this.galileoNavigationMessage.getWeek();
        double toe = this.galileoNavigationMessage.getTime();
        this.galileoNavigationMessage.setDate(new GNSSDate(week, 1000.0 * toe, system, timeScales).getDate());
        this.galileoNavigationMessage.setEpochToc(new GNSSDate(week, 1000.0 * this.galileoToc, system, timeScales).getDate());
        return this.galileoNavigationMessage;
    }

    public void setGalileoNavigationMessage(GalileoNavigationMessage galileoNavigationMessage) {
        this.galileoNavigationMessage = galileoNavigationMessage;
    }

    public double getGalileoToc() {
        return this.galileoToc;
    }

    public void setGalileoToc(double toc) {
        this.galileoToc = toc;
    }

    public int getGalileoDataValidityStatus() {
        return this.galileoDataValidityStatus;
    }

    public void setGalileoDataValidityStatus(int galileoDataValidityStatus) {
        this.galileoDataValidityStatus = galileoDataValidityStatus;
    }
}

