/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.util.function.Supplier;
import org.orekit.bodies.CelestialBodies;
import org.orekit.frames.AbstractFrames;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.frames.Frame;
import org.orekit.frames.ITRFVersion;
import org.orekit.frames.Predefined;
import org.orekit.frames.VersionedITRF;
import org.orekit.time.TimeScales;
import org.orekit.utils.IERSConventions;

public interface Frames {
    public EOPHistory getEOPHistory(IERSConventions var1, boolean var2);

    public Frame getFrame(Predefined var1);

    public Frame getGCRF();

    public Frame getICRF();

    public Frame getEcliptic(IERSConventions var1);

    public FactoryManagedFrame getEME2000();

    public FactoryManagedFrame getITRF(IERSConventions var1, boolean var2);

    public FactoryManagedFrame getTIRF(IERSConventions var1);

    public VersionedITRF getITRF(ITRFVersion var1, IERSConventions var2, boolean var3);

    public FactoryManagedFrame getTIRF(IERSConventions var1, boolean var2);

    public FactoryManagedFrame getCIRF(IERSConventions var1, boolean var2);

    public FactoryManagedFrame getVeis1950();

    public FactoryManagedFrame getITRFEquinox(IERSConventions var1, boolean var2);

    public FactoryManagedFrame getGTOD(boolean var1);

    public FactoryManagedFrame getGTOD(IERSConventions var1, boolean var2);

    public FactoryManagedFrame getTOD(boolean var1);

    public FactoryManagedFrame getTOD(IERSConventions var1, boolean var2);

    public FactoryManagedFrame getMOD(boolean var1);

    public FactoryManagedFrame getMOD(IERSConventions var1);

    public FactoryManagedFrame getTEME();

    public FactoryManagedFrame getPZ9011(IERSConventions var1, boolean var2);

    public static Frames of(TimeScales timeScales, CelestialBodies celestialBodies) {
        return Frames.of(timeScales, () -> celestialBodies.getSolarSystemBarycenter().getInertiallyOrientedFrame());
    }

    public static Frames of(TimeScales timeScales, Supplier<Frame> icrfSupplier) {
        return new AbstractFrames(timeScales, (Supplier)icrfSupplier){

            @Override
            public EOPHistory getEOPHistory(IERSConventions conventions, boolean simpleEOP) {
                return this.getTimeScales().getUT1(conventions, simpleEOP).getEOPHistory();
            }
        };
    }
}

