/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2Field;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2Field;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.bodies.CelestialBody;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

class CR3BPRotatingTransformProvider
implements TransformProvider {
    private static final long serialVersionUID = 20190519L;
    private final Frame frame;
    private final CelestialBody secondaryBody;
    private final double mu;

    CR3BPRotatingTransformProvider(double mu, CelestialBody primaryBody, CelestialBody secondaryBody) {
        this.secondaryBody = secondaryBody;
        this.frame = primaryBody.getInertiallyOrientedFrame();
        this.mu = mu;
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        FieldPVCoordinates<UnivariateDerivative2> pv21 = this.secondaryBody.getPVCoordinates(date, this.frame).toUnivariateDerivative2PV();
        UnivariateDerivative2Field field = ((UnivariateDerivative2)pv21.getPosition().getX()).getField();
        FieldVector3D translation = FieldVector3D.getPlusI((Field)field).scalarMultiply((CalculusFieldElement)((UnivariateDerivative2)pv21.getPosition().getNorm()).multiply(this.mu)).negate();
        FieldRotation rotation = new FieldRotation(pv21.getPosition(), pv21.getMomentum(), FieldVector3D.getPlusI((Field)field), FieldVector3D.getPlusK((Field)field));
        UnivariateDerivative2[] rotationRates = (UnivariateDerivative2[])rotation.getAngles(RotationOrder.XYZ, RotationConvention.FRAME_TRANSFORM);
        Vector3D rotationRate = new Vector3D(rotationRates[0].getPartialDerivative(new int[]{1}), rotationRates[1].getPartialDerivative(new int[]{1}), rotationRates[2].getPartialDerivative(new int[]{1}));
        Vector3D rotationAcc = new Vector3D(rotationRates[0].getPartialDerivative(new int[]{2}), rotationRates[1].getPartialDerivative(new int[]{2}), rotationRates[2].getPartialDerivative(new int[]{2}));
        Vector3D velocity = new Vector3D(((UnivariateDerivative2)translation.getX()).getPartialDerivative(new int[]{1}), ((UnivariateDerivative2)translation.getY()).getPartialDerivative(new int[]{1}), ((UnivariateDerivative2)translation.getZ()).getPartialDerivative(new int[]{1}));
        Vector3D acceleration = new Vector3D(((UnivariateDerivative2)translation.getX()).getPartialDerivative(new int[]{2}), ((UnivariateDerivative2)translation.getY()).getPartialDerivative(new int[]{2}), ((UnivariateDerivative2)translation.getZ()).getPartialDerivative(new int[]{2}));
        Transform transform1 = new Transform(date, translation.toVector3D(), velocity, acceleration);
        Transform transform2 = new Transform(date, rotation.toRotation(), rotationRate, rotationAcc);
        return new Transform(date, transform2, transform1);
    }

    @Override
    public StaticTransform getStaticTransform(AbsoluteDate date) {
        TimeStampedPVCoordinates pv = this.secondaryBody.getPVCoordinates(date, this.frame);
        Vector3D translation = Vector3D.PLUS_I.scalarMultiply(pv.getPosition().getNorm() * this.mu).negate();
        Rotation rotation = new Rotation(pv.getPosition(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_K);
        StaticTransform transform1 = StaticTransform.of(date, translation);
        StaticTransform transform2 = StaticTransform.of(date, rotation);
        return StaticTransform.compose(date, transform2, transform1);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        TimeStampedFieldPVCoordinates<T> pv21 = this.secondaryBody.getPVCoordinates(date, this.frame);
        Field field = pv21.getPosition().getX().getField();
        FieldVector3D translationField = FieldVector3D.getPlusI((Field)field).scalarMultiply((CalculusFieldElement)pv21.getPosition().getNorm().multiply(this.mu)).negate();
        FieldRotation rotationField = new FieldRotation(pv21.getPosition(), pv21.getMomentum(), FieldVector3D.getPlusI((Field)field), FieldVector3D.getPlusK((Field)field));
        FieldPVCoordinates pv21FDS = this.secondaryBody.getPVCoordinates(date, this.frame).toUnivariateDerivative2PV();
        FieldUnivariateDerivative2Field fieldUD = ((FieldUnivariateDerivative2)pv21FDS.getPosition().getX()).getField();
        FieldVector3D translationFDS = FieldVector3D.getPlusI((Field)fieldUD).scalarMultiply((CalculusFieldElement)((FieldUnivariateDerivative2)pv21FDS.getPosition().getNorm()).multiply(this.mu)).negate();
        FieldRotation rotationFDS = new FieldRotation(pv21FDS.getPosition(), pv21FDS.getMomentum(), FieldVector3D.getPlusI((Field)fieldUD), FieldVector3D.getPlusK((Field)fieldUD));
        FieldUnivariateDerivative2[] rotationRates = (FieldUnivariateDerivative2[])rotationFDS.getAngles(RotationOrder.XYZ, RotationConvention.FRAME_TRANSFORM);
        FieldVector3D rotationRate = new FieldVector3D(rotationRates[0].getPartialDerivative(new int[]{1}), rotationRates[1].getPartialDerivative(new int[]{1}), rotationRates[2].getPartialDerivative(new int[]{1}));
        FieldVector3D rotationAcc = new FieldVector3D(rotationRates[0].getPartialDerivative(new int[]{2}), rotationRates[1].getPartialDerivative(new int[]{2}), rotationRates[2].getPartialDerivative(new int[]{2}));
        FieldVector3D velocity = new FieldVector3D(((FieldUnivariateDerivative2)translationFDS.getX()).getPartialDerivative(new int[]{1}), ((FieldUnivariateDerivative2)translationFDS.getY()).getPartialDerivative(new int[]{1}), ((FieldUnivariateDerivative2)translationFDS.getZ()).getPartialDerivative(new int[]{1}));
        FieldVector3D acceleration = new FieldVector3D(((FieldUnivariateDerivative2)translationFDS.getX()).getPartialDerivative(new int[]{2}), ((FieldUnivariateDerivative2)translationFDS.getY()).getPartialDerivative(new int[]{2}), ((FieldUnivariateDerivative2)translationFDS.getZ()).getPartialDerivative(new int[]{2}));
        FieldTransform<T> transform1 = new FieldTransform<T>(date, translationField, velocity, acceleration);
        FieldTransform<T> transform2 = new FieldTransform<T>(date, rotationField, rotationRate, rotationAcc);
        return new FieldTransform<T>(date, transform2, transform1);
    }
}

