/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.empirical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.forces.empirical.AccelerationModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class HarmonicAccelerationModel
implements AccelerationModel {
    private static final double AMPLITUDE_SCALE = FastMath.scalb((double)1.0, (int)-20);
    private static final double PHASE_SCALE = FastMath.scalb((double)1.0, (int)-23);
    private final List<ParameterDriver> drivers;
    private AbsoluteDate referenceDate;
    private final double omega;

    public HarmonicAccelerationModel(String prefix, AbsoluteDate referenceDate, double fundamentalPeriod, int harmonicMultiplier) {
        this.referenceDate = referenceDate;
        this.omega = (double)harmonicMultiplier * (Math.PI * 2) / fundamentalPeriod;
        this.drivers = new ArrayList<ParameterDriver>(2);
        this.drivers.add(new ParameterDriver(prefix + " \u03b3", 0.0, AMPLITUDE_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        this.drivers.add(new ParameterDriver(prefix + " \u03c6", 0.0, PHASE_SCALE, Math.PI * -2, Math.PI * 2));
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        if (this.referenceDate == null) {
            this.referenceDate = initialState.getDate();
        }
    }

    @Override
    public double signedAmplitude(SpacecraftState state, double[] parameters) {
        double dt = state.getDate().durationFrom(this.referenceDate);
        return parameters[0] * FastMath.sin((double)(dt * this.omega + parameters[1]));
    }

    @Override
    public <T extends CalculusFieldElement<T>> T signedAmplitude(FieldSpacecraftState<T> state, T[] parameters) {
        T dt = state.getDate().durationFrom(this.referenceDate);
        return (T)((CalculusFieldElement)parameters[0].multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dt.multiply(this.omega)).add(parameters[1])).sin())));
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.unmodifiableList(this.drivers);
    }
}

