/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class IsotropicDrag
implements DragSensitive {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-3);
    private final ParameterDriver dragParametersDrivers;
    private final double crossSection;

    public IsotropicDrag(double crossSection, double dragCoeff) {
        this(crossSection, dragCoeff, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public IsotropicDrag(double crossSection, double dragCoeff, double dragCoeffMin, double dragCoeffMax) {
        this.dragParametersDrivers = new ParameterDriver("drag coefficient", dragCoeff, this.SCALE, dragCoeffMin, dragCoeffMax);
        this.crossSection = crossSection;
    }

    @Override
    public List<ParameterDriver> getDragParametersDrivers() {
        return Collections.singletonList(this.dragParametersDrivers);
    }

    @Override
    public Vector3D dragAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, double density, Vector3D relativeVelocity, double[] parameters) {
        double dragCoeff = parameters[0];
        return new Vector3D(relativeVelocity.getNorm() * density * dragCoeff * this.crossSection / (2.0 * mass), relativeVelocity);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> dragAcceleration(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation, T mass, T density, FieldVector3D<T> relativeVelocity, T[] parameters) {
        T dragCoeff = parameters[0];
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)relativeVelocity.getNorm().multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)density.multiply(dragCoeff)).multiply(this.crossSection / 2.0)))).divide(mass), relativeVelocity);
    }
}

