/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.utils.lexical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.bodies.CelestialBodies;
import org.orekit.bodies.CelestialBody;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.BodyFacade;
import org.orekit.files.ccsds.definitions.CenterName;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.units.Unit;

public class ParseToken {
    private static final Pattern DASH = Pattern.compile("-");
    private static final Pattern SPACE = Pattern.compile("\\p{Space}+");
    private static final Pattern SPLIT_AT_COMMAS = Pattern.compile("\\p{Space}*,\\p{Space}*");
    private static final Pattern BOOLEAN_TRUE = Pattern.compile("(?:yes)|(?:true)", 66);
    private static final Pattern BOOLEAN_FALSE = Pattern.compile("(?:no)|(?:false)", 66);
    private TokenType type;
    private final String name;
    private final String content;
    private final Unit units;
    private final int lineNumber;
    private final String fileName;

    public ParseToken(TokenType type, String name, String content, Unit units, int lineNumber, String fileName) {
        this.type = type;
        this.name = name;
        this.content = content;
        this.units = units;
        this.lineNumber = lineNumber;
        this.fileName = fileName;
    }

    public TokenType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getRawContent() {
        return this.content;
    }

    public String getContentAsNormalizedString() {
        return SPACE.matcher(this.content.replace('_', ' ')).replaceAll(" ").trim();
    }

    public List<String> getContentAsNormalizedList() {
        return Arrays.asList(SPLIT_AT_COMMAS.split(this.getContentAsNormalizedString()));
    }

    public String getContentAsUppercaseString() {
        return this.getContentAsNormalizedString().toUpperCase(Locale.US);
    }

    public List<String> getContentAsUppercaseList() {
        return Arrays.asList(SPLIT_AT_COMMAS.split(this.getContentAsUppercaseString()));
    }

    public <T extends Enum<T>> T getContentAsEnum(Class<T> cls) {
        return this.toEnum(cls, this.getRawContent());
    }

    public <T extends Enum<T>> List<T> getContentAsEnumList(Class<T> cls) {
        String[] elements = SPLIT_AT_COMMAS.split(this.getRawContent());
        ArrayList<T> list = new ArrayList<T>(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            list.add(this.toEnum(cls, elements[i]));
        }
        return list;
    }

    public double getContentAsDouble() {
        try {
            return Double.parseDouble(this.content);
        }
        catch (NumberFormatException nfe) {
            throw this.generateException(nfe);
        }
    }

    public Vector3D getContentAsVector() {
        try {
            String[] fields = SPACE.split(this.content);
            if (fields.length == 3) {
                return new Vector3D(Double.parseDouble(fields[0]), Double.parseDouble(fields[1]), Double.parseDouble(fields[2]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw this.generateException(null);
    }

    public boolean getContentAsBoolean() {
        if (BOOLEAN_TRUE.matcher(this.content).matches()) {
            return true;
        }
        if (BOOLEAN_FALSE.matcher(this.content).matches()) {
            return false;
        }
        throw this.generateException(null);
    }

    public int getContentAsInt() {
        try {
            return Integer.parseInt(this.content);
        }
        catch (NumberFormatException nfe) {
            throw this.generateException(nfe);
        }
    }

    public char getContentAsUppercaseCharacter() {
        try {
            return this.getContentAsUppercaseString().charAt(0);
        }
        catch (NumberFormatException nfe) {
            throw this.generateException(nfe);
        }
    }

    public Unit getUnits() {
        return this.units;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean processAsNormalizedString(StringConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(this.getContentAsNormalizedString());
        }
        return true;
    }

    public boolean processAsUppercaseString(StringConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(this.getContentAsUppercaseString());
        }
        return true;
    }

    public boolean processAsIndexedNormalizedString(int index, IndexedStringConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(index, this.getContentAsNormalizedString());
        }
        return true;
    }

    public boolean processAsIndexedUppercaseString(int index, IndexedStringConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(index, this.getContentAsUppercaseString());
        }
        return true;
    }

    public boolean processAsNormalizedList(StringListConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(this.getContentAsNormalizedList());
        }
        return true;
    }

    public boolean processAsUppercaseList(StringListConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(this.getContentAsUppercaseList());
        }
        return true;
    }

    public <T extends Enum<T>> boolean processAsEnum(Class<T> cls, EnumConsumer<T> consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(this.getContentAsEnum(cls));
        }
        return true;
    }

    public <T extends Enum<T>> boolean processAsEnumsList(Class<T> cls, EnumListConsumer<T> consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(this.getContentAsEnumList(cls));
        }
        return true;
    }

    public boolean processAsBoolean(BooleanConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(this.getContentAsBoolean());
        }
        return true;
    }

    public boolean processAsInteger(IntConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(this.getContentAsInt());
        }
        return true;
    }

    public boolean processAsIntegerArray(IntegerArrayConsumer consumer) {
        try {
            if (this.type == TokenType.ENTRY) {
                String[] fields = SPLIT_AT_COMMAS.split(this.getRawContent());
                int[] integers = new int[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    integers[i] = Integer.parseInt(fields[i]);
                }
                consumer.accept(integers);
            }
            return true;
        }
        catch (NumberFormatException nfe) {
            throw this.generateException(nfe);
        }
    }

    public boolean processAsNormalizedCharacter(CharConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(this.getContentAsUppercaseCharacter());
        }
        return true;
    }

    public boolean processAsDouble(Unit standard, ParsedUnitsBehavior behavior, DoubleConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(behavior.select(this.getUnits(), standard).toSI(this.getContentAsDouble()));
        }
        return true;
    }

    public boolean processAsLabeledDouble(char label, Unit standard, ParsedUnitsBehavior behavior, LabeledDoubleConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(label, behavior.select(this.getUnits(), standard).toSI(this.getContentAsDouble()));
        }
        return true;
    }

    public boolean processAsIndexedDouble(int i, Unit standard, ParsedUnitsBehavior behavior, IndexedDoubleConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(i, behavior.select(this.getUnits(), standard).toSI(this.getContentAsDouble()));
        }
        return true;
    }

    public boolean processAsDoublyIndexedDouble(int i, int j, Unit standard, ParsedUnitsBehavior behavior, DoublyIndexedDoubleConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(i, j, behavior.select(this.getUnits(), standard).toSI(this.getContentAsDouble()));
        }
        return true;
    }

    public boolean processAsVector(VectorConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(this.getContentAsVector());
        }
        return true;
    }

    public boolean processAsDate(DateConsumer consumer, ContextBinding context) {
        if (this.type == TokenType.ENTRY) {
            if (context.getTimeSystem() == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_TIME_SYSTEM_NOT_READ_YET, this.getLineNumber(), this.getFileName());
            }
            consumer.accept(context.getTimeSystem().getConverter(context).parse(this.content));
        }
        return true;
    }

    public boolean processAsTimeSystem(TimeSystemConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            consumer.accept(TimeSystem.parse(this.getContentAsUppercaseString()));
        }
        return true;
    }

    public boolean processAsFrame(FrameConsumer consumer, ContextBinding context, boolean allowCelestial, boolean allowOrbit, boolean allowSpacecraft) {
        if (this.type == TokenType.ENTRY) {
            try {
                consumer.accept(FrameFacade.parse(DASH.matcher(this.getContentAsUppercaseString()).replaceAll("").replace(' ', '_'), context.getConventions(), context.isSimpleEOP(), context.getDataContext(), allowCelestial, allowOrbit, allowSpacecraft));
            }
            catch (OrekitException oe) {
                throw this.generateException(oe);
            }
        }
        return true;
    }

    public boolean processAsCenter(CenterConsumer consumer, CelestialBodies celestialBodies) {
        if (this.type == TokenType.ENTRY) {
            String centerName = this.getContentAsUppercaseString();
            consumer.accept(new BodyFacade(centerName, this.body(centerName, celestialBodies)));
        }
        return true;
    }

    public boolean processAsCenterList(CenterListConsumer consumer, CelestialBodies celestialBodies) {
        if (this.type == TokenType.ENTRY) {
            ArrayList<BodyFacade> facades = new ArrayList<BodyFacade>();
            for (String centerName : SPLIT_AT_COMMAS.split(this.getContentAsUppercaseString())) {
                facades.add(new BodyFacade(centerName, this.body(centerName, celestialBodies)));
            }
            consumer.accept(facades);
        }
        return true;
    }

    public boolean processAsUnitList(UnitListConsumer consumer) {
        if (this.type == TokenType.ENTRY) {
            String bracketed = this.getContentAsNormalizedString();
            if (bracketed.charAt(0) != '[' || bracketed.charAt(bracketed.length() - 1) != ']') {
                throw this.generateException(null);
            }
            String unbracketed = bracketed.substring(1, bracketed.length() - 1).trim();
            try {
                consumer.accept(Stream.of(SPLIT_AT_COMMAS.split(unbracketed)).map(s -> Unit.parse(s)).collect(Collectors.toList()));
            }
            catch (OrekitException oe) {
                throw this.generateException(oe);
            }
        }
        return true;
    }

    public OrekitException generateException(Exception cause) {
        return new OrekitException(cause, OrekitMessages.UNABLE_TO_PARSE_ELEMENT_IN_FILE, this.getName(), this.getLineNumber(), this.getFileName());
    }

    private CelestialBody body(String centerName, CelestialBodies celestialBodies) {
        String canonicalValue = centerName.equals("SOLAR SYSTEM BARYCENTER") || centerName.equals("SSB") ? "SOLAR_SYSTEM_BARYCENTER" : (centerName.equals("EARTH MOON BARYCENTER") || centerName.equals("EARTH-MOON BARYCENTER") || centerName.equals("EARTH BARYCENTER") || centerName.equals("EMB") ? "EARTH_MOON" : centerName);
        try {
            return CenterName.valueOf(canonicalValue).getCelestialBody(celestialBodies);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private <T extends Enum<T>> T toEnum(Class<T> cls, String value) {
        String noSpace = value.replace(' ', '_');
        try {
            return Enum.valueOf(cls, noSpace);
        }
        catch (IllegalArgumentException iae1) {
            try {
                return Enum.valueOf(cls, noSpace.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException iae2) {
                throw this.generateException(iae1);
            }
        }
    }

    public static interface UnitListConsumer {
        public void accept(List<Unit> var1);
    }

    public static interface CenterListConsumer {
        public void accept(List<BodyFacade> var1);
    }

    public static interface CenterConsumer {
        public void accept(BodyFacade var1);
    }

    public static interface FrameConsumer {
        public void accept(FrameFacade var1);
    }

    public static interface TimeSystemConsumer {
        public void accept(TimeSystem var1);
    }

    public static interface DateConsumer {
        public void accept(AbsoluteDate var1);
    }

    public static interface VectorConsumer {
        public void accept(Vector3D var1);
    }

    public static interface DoublyIndexedDoubleConsumer {
        public void accept(int var1, int var2, double var3);
    }

    public static interface IndexedDoubleConsumer {
        public void accept(int var1, double var2);
    }

    public static interface LabeledDoubleConsumer {
        public void accept(char var1, double var2);
    }

    public static interface DoubleConsumer {
        public void accept(double var1);
    }

    public static interface CharConsumer {
        public void accept(char var1);
    }

    public static interface IntegerArrayConsumer {
        public void accept(int[] var1);
    }

    public static interface IntConsumer {
        public void accept(int var1);
    }

    public static interface BooleanConsumer {
        public void accept(boolean var1);
    }

    public static interface EnumListConsumer<T extends Enum<T>> {
        public void accept(List<T> var1);
    }

    public static interface EnumConsumer<T extends Enum<T>> {
        public void accept(T var1);
    }

    public static interface StringListConsumer {
        public void accept(List<String> var1);
    }

    public static interface IndexedStringConsumer {
        public void accept(int var1, String var2);
    }

    public static interface StringConsumer {
        public void accept(String var1);
    }
}

