/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.utils;

import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class ContextBinding {
    private final Supplier<ParsedUnitsBehavior> behaviorSupplier;
    private final Supplier<IERSConventions> conventionsSupplier;
    private final BooleanSupplier simpleEOPSupplier;
    private final Supplier<DataContext> dataContextSupplier;
    private final Supplier<AbsoluteDate> referenceDateSupplier;
    private final Supplier<TimeSystem> timeSystemSupplier;
    private final DoubleSupplier clockCountSupplier;
    private final DoubleSupplier clockRateSupplier;

    public ContextBinding(Supplier<IERSConventions> conventionsSupplier, BooleanSupplier simpleEOPSupplier, Supplier<DataContext> dataContextSupplier, Supplier<ParsedUnitsBehavior> behaviorSupplier, Supplier<AbsoluteDate> referenceDateSupplier, Supplier<TimeSystem> timeSystemSupplier, DoubleSupplier clockCountSupplier, DoubleSupplier clockRateSupplier) {
        this.behaviorSupplier = behaviorSupplier;
        this.conventionsSupplier = conventionsSupplier;
        this.simpleEOPSupplier = simpleEOPSupplier;
        this.dataContextSupplier = dataContextSupplier;
        this.referenceDateSupplier = referenceDateSupplier;
        this.timeSystemSupplier = timeSystemSupplier;
        this.clockCountSupplier = clockCountSupplier;
        this.clockRateSupplier = clockRateSupplier;
    }

    public ParsedUnitsBehavior getParsedUnitsBehavior() {
        return this.behaviorSupplier.get();
    }

    public IERSConventions getConventions() {
        return this.conventionsSupplier.get();
    }

    public boolean isSimpleEOP() {
        return this.simpleEOPSupplier.getAsBoolean();
    }

    public DataContext getDataContext() {
        return this.dataContextSupplier.get();
    }

    public AbsoluteDate getReferenceDate() {
        return this.referenceDateSupplier.get();
    }

    public TimeSystem getTimeSystem() {
        return this.timeSystemSupplier.get();
    }

    public double getClockCount() {
        return this.clockCountSupplier.getAsDouble();
    }

    public double getClockRate() {
        return this.clockRateSupplier.getAsDouble();
    }
}

