/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.omm;

import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.omm.OmmTle;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;

public enum OmmTleKey {
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    EPHEMERIS_TYPE((token, context, container) -> token.processAsInteger(container::setEphemerisType)),
    CLASSIFICATION_TYPE((token, context, container) -> token.processAsNormalizedCharacter(container::setClassificationType)),
    NORAD_CAT_ID((token, context, container) -> token.processAsInteger(container::setNoradID)),
    ELEMENT_SET_NO((token, context, container) -> token.processAsInteger(container::setElementSetNo)),
    REV_AT_EPOCH((token, context, container) -> token.processAsInteger(container::setRevAtEpoch)),
    BSTAR((token, context, container) -> token.processAsDouble(Units.ONE_PER_ER, context.getParsedUnitsBehavior(), container::setBStar)),
    MEAN_MOTION_DOT((token, context, container) -> token.processAsDouble(Units.REV_PER_DAY2_SCALED, context.getParsedUnitsBehavior(), container::setMeanMotionDot)),
    MEAN_MOTION_DDOT((token, context, container) -> token.processAsDouble(Units.REV_PER_DAY3_SCALED, context.getParsedUnitsBehavior(), container::setMeanMotionDotDot));

    private final TokenProcessor processor;

    private OmmTleKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, OmmTle container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, OmmTle var3);
    }
}

