/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.cdm.RTNCovariance;
import org.orekit.files.ccsds.ndm.cdm.RTNCovarianceKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;

public class RTNCovarianceWriter
extends AbstractWriter {
    private final RTNCovariance rtnCovariance;

    RTNCovarianceWriter(String xmlTag, String kvnTag, RTNCovariance RTNCovariance2) {
        super(xmlTag, kvnTag);
        this.rtnCovariance = RTNCovariance2;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.rtnCovariance.getComments());
        generator.writeEntry(RTNCovarianceKey.CR_R.name(), this.rtnCovariance.getCrr(), Units.M2, true);
        generator.writeEntry(RTNCovarianceKey.CT_R.name(), this.rtnCovariance.getCtr(), Units.M2, true);
        generator.writeEntry(RTNCovarianceKey.CT_T.name(), this.rtnCovariance.getCtt(), Units.M2, true);
        generator.writeEntry(RTNCovarianceKey.CN_R.name(), this.rtnCovariance.getCnr(), Units.M2, true);
        generator.writeEntry(RTNCovarianceKey.CN_T.name(), this.rtnCovariance.getCnt(), Units.M2, true);
        generator.writeEntry(RTNCovarianceKey.CN_N.name(), this.rtnCovariance.getCnn(), Units.M2, true);
        generator.writeEntry(RTNCovarianceKey.CRDOT_R.name(), this.rtnCovariance.getCrdotr(), Units.M2_PER_S, true);
        generator.writeEntry(RTNCovarianceKey.CRDOT_T.name(), this.rtnCovariance.getCrdott(), Units.M2_PER_S, true);
        generator.writeEntry(RTNCovarianceKey.CRDOT_N.name(), this.rtnCovariance.getCrdotn(), Units.M2_PER_S, true);
        generator.writeEntry(RTNCovarianceKey.CRDOT_RDOT.name(), this.rtnCovariance.getCrdotrdot(), Units.M2_PER_S2, true);
        generator.writeEntry(RTNCovarianceKey.CTDOT_R.name(), this.rtnCovariance.getCtdotr(), Units.M2_PER_S, true);
        generator.writeEntry(RTNCovarianceKey.CTDOT_T.name(), this.rtnCovariance.getCtdott(), Units.M2_PER_S, true);
        generator.writeEntry(RTNCovarianceKey.CTDOT_N.name(), this.rtnCovariance.getCtdotn(), Units.M2_PER_S, true);
        generator.writeEntry(RTNCovarianceKey.CTDOT_RDOT.name(), this.rtnCovariance.getCtdotrdot(), Units.M2_PER_S2, true);
        generator.writeEntry(RTNCovarianceKey.CTDOT_TDOT.name(), this.rtnCovariance.getCtdottdot(), Units.M2_PER_S2, true);
        generator.writeEntry(RTNCovarianceKey.CNDOT_R.name(), this.rtnCovariance.getCndotr(), Units.M2_PER_S, true);
        generator.writeEntry(RTNCovarianceKey.CNDOT_T.name(), this.rtnCovariance.getCndott(), Units.M2_PER_S, true);
        generator.writeEntry(RTNCovarianceKey.CNDOT_N.name(), this.rtnCovariance.getCndotn(), Units.M2_PER_S, true);
        generator.writeEntry(RTNCovarianceKey.CNDOT_RDOT.name(), this.rtnCovariance.getCndotrdot(), Units.M2_PER_S2, true);
        generator.writeEntry(RTNCovarianceKey.CNDOT_TDOT.name(), this.rtnCovariance.getCndottdot(), Units.M2_PER_S2, true);
        generator.writeEntry(RTNCovarianceKey.CNDOT_NDOT.name(), this.rtnCovariance.getCndotndot(), Units.M2_PER_S2, true);
        generator.writeEntry(RTNCovarianceKey.CDRG_R.name(), this.rtnCovariance.getCdrgr(), Units.M3_PER_KG, false);
        generator.writeEntry(RTNCovarianceKey.CDRG_T.name(), this.rtnCovariance.getCdrgt(), Units.M3_PER_KG, false);
        generator.writeEntry(RTNCovarianceKey.CDRG_N.name(), this.rtnCovariance.getCdrgn(), Units.M3_PER_KG, false);
        generator.writeEntry(RTNCovarianceKey.CDRG_RDOT.name(), this.rtnCovariance.getCdrgrdot(), Units.M3_PER_KGS, false);
        generator.writeEntry(RTNCovarianceKey.CDRG_TDOT.name(), this.rtnCovariance.getCdrgtdot(), Units.M3_PER_KGS, false);
        generator.writeEntry(RTNCovarianceKey.CDRG_NDOT.name(), this.rtnCovariance.getCdrgndot(), Units.M3_PER_KGS, false);
        generator.writeEntry(RTNCovarianceKey.CDRG_DRG.name(), this.rtnCovariance.getCdrgdrg(), Units.M4_PER_KG2, false);
        generator.writeEntry(RTNCovarianceKey.CSRP_R.name(), this.rtnCovariance.getCsrpr(), Units.M3_PER_KG, false);
        generator.writeEntry(RTNCovarianceKey.CSRP_T.name(), this.rtnCovariance.getCsrpt(), Units.M3_PER_KG, false);
        generator.writeEntry(RTNCovarianceKey.CSRP_N.name(), this.rtnCovariance.getCsrpn(), Units.M3_PER_KG, false);
        generator.writeEntry(RTNCovarianceKey.CSRP_RDOT.name(), this.rtnCovariance.getCsrprdot(), Units.M3_PER_KGS, false);
        generator.writeEntry(RTNCovarianceKey.CSRP_TDOT.name(), this.rtnCovariance.getCsrptdot(), Units.M3_PER_KGS, false);
        generator.writeEntry(RTNCovarianceKey.CSRP_NDOT.name(), this.rtnCovariance.getCsrpndot(), Units.M3_PER_KGS, false);
        generator.writeEntry(RTNCovarianceKey.CSRP_DRG.name(), this.rtnCovariance.getCsrpdrg(), Units.M4_PER_KG2, false);
        generator.writeEntry(RTNCovarianceKey.CSRP_SRP.name(), this.rtnCovariance.getCsrpsrp(), Units.M4_PER_KG2, false);
        generator.writeEntry(RTNCovarianceKey.CTHR_R.name(), this.rtnCovariance.getCthrr(), Units.M2_PER_S2, false);
        generator.writeEntry(RTNCovarianceKey.CTHR_T.name(), this.rtnCovariance.getCthrt(), Units.M2_PER_S2, false);
        generator.writeEntry(RTNCovarianceKey.CTHR_N.name(), this.rtnCovariance.getCthrn(), Units.M2_PER_S2, false);
        generator.writeEntry(RTNCovarianceKey.CTHR_RDOT.name(), this.rtnCovariance.getCthrrdot(), Units.M2_PER_S3, false);
        generator.writeEntry(RTNCovarianceKey.CTHR_TDOT.name(), this.rtnCovariance.getCthrtdot(), Units.M2_PER_S3, false);
        generator.writeEntry(RTNCovarianceKey.CTHR_NDOT.name(), this.rtnCovariance.getCthrndot(), Units.M2_PER_S3, false);
        generator.writeEntry(RTNCovarianceKey.CTHR_DRG.name(), this.rtnCovariance.getCthrdrg(), Units.M3_PER_KGS2, false);
        generator.writeEntry(RTNCovarianceKey.CTHR_SRP.name(), this.rtnCovariance.getCthrsrp(), Units.M3_PER_KGS2, false);
        generator.writeEntry(RTNCovarianceKey.CTHR_THR.name(), this.rtnCovariance.getCthrthr(), Units.M2_PER_S4, false);
    }
}

