/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import org.orekit.files.ccsds.definitions.PocMethodFacade;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.cdm.CdmRelativeMetadata;
import org.orekit.files.ccsds.ndm.cdm.ScreenVolumeFrame;
import org.orekit.files.ccsds.ndm.cdm.ScreenVolumeShape;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;

public enum CdmRelativeMetadataKey {
    TCA((token, context, container) -> token.processAsDate(container::setTca, context)),
    MISS_DISTANCE((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setMissDistance)),
    RELATIVE_SPEED((token, context, container) -> token.processAsDouble(Units.M_PER_S, context.getParsedUnitsBehavior(), container::setRelativeSpeed)),
    RELATIVE_POSITION_R((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setRelativePositionR)),
    RELATIVE_POSITION_T((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setRelativePositionT)),
    RELATIVE_POSITION_N((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setRelativePositionN)),
    RELATIVE_VELOCITY_R((token, context, container) -> token.processAsDouble(Units.M_PER_S, context.getParsedUnitsBehavior(), container::setRelativeVelocityR)),
    RELATIVE_VELOCITY_T((token, context, container) -> token.processAsDouble(Units.M_PER_S, context.getParsedUnitsBehavior(), container::setRelativeVelocityT)),
    RELATIVE_VELOCITY_N((token, context, container) -> token.processAsDouble(Units.M_PER_S, context.getParsedUnitsBehavior(), container::setRelativeVelocityN)),
    START_SCREEN_PERIOD((token, context, container) -> token.processAsDate(container::setStartScreenPeriod, context)),
    STOP_SCREEN_PERIOD((token, context, container) -> token.processAsDate(container::setStopScreenPeriod, context)),
    SCREEN_VOLUME_FRAME((token, context, container) -> token.processAsEnum(ScreenVolumeFrame.class, container::setScreenVolumeFrame)),
    SCREEN_VOLUME_SHAPE((token, context, container) -> token.processAsEnum(ScreenVolumeShape.class, container::setScreenVolumeShape)),
    SCREEN_VOLUME_X((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setScreenVolumeX)),
    SCREEN_VOLUME_Y((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setScreenVolumeY)),
    SCREEN_VOLUME_Z((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setScreenVolumeZ)),
    SCREEN_ENTRY_TIME((token, context, container) -> token.processAsDate(container::setScreenEntryTime, context)),
    SCREEN_EXIT_TIME((token, context, container) -> token.processAsDate(container::setScreenExitTime, context)),
    COLLISION_PROBABILITY((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setCollisionProbability)),
    COLLISION_PROBABILITY_METHOD((token, context, container) -> {
        if (token.getType() == TokenType.ENTRY) {
            container.setCollisionProbaMethod(PocMethodFacade.parse(token.getContentAsNormalizedString()));
        }
        return true;
    });

    private final TokenProcessor processor;

    private CdmRelativeMetadataKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, CdmRelativeMetadata container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, CdmRelativeMetadata var3);
    }
}

