/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.PocMethodFacade;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.cdm.CdmRelativeMetadataKey;
import org.orekit.files.ccsds.ndm.cdm.ScreenVolumeFrame;
import org.orekit.files.ccsds.ndm.cdm.ScreenVolumeShape;
import org.orekit.time.AbsoluteDate;

public class CdmRelativeMetadata {
    private TimeSystem timeSystem;
    private List<String> comment = new ArrayList<String>();
    private AbsoluteDate tca;
    private double missDistance;
    private double relativeSpeed = Double.NaN;
    private double relativePositionR = Double.NaN;
    private double relativePositionT = Double.NaN;
    private double relativePositionN = Double.NaN;
    private double relativeVelocityR = Double.NaN;
    private double relativeVelocityT = Double.NaN;
    private double relativeVelocityN = Double.NaN;
    private AbsoluteDate startScreenPeriod;
    private AbsoluteDate stopScreenPeriod;
    private ScreenVolumeFrame screenVolumeFrame;
    private ScreenVolumeShape screenVolumeShape;
    private double screenVolumeX = Double.NaN;
    private double screenVolumeY = Double.NaN;
    private double screenVolumeZ = Double.NaN;
    private AbsoluteDate screenEntryTime;
    private AbsoluteDate screenExitTime;
    private double collisionProbability = Double.NaN;
    private PocMethodFacade collisionProbabilityMethod;

    public void validate() {
        this.checkNotNull(this.tca, CdmRelativeMetadataKey.TCA);
        this.checkNotNull(this.missDistance, CdmRelativeMetadataKey.MISS_DISTANCE);
    }

    public AbsoluteDate getTca() {
        return this.tca;
    }

    public void setTca(AbsoluteDate tca) {
        this.tca = tca;
    }

    public double getMissDistance() {
        return this.missDistance;
    }

    public void setMissDistance(double missDistance) {
        this.missDistance = missDistance;
    }

    public double getRelativeSpeed() {
        return this.relativeSpeed;
    }

    public void setRelativeSpeed(double relativeSpeed) {
        this.relativeSpeed = relativeSpeed;
    }

    public Vector3D getRelativeVelocity() {
        return new Vector3D(this.relativeVelocityR, this.relativeVelocityT, this.relativeVelocityN);
    }

    public Vector3D getRelativePosition() {
        return new Vector3D(this.relativePositionR, this.relativePositionT, this.relativePositionN);
    }

    public void setRelativePositionR(double relativePositionR) {
        this.relativePositionR = relativePositionR;
    }

    public void setRelativePositionT(double relativePositionT) {
        this.relativePositionT = relativePositionT;
    }

    public void setRelativePositionN(double relativePositionN) {
        this.relativePositionN = relativePositionN;
    }

    public void setRelativeVelocityR(double relativeVelocityR) {
        this.relativeVelocityR = relativeVelocityR;
    }

    public void setRelativeVelocityT(double relativeVelocityT) {
        this.relativeVelocityT = relativeVelocityT;
    }

    public void setRelativeVelocityN(double relativeVelocityN) {
        this.relativeVelocityN = relativeVelocityN;
    }

    public AbsoluteDate getStartScreenPeriod() {
        return this.startScreenPeriod;
    }

    public void setStartScreenPeriod(AbsoluteDate startScreenPeriod) {
        this.startScreenPeriod = startScreenPeriod;
    }

    public AbsoluteDate getStopScreenPeriod() {
        return this.stopScreenPeriod;
    }

    public void setStopScreenPeriod(AbsoluteDate stopScreenPeriod) {
        this.stopScreenPeriod = stopScreenPeriod;
    }

    public ScreenVolumeFrame getScreenVolumeFrame() {
        return this.screenVolumeFrame;
    }

    public void setScreenVolumeFrame(ScreenVolumeFrame screenVolumeFrame) {
        this.screenVolumeFrame = screenVolumeFrame;
    }

    public ScreenVolumeShape getScreenVolumeShape() {
        return this.screenVolumeShape;
    }

    public void setScreenVolumeShape(ScreenVolumeShape screenVolumeShape) {
        this.screenVolumeShape = screenVolumeShape;
    }

    public double getScreenVolumeX() {
        return this.screenVolumeX;
    }

    public void setScreenVolumeX(double screenVolumeX) {
        this.screenVolumeX = screenVolumeX;
    }

    public double getScreenVolumeY() {
        return this.screenVolumeY;
    }

    public void setScreenVolumeY(double screenVolumeY) {
        this.screenVolumeY = screenVolumeY;
    }

    public double getScreenVolumeZ() {
        return this.screenVolumeZ;
    }

    public void setScreenVolumeZ(double screenVolumeZ) {
        this.screenVolumeZ = screenVolumeZ;
    }

    public AbsoluteDate getScreenEntryTime() {
        return this.screenEntryTime;
    }

    public void setScreenEntryTime(AbsoluteDate screenEntryTime) {
        this.screenEntryTime = screenEntryTime;
    }

    public AbsoluteDate getScreenExitTime() {
        return this.screenExitTime;
    }

    public void setScreenExitTime(AbsoluteDate screenExitTime) {
        this.screenExitTime = screenExitTime;
    }

    public double getCollisionProbability() {
        return this.collisionProbability;
    }

    public void setCollisionProbability(double collisionProbability) {
        this.collisionProbability = collisionProbability;
    }

    public PocMethodFacade getCollisionProbaMethod() {
        return this.collisionProbabilityMethod;
    }

    public void setCollisionProbaMethod(PocMethodFacade collisionProbaMethod) {
        this.collisionProbabilityMethod = collisionProbaMethod;
    }

    public void checkNotNull(Object field, Enum<?> key) {
        if (field == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, key.name());
        }
    }

    public void setTimeSystem(TimeSystem timeSystem) {
        this.timeSystem = timeSystem;
    }

    public TimeSystem getTimeSystem() {
        return this.timeSystem;
    }

    public void addComment(String comments) {
        this.comment.add(comments);
    }

    public List<String> getComment() {
        return this.comment;
    }
}

