/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.cdm.AdditionalParameters;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;

public enum AdditionalParametersKey {
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    AREA_PC((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setAreaPC)),
    AREA_DRG((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setAreaDRG)),
    AREA_SRP((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setAreaDRG)),
    MASS((token, context, container) -> token.processAsDouble(Unit.KILOGRAM, context.getParsedUnitsBehavior(), container::setMass)),
    CD_AREA_OVER_MASS((token, context, container) -> token.processAsDouble(Units.M2_PER_KG, context.getParsedUnitsBehavior(), container::setCDAreaOverMass)),
    CR_AREA_OVER_MASS((token, context, container) -> token.processAsDouble(Units.M2_PER_KG, context.getParsedUnitsBehavior(), container::setCRAreaOverMass)),
    THRUST_ACCELERATION((token, context, container) -> token.processAsDouble(Units.M_PER_S2, context.getParsedUnitsBehavior(), container::setThrustAcceleration)),
    SEDR((token, context, container) -> token.processAsDouble(Units.W_PER_KG, context.getParsedUnitsBehavior(), container::setSedr));

    private final TokenProcessor processor;

    private AdditionalParametersKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, AdditionalParameters container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, AdditionalParameters var3);
    }
}

