/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.filtering.kalman.extended.ExtendedKalmanFilter;
import org.hipparchus.filtering.kalman.extended.NonLinearEvolution;
import org.hipparchus.filtering.kalman.extended.NonLinearProcess;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.modifiers.DynamicOutlierFilter;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.EskfMeasurementHandler;
import org.orekit.estimation.sequential.KalmanEstimation;
import org.orekit.estimation.sequential.KalmanObserver;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.estimation.sequential.SemiAnalyticalKalmanEstimator;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.DSSTPropagatorBuilder;
import org.orekit.propagation.semianalytical.dsst.DSSTHarvester;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class SemiAnalyticalKalmanModel
implements KalmanEstimation,
NonLinearProcess<MeasurementDecorator> {
    private final DSSTPropagatorBuilder builder;
    private final ParameterDriversList estimatedOrbitalParameters;
    private final ParameterDriversList estimatedPropagationParameters;
    private final ParameterDriversList estimatedMeasurementsParameters;
    private final Map<String, Integer> propagationParameterColumns;
    private final Map<String, Integer> measurementParameterColumns;
    private final double[] scale;
    private final CovarianceMatrixProvider covarianceMatrixProvider;
    private final CovarianceMatrixProvider measurementProcessNoiseMatrix;
    private DSSTHarvester harvester;
    private DSSTPropagator dsstPropagator;
    private KalmanObserver observer;
    private int currentMeasurementNumber;
    private AbsoluteDate currentDate;
    private RealVector predictedFilterCorrection;
    private RealVector correctedFilterCorrection;
    private EstimatedMeasurement<?> predictedMeasurement;
    private EstimatedMeasurement<?> correctedMeasurement;
    private SpacecraftState nominalMeanSpacecraftState;
    private SpacecraftState previousNominalMeanSpacecraftState;
    private ProcessEstimate correctedEstimate;
    private RealMatrix phiS;
    private RealMatrix psiS;

    protected SemiAnalyticalKalmanModel(DSSTPropagatorBuilder propagatorBuilder, CovarianceMatrixProvider covarianceMatrixProvider, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        this.builder = propagatorBuilder;
        this.estimatedMeasurementsParameters = estimatedMeasurementParameters;
        this.measurementParameterColumns = new HashMap<String, Integer>(this.estimatedMeasurementsParameters.getDrivers().size());
        this.observer = null;
        this.currentMeasurementNumber = 0;
        this.currentDate = propagatorBuilder.getInitialOrbitDate();
        this.covarianceMatrixProvider = covarianceMatrixProvider;
        this.measurementProcessNoiseMatrix = measurementProcessNoiseMatrix;
        int columns = 0;
        this.estimatedOrbitalParameters = new ParameterDriversList();
        for (ParameterDriver parameterDriver : this.builder.getOrbitalParametersDrivers().getDrivers()) {
            if (parameterDriver.getReferenceDate() == null) {
                parameterDriver.setReferenceDate(this.currentDate);
            }
            if (!parameterDriver.isSelected()) continue;
            this.estimatedOrbitalParameters.add(parameterDriver);
            ++columns;
        }
        this.estimatedPropagationParameters = new ParameterDriversList();
        ArrayList<String> estimatedPropagationParametersNames = new ArrayList<String>();
        for (ParameterDriver parameterDriver : this.builder.getPropagationParametersDrivers().getDrivers()) {
            if (parameterDriver.getReferenceDate() == null) {
                parameterDriver.setReferenceDate(this.currentDate);
            }
            if (!parameterDriver.isSelected()) continue;
            this.estimatedPropagationParameters.add(parameterDriver);
            String string = parameterDriver.getName();
            if (estimatedPropagationParametersNames.contains(string)) continue;
            estimatedPropagationParametersNames.add(string);
        }
        estimatedPropagationParametersNames.sort(Comparator.naturalOrder());
        this.propagationParameterColumns = new HashMap<String, Integer>(estimatedPropagationParametersNames.size());
        for (String string : estimatedPropagationParametersNames) {
            this.propagationParameterColumns.put(string, columns);
            ++columns;
        }
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            if (parameterDriver.getReferenceDate() == null) {
                parameterDriver.setReferenceDate(this.currentDate);
            }
            this.measurementParameterColumns.put(parameterDriver.getName(), columns);
            ++columns;
        }
        this.scale = new double[columns];
        boolean bl = false;
        for (ParameterDriver parameterDriver : this.estimatedOrbitalParameters.getDrivers()) {
            this.scale[++var7_12] = parameterDriver.getScale();
        }
        for (ParameterDriver parameterDriver : this.estimatedPropagationParameters.getDrivers()) {
            this.scale[++var7_13] = parameterDriver.getScale();
        }
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            this.scale[++var7_14] = parameterDriver.getScale();
        }
        this.updateReferenceTrajectory(this.getEstimatedPropagator());
        this.previousNominalMeanSpacecraftState = this.nominalMeanSpacecraftState = this.dsstPropagator.getInitialState();
        this.harvester.initializeFieldShortPeriodTerms(this.nominalMeanSpacecraftState);
        this.correctedFilterCorrection = this.predictedFilterCorrection = MatrixUtils.createRealVector((int)columns);
        this.psiS = null;
        if (this.estimatedPropagationParameters.getNbParams() != 0) {
            this.psiS = MatrixUtils.createRealMatrix((int)this.getNumberSelectedOrbitalDrivers(), (int)this.getNumberSelectedPropagationDrivers());
        }
        this.phiS = MatrixUtils.createRealIdentityMatrix((int)this.getNumberSelectedOrbitalDrivers());
        int n = this.getNumberSelectedMeasurementDrivers();
        int n2 = this.getNumberSelectedOrbitalDrivers() + this.getNumberSelectedPropagationDrivers();
        RealMatrix noiseK = MatrixUtils.createRealMatrix((int)(n2 + n), (int)(n2 + n));
        RealMatrix noiseP = covarianceMatrixProvider.getInitialCovarianceMatrix(this.nominalMeanSpacecraftState);
        noiseK.setSubMatrix(noiseP.getData(), 0, 0);
        if (measurementProcessNoiseMatrix != null) {
            RealMatrix noiseM = measurementProcessNoiseMatrix.getInitialCovarianceMatrix(this.nominalMeanSpacecraftState);
            noiseK.setSubMatrix(noiseM.getData(), n2, n2);
        }
        this.checkDimension(noiseK.getRowDimension(), this.builder.getOrbitalParametersDrivers(), this.builder.getPropagationParametersDrivers(), this.estimatedMeasurementsParameters);
        RealMatrix correctedCovariance = this.normalizeCovarianceMatrix(noiseK);
        this.correctedEstimate = new ProcessEstimate(0.0, this.correctedFilterCorrection, correctedCovariance);
    }

    public KalmanObserver getObserver() {
        return this.observer;
    }

    public void setObserver(KalmanObserver observer) {
        this.observer = observer;
    }

    public ProcessEstimate getEstimate() {
        return this.correctedEstimate;
    }

    public DSSTPropagator processMeasurements(List<ObservedMeasurement<?>> observedMeasurements, ExtendedKalmanFilter<MeasurementDecorator> filter) {
        try {
            observedMeasurements.sort(new ChronologicalComparator());
            EskfMeasurementHandler stepHandler = new EskfMeasurementHandler(this, filter, observedMeasurements, this.builder.getInitialOrbitDate());
            this.dsstPropagator.getMultiplexer().add(stepHandler);
            this.dsstPropagator.propagate(observedMeasurements.get(0).getDate(), observedMeasurements.get(observedMeasurements.size() - 1).getDate());
            return this.getEstimatedPropagator();
        }
        catch (MathRuntimeException mrte) {
            throw new OrekitException(mrte);
        }
    }

    public DSSTPropagator getEstimatedPropagator() {
        return this.builder.buildPropagator(this.builder.getSelectedNormalizedParameters());
    }

    public NonLinearEvolution getEvolution(double previousTime, RealVector previousState, MeasurementDecorator measurement) {
        ObservedMeasurement<?> observedMeasurement = measurement.getObservedMeasurement();
        for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
            if (driver.getReferenceDate() != null) continue;
            driver.setReferenceDate(this.builder.getInitialOrbitDate());
        }
        ++this.currentMeasurementNumber;
        this.currentDate = measurement.getObservedMeasurement().getDate();
        RealMatrix stm = this.getErrorStateTransitionMatrix();
        this.predictedFilterCorrection = this.predictFilterCorrection(stm);
        this.analyticalDerivativeComputations(this.nominalMeanSpacecraftState);
        double[] osculating = this.computeOsculatingElements(this.predictedFilterCorrection);
        Orbit osculatingOrbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(osculating, null, this.builder.getPositionAngle(), this.currentDate, this.nominalMeanSpacecraftState.getMu(), this.nominalMeanSpacecraftState.getFrame());
        this.predictedMeasurement = observedMeasurement.estimate(this.currentMeasurementNumber, this.currentMeasurementNumber, new SpacecraftState[]{new SpacecraftState(osculatingOrbit, this.nominalMeanSpacecraftState.getAttitude(), this.nominalMeanSpacecraftState.getMass(), this.nominalMeanSpacecraftState.getAdditionalStatesValues(), this.nominalMeanSpacecraftState.getAdditionalStatesDerivatives())});
        RealMatrix measurementMatrix = this.getMeasurementMatrix();
        int nbMeas = this.getNumberSelectedMeasurementDrivers();
        int nbDyn = this.getNumberSelectedOrbitalDrivers() + this.getNumberSelectedPropagationDrivers();
        RealMatrix noiseK = MatrixUtils.createRealMatrix((int)(nbDyn + nbMeas), (int)(nbDyn + nbMeas));
        RealMatrix noiseP = this.covarianceMatrixProvider.getProcessNoiseMatrix(this.previousNominalMeanSpacecraftState, this.nominalMeanSpacecraftState);
        noiseK.setSubMatrix(noiseP.getData(), 0, 0);
        if (this.measurementProcessNoiseMatrix != null) {
            RealMatrix noiseM = this.measurementProcessNoiseMatrix.getProcessNoiseMatrix(this.previousNominalMeanSpacecraftState, this.nominalMeanSpacecraftState);
            noiseK.setSubMatrix(noiseM.getData(), nbDyn, nbDyn);
        }
        this.checkDimension(noiseK.getRowDimension(), this.builder.getOrbitalParametersDrivers(), this.builder.getPropagationParametersDrivers(), this.estimatedMeasurementsParameters);
        RealMatrix normalizedProcessNoise = this.normalizeCovarianceMatrix(noiseK);
        return new NonLinearEvolution(measurement.getTime(), this.predictedFilterCorrection, stm, normalizedProcessNoise, measurementMatrix);
    }

    public RealVector getInnovation(MeasurementDecorator measurement, NonLinearEvolution evolution, RealMatrix innovationCovarianceMatrix) {
        this.applyDynamicOutlierFilter(this.predictedMeasurement, innovationCovarianceMatrix);
        if (this.predictedMeasurement.getStatus() == EstimatedMeasurement.Status.REJECTED) {
            return null;
        }
        double[] observed = this.predictedMeasurement.getObservedMeasurement().getObservedValue();
        double[] estimated = this.predictedMeasurement.getEstimatedValue();
        double[] sigma = this.predictedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation();
        double[] residuals = new double[observed.length];
        for (int i = 0; i < observed.length; ++i) {
            residuals[i] = (observed[i] - estimated[i]) / sigma[i];
        }
        return MatrixUtils.createRealVector((double[])residuals);
    }

    public void finalizeEstimation(ObservedMeasurement<?> observedMeasurement, ProcessEstimate estimate) {
        this.correctedEstimate = estimate;
        this.correctedFilterCorrection = estimate.getState();
        this.previousNominalMeanSpacecraftState = this.nominalMeanSpacecraftState;
        double[] osculating = this.computeOsculatingElements(this.correctedFilterCorrection);
        Orbit osculatingOrbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(osculating, null, this.builder.getPositionAngle(), this.currentDate, this.nominalMeanSpacecraftState.getMu(), this.nominalMeanSpacecraftState.getFrame());
        this.correctedMeasurement = observedMeasurement.estimate(this.currentMeasurementNumber, this.currentMeasurementNumber, new SpacecraftState[]{new SpacecraftState(osculatingOrbit, this.nominalMeanSpacecraftState.getAttitude(), this.nominalMeanSpacecraftState.getMass(), this.nominalMeanSpacecraftState.getAdditionalStatesValues(), this.nominalMeanSpacecraftState.getAdditionalStatesDerivatives())});
    }

    public void finalizeOperationsObservationGrid() {
        this.updateParameters();
    }

    @Override
    public ParameterDriversList getEstimatedOrbitalParameters() {
        return this.estimatedOrbitalParameters;
    }

    @Override
    public ParameterDriversList getEstimatedPropagationParameters() {
        return this.estimatedPropagationParameters;
    }

    @Override
    public ParameterDriversList getEstimatedMeasurementsParameters() {
        return this.estimatedMeasurementsParameters;
    }

    @Override
    public SpacecraftState[] getPredictedSpacecraftStates() {
        return new SpacecraftState[]{this.nominalMeanSpacecraftState};
    }

    @Override
    public SpacecraftState[] getCorrectedSpacecraftStates() {
        return new SpacecraftState[]{this.getEstimatedPropagator().getInitialState()};
    }

    @Override
    public RealVector getPhysicalEstimatedState() {
        ArrayRealVector physicalEstimatedState = new ArrayRealVector(this.scale.length);
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedOrbitalParameters().getDrivers()) {
            physicalEstimatedState.setEntry(i++, driver.getValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedPropagationParameters().getDrivers()) {
            physicalEstimatedState.setEntry(i++, driver.getValue());
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            physicalEstimatedState.setEntry(i++, driver.getValue());
        }
        return physicalEstimatedState;
    }

    @Override
    public RealMatrix getPhysicalEstimatedCovarianceMatrix() {
        RealMatrix normalizedP = this.correctedEstimate.getCovariance();
        int nbParams = normalizedP.getRowDimension();
        RealMatrix physicalP = MatrixUtils.createRealMatrix((int)nbParams, (int)nbParams);
        for (int i = 0; i < nbParams; ++i) {
            for (int j = 0; j < nbParams; ++j) {
                physicalP.setEntry(i, j, normalizedP.getEntry(i, j) * this.scale[i] * this.scale[j]);
            }
        }
        return physicalP;
    }

    @Override
    public RealMatrix getPhysicalStateTransitionMatrix() {
        RealMatrix normalizedSTM = this.correctedEstimate.getStateTransitionMatrix();
        if (normalizedSTM == null) {
            return null;
        }
        int nbParams = normalizedSTM.getRowDimension();
        RealMatrix physicalSTM = MatrixUtils.createRealMatrix((int)nbParams, (int)nbParams);
        for (int i = 0; i < nbParams; ++i) {
            for (int j = 0; j < nbParams; ++j) {
                physicalSTM.setEntry(i, j, normalizedSTM.getEntry(i, j) * this.scale[i] / this.scale[j]);
            }
        }
        return physicalSTM;
    }

    @Override
    public RealMatrix getPhysicalMeasurementJacobian() {
        RealMatrix normalizedH = this.correctedEstimate.getMeasurementJacobian();
        if (normalizedH == null) {
            return null;
        }
        double[] sigmas = this.predictedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation();
        int nbLine = normalizedH.getRowDimension();
        int nbCol = normalizedH.getColumnDimension();
        RealMatrix physicalH = MatrixUtils.createRealMatrix((int)nbLine, (int)nbCol);
        for (int i = 0; i < nbLine; ++i) {
            for (int j = 0; j < nbCol; ++j) {
                physicalH.setEntry(i, j, normalizedH.getEntry(i, j) * sigmas[i] / this.scale[j]);
            }
        }
        return physicalH;
    }

    @Override
    public RealMatrix getPhysicalInnovationCovarianceMatrix() {
        RealMatrix normalizedS = this.correctedEstimate.getInnovationCovariance();
        if (normalizedS == null) {
            return null;
        }
        double[] sigmas = this.predictedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation();
        int nbMeas = sigmas.length;
        RealMatrix physicalS = MatrixUtils.createRealMatrix((int)nbMeas, (int)nbMeas);
        for (int i = 0; i < nbMeas; ++i) {
            for (int j = 0; j < nbMeas; ++j) {
                physicalS.setEntry(i, j, normalizedS.getEntry(i, j) * sigmas[i] * sigmas[j]);
            }
        }
        return physicalS;
    }

    @Override
    public RealMatrix getPhysicalKalmanGain() {
        RealMatrix normalizedK = this.correctedEstimate.getKalmanGain();
        if (normalizedK == null) {
            return null;
        }
        double[] sigmas = this.predictedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation();
        int nbLine = normalizedK.getRowDimension();
        int nbCol = normalizedK.getColumnDimension();
        RealMatrix physicalK = MatrixUtils.createRealMatrix((int)nbLine, (int)nbCol);
        for (int i = 0; i < nbLine; ++i) {
            for (int j = 0; j < nbCol; ++j) {
                physicalK.setEntry(i, j, normalizedK.getEntry(i, j) * this.scale[i] / sigmas[j]);
            }
        }
        return physicalK;
    }

    @Override
    public int getCurrentMeasurementNumber() {
        return this.currentMeasurementNumber;
    }

    @Override
    public AbsoluteDate getCurrentDate() {
        return this.currentDate;
    }

    @Override
    public EstimatedMeasurement<?> getPredictedMeasurement() {
        return this.predictedMeasurement;
    }

    @Override
    public EstimatedMeasurement<?> getCorrectedMeasurement() {
        return this.correctedMeasurement;
    }

    public void updateNominalSpacecraftState(SpacecraftState nominal) {
        this.nominalMeanSpacecraftState = nominal;
        this.builder.resetOrbit(nominal.getOrbit(), PropagationType.MEAN);
    }

    public void updateReferenceTrajectory(DSSTPropagator propagator) {
        this.dsstPropagator = propagator;
        String equationName = SemiAnalyticalKalmanEstimator.class.getName() + "-derivatives-";
        SpacecraftState meanState = this.dsstPropagator.initialIsOsculating() ? DSSTPropagator.computeMeanState(this.dsstPropagator.getInitialState(), this.dsstPropagator.getAttitudeProvider(), this.dsstPropagator.getAllForceModels()) : this.dsstPropagator.getInitialState();
        this.dsstPropagator.setInitialState(meanState, PropagationType.MEAN);
        this.harvester = (DSSTHarvester)this.dsstPropagator.setupMatricesComputation(equationName, null, null);
    }

    public void updateShortPeriods(SpacecraftState state) {
        for (DSSTForceModel model : this.builder.getAllForceModels()) {
            model.updateShortPeriodTerms(model.getParameters(), state);
        }
        this.harvester.updateFieldShortPeriodTerms(state);
    }

    public void initializeShortPeriodicTerms(SpacecraftState meanState) {
        ArrayList<ShortPeriodTerms> shortPeriodTerms = new ArrayList<ShortPeriodTerms>();
        for (DSSTForceModel force : this.builder.getAllForceModels()) {
            shortPeriodTerms.addAll(force.initializeShortPeriodTerms(new AuxiliaryElements(meanState.getOrbit(), 1), PropagationType.OSCULATING, force.getParameters()));
        }
        this.dsstPropagator.setShortPeriodTerms(shortPeriodTerms);
    }

    private RealMatrix getErrorStateTransitionMatrix() {
        int i;
        RealMatrix stm = MatrixUtils.createRealIdentityMatrix((int)this.correctedEstimate.getState().getDimension());
        int nbOrb = this.getNumberSelectedOrbitalDrivers();
        RealMatrix dYdY0 = this.harvester.getB2(this.nominalMeanSpacecraftState);
        RealMatrix phi = dYdY0.multiply(this.phiS);
        List<ParameterDriversList.DelegatingDriver> drivers = this.builder.getOrbitalParametersDrivers().getDrivers();
        for (i = 0; i < nbOrb; ++i) {
            if (!drivers.get(i).isSelected()) continue;
            int jOrb = 0;
            for (int j = 0; j < nbOrb; ++j) {
                if (!drivers.get(j).isSelected()) continue;
                stm.setEntry(i, jOrb++, phi.getEntry(i, j));
            }
        }
        this.phiS = new QRDecomposition(dYdY0).getSolver().getInverse();
        if (this.psiS != null) {
            int nbProp = this.getNumberSelectedPropagationDrivers();
            RealMatrix dYdPp = this.harvester.getB3(this.nominalMeanSpacecraftState);
            RealMatrix psi = dYdPp.subtract(phi.multiply(this.psiS));
            for (int i2 = 0; i2 < nbOrb; ++i2) {
                for (int j = 0; j < nbProp; ++j) {
                    stm.setEntry(i2, j + nbOrb, psi.getEntry(i2, j));
                }
            }
            this.psiS = dYdPp;
        }
        for (i = 0; i < this.scale.length; ++i) {
            for (int j = 0; j < this.scale.length; ++j) {
                stm.setEntry(i, j, stm.getEntry(i, j) * this.scale[j] / this.scale[i]);
            }
        }
        return stm;
    }

    private RealMatrix getMeasurementMatrix() {
        SpacecraftState evaluationState = this.predictedMeasurement.getStates()[0];
        Object observedMeasurement = this.predictedMeasurement.getObservedMeasurement();
        double[] sigma = this.predictedMeasurement.getObservedMeasurement().getTheoreticalStandardDeviation();
        RealMatrix measurementMatrix = MatrixUtils.createRealMatrix((int)observedMeasurement.getDimension(), (int)this.correctedEstimate.getState().getDimension());
        Orbit predictedOrbit = evaluationState.getOrbit();
        int nbOrb = this.getNumberSelectedOrbitalDrivers();
        int nbProp = this.getNumberSelectedPropagationDrivers();
        double[][] aCY = new double[nbOrb][nbOrb];
        predictedOrbit.getJacobianWrtParameters(this.builder.getPositionAngle(), aCY);
        Array2DRowRealMatrix dCdY = new Array2DRowRealMatrix(aCY, false);
        Array2DRowRealMatrix dMdC = new Array2DRowRealMatrix(this.predictedMeasurement.getStateDerivatives(0), false);
        RealMatrix dMdY = dMdC.multiply((RealMatrix)dCdY);
        RealMatrix IpB1B4 = MatrixUtils.createRealMatrix((int)nbOrb, (int)(nbOrb + nbProp));
        RealMatrix B1 = this.harvester.getB1();
        RealMatrix I = MatrixUtils.createRealIdentityMatrix((int)nbOrb);
        RealMatrix IpB1 = I.add(B1);
        IpB1B4.setSubMatrix(IpB1.getData(), 0, 0);
        if (this.psiS != null) {
            RealMatrix B4 = this.harvester.getB4();
            IpB1B4.setSubMatrix(B4.getData(), 0, nbOrb);
        }
        dMdY = dMdY.multiply(IpB1B4);
        for (int i = 0; i < dMdY.getRowDimension(); ++i) {
            double driverScale;
            int j;
            for (j = 0; j < nbOrb; ++j) {
                driverScale = this.builder.getOrbitalParametersDrivers().getDrivers().get(j).getScale();
                measurementMatrix.setEntry(i, j, dMdY.getEntry(i, j) / sigma[i] * driverScale);
            }
            for (j = 0; j < nbProp; ++j) {
                driverScale = this.estimatedPropagationParameters.getDrivers().get(j).getScale();
                measurementMatrix.setEntry(i, j + nbOrb, dMdY.getEntry(i, j + nbOrb) / sigma[i] * driverScale);
            }
        }
        for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            double[] aMPm = this.predictedMeasurement.getParameterDerivatives(driver);
            if (this.measurementParameterColumns.get(driver.getName()) == null) continue;
            int driverColumn = this.measurementParameterColumns.get(driver.getName());
            for (int i = 0; i < aMPm.length; ++i) {
                measurementMatrix.setEntry(i, driverColumn, aMPm[i] / sigma[i] * driver.getScale());
            }
        }
        return measurementMatrix;
    }

    private RealVector predictFilterCorrection(RealMatrix stm) {
        return stm.operate(this.correctedFilterCorrection);
    }

    private double[] computeOsculatingElements(RealVector filterCorrection) {
        int nbOrb = this.getNumberSelectedOrbitalDrivers();
        RealMatrix B1 = this.harvester.getB1();
        double[] shortPeriodTerms = this.dsstPropagator.getShortPeriodTermsValue(this.nominalMeanSpacecraftState);
        RealVector physicalFilterCorrection = MatrixUtils.createRealVector((int)nbOrb);
        for (int index = 0; index < nbOrb; ++index) {
            physicalFilterCorrection.addToEntry(index, filterCorrection.getEntry(index) * this.scale[index]);
        }
        RealVector B1Correction = B1.operate(physicalFilterCorrection);
        double[] nominalMeanElements = new double[nbOrb];
        OrbitType.EQUINOCTIAL.mapOrbitToArray(this.nominalMeanSpacecraftState.getOrbit(), this.builder.getPositionAngle(), nominalMeanElements, null);
        double[] osculatingElements = new double[nbOrb];
        for (int i = 0; i < nbOrb; ++i) {
            osculatingElements[i] = nominalMeanElements[i] + physicalFilterCorrection.getEntry(i) + shortPeriodTerms[i] + B1Correction.getEntry(i);
        }
        return osculatingElements;
    }

    private void analyticalDerivativeComputations(SpacecraftState state) {
        this.harvester.setReferenceState(state);
    }

    private RealMatrix normalizeCovarianceMatrix(RealMatrix physicalCovarianceMatrix) {
        int nbParams = physicalCovarianceMatrix.getRowDimension();
        RealMatrix normalizedCovarianceMatrix = MatrixUtils.createRealMatrix((int)nbParams, (int)nbParams);
        for (int i = 0; i < nbParams; ++i) {
            for (int j = 0; j < nbParams; ++j) {
                normalizedCovarianceMatrix.setEntry(i, j, physicalCovarianceMatrix.getEntry(i, j) / (this.scale[i] * this.scale[j]));
            }
        }
        return normalizedCovarianceMatrix;
    }

    private void checkDimension(int dimension, ParameterDriversList orbitalParameters, ParameterDriversList propagationParameters, ParameterDriversList measurementParameters) {
        int requiredDimension = orbitalParameters.getNbParams();
        for (ParameterDriver parameterDriver : propagationParameters.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            ++requiredDimension;
        }
        for (ParameterDriver parameterDriver : measurementParameters.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            ++requiredDimension;
        }
        if (dimension != requiredDimension) {
            StringBuilder strBuilder = new StringBuilder();
            for (ParameterDriver parameterDriver : orbitalParameters.getDrivers()) {
                if (strBuilder.length() > 0) {
                    strBuilder.append(", ");
                }
                strBuilder.append(parameterDriver.getName());
            }
            for (ParameterDriver parameterDriver : propagationParameters.getDrivers()) {
                if (!parameterDriver.isSelected()) continue;
                strBuilder.append(parameterDriver.getName());
            }
            for (ParameterDriver parameterDriver : measurementParameters.getDrivers()) {
                if (!parameterDriver.isSelected()) continue;
                strBuilder.append(parameterDriver.getName());
            }
            throw new OrekitException((Localizable)OrekitMessages.DIMENSION_INCONSISTENT_WITH_PARAMETERS, dimension, strBuilder.toString());
        }
    }

    private <T extends ObservedMeasurement<T>> void applyDynamicOutlierFilter(EstimatedMeasurement<T> measurement, RealMatrix innovationCovarianceMatrix) {
        T observedMeasurement = measurement.getObservedMeasurement();
        for (EstimationModifier<T> modifier : observedMeasurement.getModifiers()) {
            if (!(modifier instanceof DynamicOutlierFilter)) continue;
            DynamicOutlierFilter dynamicOutlierFilter = (DynamicOutlierFilter)modifier;
            double[] sigmaDynamic = new double[innovationCovarianceMatrix.getColumnDimension()];
            double[] sigmaMeasurement = observedMeasurement.getTheoreticalStandardDeviation();
            for (int i = 0; i < sigmaDynamic.length; ++i) {
                sigmaDynamic[i] = FastMath.sqrt((double)innovationCovarianceMatrix.getEntry(i, i)) * sigmaMeasurement[i];
            }
            dynamicOutlierFilter.setSigma(sigmaDynamic);
            modifier.modify(measurement);
            dynamicOutlierFilter.setSigma(null);
        }
    }

    private int getNumberSelectedOrbitalDrivers() {
        return this.estimatedOrbitalParameters.getNbParams();
    }

    private int getNumberSelectedPropagationDrivers() {
        return this.estimatedPropagationParameters.getNbParams();
    }

    private int getNumberSelectedMeasurementDrivers() {
        return this.estimatedMeasurementsParameters.getNbParams();
    }

    private void updateParameters() {
        RealVector correctedState = this.correctedEstimate.getState();
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedOrbitalParameters().getDrivers()) {
            driver.setNormalizedValue(driver.getNormalizedValue() + correctedState.getEntry(i++));
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedPropagationParameters().getDrivers()) {
            driver.setNormalizedValue(driver.getNormalizedValue() + correctedState.getEntry(i++));
        }
        for (ParameterDriversList.DelegatingDriver driver : this.getEstimatedMeasurementsParameters().getDrivers()) {
            driver.setNormalizedValue(driver.getNormalizedValue() + correctedState.getEntry(i++));
        }
    }
}

