/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.List;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.filtering.kalman.Measurement;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.filtering.kalman.extended.ExtendedKalmanFilter;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.PV;
import org.orekit.estimation.measurements.Position;
import org.orekit.estimation.sequential.KalmanObserver;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.estimation.sequential.SemiAnalyticalKalmanModel;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public class EskfMeasurementHandler
implements OrekitStepHandler {
    private final SemiAnalyticalKalmanModel model;
    private final ExtendedKalmanFilter<MeasurementDecorator> filter;
    private final List<ObservedMeasurement<?>> observedMeasurements;
    private int index;
    private AbsoluteDate referenceDate;
    private KalmanObserver observer;

    public EskfMeasurementHandler(SemiAnalyticalKalmanModel model, ExtendedKalmanFilter<MeasurementDecorator> filter, List<ObservedMeasurement<?>> observedMeasurements, AbsoluteDate referenceDate) {
        this.model = model;
        this.filter = filter;
        this.observer = model.getObserver();
        this.observedMeasurements = observedMeasurements;
        this.referenceDate = referenceDate;
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.index = 0;
        this.model.initializeShortPeriodicTerms(s0);
        this.model.updateShortPeriods(s0);
    }

    @Override
    public void handleStep(OrekitStepInterpolator interpolator) {
        AbsoluteDate currentDate = interpolator.getCurrentState().getDate();
        this.model.updateShortPeriods(interpolator.getCurrentState());
        while (this.index < this.observedMeasurements.size() && this.observedMeasurements.get(this.index).getDate().compareTo(currentDate) < 0) {
            try {
                this.model.updateNominalSpacecraftState(interpolator.getInterpolatedState(this.observedMeasurements.get(this.index).getDate()));
                ProcessEstimate estimate = this.filter.estimationStep((Measurement)this.decorate(this.observedMeasurements.get(this.index)));
                this.model.finalizeEstimation(this.observedMeasurements.get(this.index), estimate);
                if (this.observer != null) {
                    this.observer.evaluationPerformed(this.model);
                }
            }
            catch (MathRuntimeException mrte) {
                throw new OrekitException(mrte);
            }
            ++this.index;
        }
        this.model.finalizeOperationsObservationGrid();
    }

    private MeasurementDecorator decorate(ObservedMeasurement<?> observedMeasurement) {
        RealMatrix covariance;
        if (observedMeasurement instanceof PV) {
            PV pv = (PV)observedMeasurement;
            covariance = MatrixUtils.createRealMatrix((double[][])pv.getCorrelationCoefficientsMatrix());
        } else if (observedMeasurement instanceof Position) {
            Position position = (Position)observedMeasurement;
            covariance = MatrixUtils.createRealMatrix((double[][])position.getCorrelationCoefficientsMatrix());
        } else {
            covariance = MatrixUtils.createRealIdentityMatrix((int)observedMeasurement.getDimension());
        }
        return new MeasurementDecorator(observedMeasurement, covariance, this.referenceDate);
    }
}

