/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.InterSatellitesRange;
import org.orekit.estimation.measurements.modifiers.AbstractRelativisticJ2ClockModifier;
import org.orekit.utils.ParameterDriver;

public class RelativisticJ2ClockInterSatellitesRangeModifier
extends AbstractRelativisticJ2ClockModifier
implements EstimationModifier<InterSatellitesRange> {
    public RelativisticJ2ClockInterSatellitesRangeModifier(double gm, double c20, double equatorialRadius) {
        super(gm, c20, equatorialRadius);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<InterSatellitesRange> estimated) {
        double dtJ2 = this.relativisticJ2Correction(estimated);
        double[] newValue = (double[])estimated.getEstimatedValue().clone();
        newValue[0] = newValue[0] - dtJ2 * 2.99792458E8;
        estimated.setEstimatedValue(newValue);
    }
}

