/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.lang.invoke.LambdaMetafactory;
import org.hipparchus.CalculusFieldElement;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.RangeRate;
import org.orekit.estimation.measurements.modifiers.BaseRangeRateIonosphericDelayModifier;
import org.orekit.estimation.measurements.modifiers.ModifierGradientConverter;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffectGradient;
import org.orekit.estimation.measurements.modifiers.RangeModifierUtil;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;

public class RangeRateIonosphericDelayModifier
extends BaseRangeRateIonosphericDelayModifier
implements EstimationModifier<RangeRate> {
    private final double fTwoWay;

    public RangeRateIonosphericDelayModifier(IonosphericModel model, double freq, boolean twoWay) {
        super(model, freq);
        this.fTwoWay = twoWay ? 2.0 : 1.0;
    }

    @Override
    protected double rangeRateErrorIonosphericModel(GroundStation station, SpacecraftState state) {
        return this.fTwoWay * super.rangeRateErrorIonosphericModel(station, state);
    }

    @Override
    protected <T extends CalculusFieldElement<T>> T rangeRateErrorIonosphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        return (T)((CalculusFieldElement)super.rangeRateErrorIonosphericModel(station, state, parameters).multiply(this.fTwoWay));
    }

    @Override
    public void modify(EstimatedMeasurement<RangeRate> estimated) {
        RangeRate measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        RangeModifierUtil.modify(estimated, this.getIonoModel(), new ModifierGradientConverter(state, 6, new InertialProvider(state.getFrame())), station, this::rangeRateErrorIonosphericModel, (ParametricModelEffectGradient)LambdaMetafactory.metafactory(null, null, null, (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;, rangeRateErrorIonosphericModel(org.orekit.estimation.measurements.GroundStation org.orekit.propagation.FieldSpacecraftState org.hipparchus.CalculusFieldElement[] ), (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;)((RangeRateIonosphericDelayModifier)this));
    }
}

