/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.gnss.OneWayGNSSPhase;
import org.orekit.frames.Transform;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OnBoardAntennaOneWayGNSSPhaseModifier
implements EstimationModifier<OneWayGNSSPhase> {
    private final Vector3D antennaPhaseCenter1;
    private final Vector3D antennaPhaseCenter2;
    private final AttitudeProvider attitude;

    public OnBoardAntennaOneWayGNSSPhaseModifier(Vector3D antennaPhaseCenter1, Vector3D antennaPhaseCenter2, AttitudeProvider attitude) {
        this.antennaPhaseCenter1 = antennaPhaseCenter1;
        this.antennaPhaseCenter2 = antennaPhaseCenter2;
        this.attitude = attitude;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<OneWayGNSSPhase> estimated) {
        TimeStampedPVCoordinates[] phaseParticipants = estimated.getParticipants();
        AbsoluteDate phaseEmissionDate = phaseParticipants[0].getDate();
        AbsoluteDate phaseReceptionDate = phaseParticipants[1].getDate();
        SpacecraftState refStateLocal = estimated.getStates()[0];
        SpacecraftState receptionState = refStateLocal.shiftedBy(phaseReceptionDate.durationFrom(refStateLocal.getDate()));
        Transform receptionSpacecraftToInert = receptionState.toTransform().getInverse();
        CartesianOrbit orbitRemote = new CartesianOrbit(phaseParticipants[0], refStateLocal.getFrame(), receptionState.getMu());
        SpacecraftState refStateRemote = new SpacecraftState((Orbit)orbitRemote, this.attitude.getAttitude(orbitRemote, orbitRemote.getDate(), orbitRemote.getFrame()));
        SpacecraftState emissionState = refStateRemote.shiftedBy(phaseEmissionDate.durationFrom(refStateRemote.getDate()));
        Transform emissionSpacecraftToInert = emissionState.toTransform().getInverse();
        Vector3D pSpacecraftReception = receptionSpacecraftToInert.transformPosition(Vector3D.ZERO);
        Vector3D pSpacecraftEmission = emissionSpacecraftToInert.transformPosition(Vector3D.ZERO);
        double oneWayGNSSPhaseUsingSpacecraftCenter = Vector3D.distance((Vector3D)pSpacecraftEmission, (Vector3D)pSpacecraftReception);
        Vector3D pAPCReception = receptionSpacecraftToInert.transformPosition(this.antennaPhaseCenter1);
        Vector3D pAPCEmission = emissionSpacecraftToInert.transformPosition(this.antennaPhaseCenter2);
        double oneWayGNSSPhaseUsingAntennaPhaseCenter = Vector3D.distance((Vector3D)pAPCEmission, (Vector3D)pAPCReception);
        double[] value = estimated.getEstimatedValue();
        double wavelength = estimated.getObservedMeasurement().getWavelength();
        value[0] = value[0] + (oneWayGNSSPhaseUsingAntennaPhaseCenter - oneWayGNSSPhaseUsingSpacecraftCenter) / wavelength;
        estimated.setEstimatedValue(value);
    }
}

